/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.mixins.transformers.feature.ice.common.ice4j;

import gg.essential.lib.ice4j.ice.Agent;
import gg.essential.lib.ice4j.ice.CandidatePair;
import gg.essential.lib.ice4j.ice.Component;
import gg.essential.lib.ice4j.ice.IceMediaStream;
import gg.essential.lib.ice4j.ice.LocalCandidate;
import gg.essential.lib.ice4j.ice.RelayedCandidate;
import gg.essential.lib.ice4j.stack.StunStack;
import gg.essential.lib.jitsi.utils.logging2.Logger;
import java.util.HashSet;
import java.util.List;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Agent.class}, remap=false)
public abstract class Mixin_CleanupUnusedRelayCandidates {
    @Shadow
    @Final
    private Logger logger;

    @Shadow
    public abstract List<IceMediaStream> getStreams();

    @Shadow
    public abstract StunStack getStunStack();

    @Inject(method={"checkListStatesUpdated"}, at={@At(value="INVOKE", target="Lgg/essential/lib/ice4j/ice/Agent;scheduleStunKeepAlive()V")})
    private void closeRelayCandidatesWeNoLongerNeed(CallbackInfo ci) {
        HashSet<RelayedCandidate> usedRelayCandidates = new HashSet<RelayedCandidate>();
        HashSet<RelayedCandidate> allRelayCandidates = new HashSet<RelayedCandidate>();
        for (IceMediaStream stream : this.getStreams()) {
            for (Component component3 : stream.getComponents()) {
                LocalCandidate selectedCandidate;
                CandidatePair selectedPair = component3.getSelectedPair();
                if (selectedPair != null && (selectedCandidate = selectedPair.getLocalCandidate()) instanceof RelayedCandidate) {
                    usedRelayCandidates.add((RelayedCandidate)selectedCandidate);
                }
                for (LocalCandidate localCandidate : component3.getLocalCandidates()) {
                    if (!(localCandidate instanceof RelayedCandidate)) continue;
                    allRelayCandidates.add((RelayedCandidate)localCandidate);
                }
            }
        }
        for (RelayedCandidate candidate2 : allRelayCandidates) {
            if (usedRelayCandidates.contains(candidate2)) continue;
            this.logger.debug("Closing " + candidate2.toShortString() + " because we no longer need it.");
            this.getStunStack().removeSocket(candidate2.getTransportAddress());
        }
    }
}

