/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.mixins.transformers.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import gg.essential.config.EssentialConfig;
import gg.essential.gui.common.EmulatedUI3DPlayer;
import gg.essential.lib.kotgl.matrix.matrices.mutables.MutableMat4;
import gg.essential.mixins.impl.client.entity.AbstractClientPlayerExt;
import gg.essential.mixins.impl.client.model.CapePoseSupplier;
import gg.essential.mixins.transformers.client.model.ModelPlayerAccessor;
import gg.essential.model.backend.PlayerPose;
import gg.essential.model.backend.minecraft.PlayerPoseKt;
import gg.essential.util.GLUtil;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.layers.CapeLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CapeLayer.class})
public abstract class Mixin_ApplyPoseTransform_Cape
extends RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>
implements CapePoseSupplier {
    private static final String RENDER_LAYER = "render(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/client/player/AbstractClientPlayer;FFFFFF)V";
    private static final String PUSH_MATRIX = "Lcom/mojang/blaze3d/vertex/PoseStack;pushPose()V";
    private static final String RENDER_CAPE = "Lnet/minecraft/client/model/PlayerModel;renderCloak(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;II)V";
    @Unique
    private PlayerPose.Part renderedPose;
    @Unique
    private PlayerPose.Part resetPose;

    @Inject(method={"render(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/client/player/AbstractClientPlayer;FFFFFF)V"}, at={@At(value="HEAD")})
    private void unsetRenderedPose(CallbackInfo ci) {
        this.renderedPose = null;
    }

    @Inject(method={"render(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/client/player/AbstractClientPlayer;FFFFFF)V"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;pushPose()V", shift=At.Shift.AFTER)})
    private void isolateCapeMatrix(PoseStack matrixStack, MultiBufferSource buffer, int light, AbstractClientPlayer player2, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo ci) {
        if (this.emotesDisabled(player2).booleanValue()) {
            return;
        }
        matrixStack.m_85850_().m_85861_().m_27624_();
    }

    @Inject(method={"render(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/client/player/AbstractClientPlayer;FFFFFF)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/model/PlayerModel;renderCloak(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;II)V")})
    private void applyPoseTransform(PoseStack matrixStack, MultiBufferSource buffer, int light, AbstractClientPlayer player2, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo ci) {
        if (this.emotesDisabled(player2).booleanValue()) {
            return;
        }
        float scale2 = 0.0625f;
        AbstractClientPlayerExt playerExt = (AbstractClientPlayerExt)player2;
        ModelPart capeModel = this.getCapeModel();
        MutableMat4 capeMatrix = GLUtil.INSTANCE.glGetMatrix(matrixStack, scale2);
        matrixStack.m_85849_();
        matrixStack.m_85836_();
        PlayerPose basePose = PlayerPoseKt.withCapePose(PlayerPose.Companion.neutral(), capeModel, capeMatrix);
        PlayerPose transformedPose = playerExt.getPoseManager().computePose(playerExt.getWearablesManager(), basePose);
        this.renderedPose = transformedPose.getCape();
        if (basePose.equals(transformedPose)) {
            GLUtil.INSTANCE.glMultMatrix(matrixStack, capeMatrix, scale2);
            return;
        }
        this.resetPose = PlayerPoseKt.toPose(capeModel);
        PlayerPoseKt.applyTo(transformedPose.getCape(), capeModel);
    }

    @Inject(method={"render(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/client/player/AbstractClientPlayer;FFFFFF)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/model/PlayerModel;renderCloak(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;II)V", shift=At.Shift.AFTER)})
    private void resetPose(CallbackInfo ci) {
        if (this.resetPose != null) {
            PlayerPoseKt.applyTo(this.resetPose, this.getCapeModel());
            this.resetPose = null;
        }
    }

    @Unique
    private ModelPart getCapeModel() {
        return ((ModelPlayerAccessor)this.m_117386_()).getCape();
    }

    @Unique
    private Boolean emotesDisabled(AbstractClientPlayer player2) {
        return EssentialConfig.INSTANCE.getDisableEmotes() && !(player2 instanceof EmulatedUI3DPlayer.EmulatedPlayer);
    }

    @Override
    @Nullable
    public PlayerPose.Part getCapePose() {
        return this.renderedPose;
    }

    Mixin_ApplyPoseTransform_Cape() {
        super(null);
    }
}

