/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.mixins.impl.client.model;

import gg.essential.config.EssentialConfig;
import gg.essential.cosmetics.WearablesManager;
import gg.essential.gui.common.EmulatedUI3DPlayer;
import gg.essential.gui.emotes.EmoteWheel;
import gg.essential.mixins.impl.client.entity.AbstractClientPlayerExt;
import gg.essential.mixins.impl.client.model.ModelBipedExt;
import gg.essential.model.backend.PlayerPose;
import gg.essential.model.backend.minecraft.PlayerPoseKt;
import gg.essential.model.util.PlayerPoseManager;
import gg.essential.util.UUIDUtil;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.world.entity.Entity;

public class ModelBipedUtil {
    public static void resetPose(HumanoidModel model) {
        ModelBipedExt ext = (ModelBipedExt)model;
        if (ext.getResetPose() == null) {
            ext.setResetPose(PlayerPoseKt.toPose(model));
        } else {
            boolean isChild = model.f_102610_;
            PlayerPoseKt.applyTo(ext.getResetPose(), model);
            model.f_102610_ = isChild;
        }
    }

    public static void applyPoseTransform(HumanoidModel model, Entity entity) {
        if (!(entity instanceof AbstractClientPlayerExt)) {
            return;
        }
        if (EmoteWheel.isPlayerArmRendering) {
            return;
        }
        AbstractClientPlayerExt playerExt = (AbstractClientPlayerExt)entity;
        playerExt.setPoseModified(false);
        if (EssentialConfig.INSTANCE.getDisableEmotes() && !(entity instanceof EmulatedUI3DPlayer.EmulatedPlayer)) {
            return;
        }
        WearablesManager wearablesManager2 = playerExt.getWearablesManager();
        PlayerPoseManager poseManager = playerExt.getPoseManager();
        if (entity.m_142081_().equals(UUIDUtil.getClientUUID()) && (model.f_102815_ == HumanoidModel.ArmPose.BOW_AND_ARROW || model.f_102816_ == HumanoidModel.ArmPose.BOW_AND_ARROW || model.f_102815_ == HumanoidModel.ArmPose.THROW_SPEAR || model.f_102816_ == HumanoidModel.ArmPose.THROW_SPEAR || model.f_102815_ == HumanoidModel.ArmPose.CROSSBOW_CHARGE || model.f_102816_ == HumanoidModel.ArmPose.CROSSBOW_CHARGE)) {
            EmoteWheel.unequipCurrentEmote();
        }
        poseManager.update(wearablesManager2);
        PlayerPose basePose = PlayerPoseKt.toPose(model);
        PlayerPose transformedPose = poseManager.computePose(wearablesManager2, basePose);
        if (basePose.equals(transformedPose)) {
            return;
        }
        PlayerPoseKt.applyTo(transformedPose, model);
        playerExt.setPoseModified(true);
    }
}

