/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.typesafeconfig.impl;

import gg.essential.lib.typesafeconfig.ConfigException;
import gg.essential.lib.typesafeconfig.ConfigResolveOptions;
import gg.essential.lib.typesafeconfig.impl.AbstractConfigObject;
import gg.essential.lib.typesafeconfig.impl.AbstractConfigValue;
import gg.essential.lib.typesafeconfig.impl.ConfigImpl;
import gg.essential.lib.typesafeconfig.impl.ConfigReference;
import gg.essential.lib.typesafeconfig.impl.MemoKey;
import gg.essential.lib.typesafeconfig.impl.Path;
import gg.essential.lib.typesafeconfig.impl.ResolveMemos;
import gg.essential.lib.typesafeconfig.impl.ResolveResult;
import gg.essential.lib.typesafeconfig.impl.ResolveSource;
import gg.essential.lib.typesafeconfig.impl.ResolveStatus;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;

final class ResolveContext {
    private final ResolveMemos memos;
    private final ConfigResolveOptions options;
    private final Path restrictToChild;
    private final List<AbstractConfigValue> resolveStack;
    private final Set<AbstractConfigValue> cycleMarkers;

    ResolveContext(ResolveMemos memos, ConfigResolveOptions options2, Path restrictToChild, List<AbstractConfigValue> resolveStack, Set<AbstractConfigValue> cycleMarkers) {
        this.memos = memos;
        this.options = options2;
        this.restrictToChild = restrictToChild;
        this.resolveStack = resolveStack;
        this.cycleMarkers = cycleMarkers;
    }

    private static Set<AbstractConfigValue> newCycleMarkers() {
        return Collections.newSetFromMap(new IdentityHashMap());
    }

    ResolveContext(ConfigResolveOptions options2, Path restrictToChild) {
        this(new ResolveMemos(), options2, restrictToChild, new ArrayList<AbstractConfigValue>(), ResolveContext.newCycleMarkers());
        if (ConfigImpl.traceSubstitutionsEnabled()) {
            ConfigImpl.trace(this.depth(), "ResolveContext restrict to child " + restrictToChild);
        }
    }

    ResolveContext addCycleMarker(AbstractConfigValue value2) {
        if (ConfigImpl.traceSubstitutionsEnabled()) {
            ConfigImpl.trace(this.depth(), "++ Cycle marker " + value2 + "@" + System.identityHashCode(value2));
        }
        if (this.cycleMarkers.contains(value2)) {
            throw new ConfigException.BugOrBroken("Added cycle marker twice " + value2);
        }
        Set<AbstractConfigValue> copy = ResolveContext.newCycleMarkers();
        copy.addAll(this.cycleMarkers);
        copy.add(value2);
        return new ResolveContext(this.memos, this.options, this.restrictToChild, this.resolveStack, copy);
    }

    ResolveContext removeCycleMarker(AbstractConfigValue value2) {
        if (ConfigImpl.traceSubstitutionsEnabled()) {
            ConfigImpl.trace(this.depth(), "-- Cycle marker " + value2 + "@" + System.identityHashCode(value2));
        }
        Set<AbstractConfigValue> copy = ResolveContext.newCycleMarkers();
        copy.addAll(this.cycleMarkers);
        copy.remove(value2);
        return new ResolveContext(this.memos, this.options, this.restrictToChild, this.resolveStack, copy);
    }

    private ResolveContext memoize(MemoKey key, AbstractConfigValue value2) {
        ResolveMemos changed = this.memos.put(key, value2);
        return new ResolveContext(changed, this.options, this.restrictToChild, this.resolveStack, this.cycleMarkers);
    }

    ConfigResolveOptions options() {
        return this.options;
    }

    boolean isRestrictedToChild() {
        return this.restrictToChild != null;
    }

    Path restrictToChild() {
        return this.restrictToChild;
    }

    ResolveContext restrict(Path restrictTo) {
        if (restrictTo == this.restrictToChild) {
            return this;
        }
        return new ResolveContext(this.memos, this.options, restrictTo, this.resolveStack, this.cycleMarkers);
    }

    ResolveContext unrestricted() {
        return this.restrict(null);
    }

    String traceString() {
        String separator = ", ";
        StringBuilder sb = new StringBuilder();
        for (AbstractConfigValue value2 : this.resolveStack) {
            if (!(value2 instanceof ConfigReference)) continue;
            sb.append(((ConfigReference)value2).expression().toString());
            sb.append(separator);
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - separator.length());
        }
        return sb.toString();
    }

    private ResolveContext pushTrace(AbstractConfigValue value2) {
        if (ConfigImpl.traceSubstitutionsEnabled()) {
            ConfigImpl.trace(this.depth(), "pushing trace " + value2);
        }
        ArrayList<AbstractConfigValue> copy = new ArrayList<AbstractConfigValue>(this.resolveStack);
        copy.add(value2);
        return new ResolveContext(this.memos, this.options, this.restrictToChild, copy, this.cycleMarkers);
    }

    ResolveContext popTrace() {
        ArrayList<AbstractConfigValue> copy = new ArrayList<AbstractConfigValue>(this.resolveStack);
        AbstractConfigValue old = (AbstractConfigValue)copy.remove(this.resolveStack.size() - 1);
        if (ConfigImpl.traceSubstitutionsEnabled()) {
            ConfigImpl.trace(this.depth() - 1, "popped trace " + old);
        }
        return new ResolveContext(this.memos, this.options, this.restrictToChild, copy, this.cycleMarkers);
    }

    int depth() {
        if (this.resolveStack.size() > 30) {
            throw new ConfigException.BugOrBroken("resolve getting too deep");
        }
        return this.resolveStack.size();
    }

    ResolveResult<? extends AbstractConfigValue> resolve(AbstractConfigValue original, ResolveSource source) throws AbstractConfigValue.NotPossibleToResolve {
        if (ConfigImpl.traceSubstitutionsEnabled()) {
            ConfigImpl.trace(this.depth(), "resolving " + original + " restrictToChild=" + this.restrictToChild + " in " + source);
        }
        return this.pushTrace(original).realResolve(original, source).popTrace();
    }

    private ResolveResult<? extends AbstractConfigValue> realResolve(AbstractConfigValue original, ResolveSource source) throws AbstractConfigValue.NotPossibleToResolve {
        MemoKey fullKey = new MemoKey(original, null);
        MemoKey restrictedKey = null;
        AbstractConfigValue cached = this.memos.get(fullKey);
        if (cached == null && this.isRestrictedToChild()) {
            restrictedKey = new MemoKey(original, this.restrictToChild());
            cached = this.memos.get(restrictedKey);
        }
        if (cached != null) {
            if (ConfigImpl.traceSubstitutionsEnabled()) {
                ConfigImpl.trace(this.depth(), "using cached resolution " + cached + " for " + original + " restrictToChild " + this.restrictToChild());
            }
            return ResolveResult.make(this, cached);
        }
        if (ConfigImpl.traceSubstitutionsEnabled()) {
            ConfigImpl.trace(this.depth(), "not found in cache, resolving " + original + "@" + System.identityHashCode(original));
        }
        if (this.cycleMarkers.contains(original)) {
            if (ConfigImpl.traceSubstitutionsEnabled()) {
                ConfigImpl.trace(this.depth(), "Cycle detected, can't resolve; " + original + "@" + System.identityHashCode(original));
            }
            throw new AbstractConfigValue.NotPossibleToResolve(this);
        }
        ResolveResult<? extends AbstractConfigValue> result = original.resolveSubstitutions(this, source);
        Object resolved2 = result.value;
        if (ConfigImpl.traceSubstitutionsEnabled()) {
            ConfigImpl.trace(this.depth(), "resolved to " + resolved2 + "@" + System.identityHashCode(resolved2) + " from " + original + "@" + System.identityHashCode(resolved2));
        }
        ResolveContext withMemo = result.context;
        if (resolved2 == null || ((AbstractConfigValue)resolved2).resolveStatus() == ResolveStatus.RESOLVED) {
            if (ConfigImpl.traceSubstitutionsEnabled()) {
                ConfigImpl.trace(this.depth(), "caching " + fullKey + " result " + resolved2);
            }
            withMemo = withMemo.memoize(fullKey, (AbstractConfigValue)resolved2);
        } else if (this.isRestrictedToChild()) {
            if (restrictedKey == null) {
                throw new ConfigException.BugOrBroken("restrictedKey should not be null here");
            }
            if (ConfigImpl.traceSubstitutionsEnabled()) {
                ConfigImpl.trace(this.depth(), "caching " + restrictedKey + " result " + resolved2);
            }
            withMemo = withMemo.memoize(restrictedKey, (AbstractConfigValue)resolved2);
        } else if (this.options().getAllowUnresolved()) {
            if (ConfigImpl.traceSubstitutionsEnabled()) {
                ConfigImpl.trace(this.depth(), "caching " + fullKey + " result " + resolved2);
            }
            withMemo = withMemo.memoize(fullKey, (AbstractConfigValue)resolved2);
        } else {
            throw new ConfigException.BugOrBroken("resolveSubstitutions() did not give us a resolved object");
        }
        return ResolveResult.make(withMemo, resolved2);
    }

    static AbstractConfigValue resolve(AbstractConfigValue value2, AbstractConfigObject root, ConfigResolveOptions options2) {
        ResolveSource source = new ResolveSource(root);
        ResolveContext context = new ResolveContext(options2, null);
        try {
            return context.resolve((AbstractConfigValue)value2, (ResolveSource)source).value;
        }
        catch (AbstractConfigValue.NotPossibleToResolve e) {
            throw new ConfigException.BugOrBroken("NotPossibleToResolve was thrown from an outermost resolve", e);
        }
    }
}

