/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.typesafeconfig.impl;

import gg.essential.lib.typesafeconfig.ConfigException;
import gg.essential.lib.typesafeconfig.impl.AbstractConfigNode;
import gg.essential.lib.typesafeconfig.impl.AbstractConfigNodeValue;
import gg.essential.lib.typesafeconfig.impl.ConfigNodeComment;
import gg.essential.lib.typesafeconfig.impl.ConfigNodePath;
import gg.essential.lib.typesafeconfig.impl.ConfigNodeSingleToken;
import gg.essential.lib.typesafeconfig.impl.Token;
import gg.essential.lib.typesafeconfig.impl.Tokens;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

final class ConfigNodeField
extends AbstractConfigNode {
    private final ArrayList<AbstractConfigNode> children;

    public ConfigNodeField(Collection<AbstractConfigNode> children) {
        this.children = new ArrayList<AbstractConfigNode>(children);
    }

    @Override
    protected Collection<Token> tokens() {
        ArrayList<Token> tokens = new ArrayList<Token>();
        for (AbstractConfigNode child : this.children) {
            tokens.addAll(child.tokens());
        }
        return tokens;
    }

    public ConfigNodeField replaceValue(AbstractConfigNodeValue newValue) {
        ArrayList<AbstractConfigNode> childrenCopy = new ArrayList<AbstractConfigNode>(this.children);
        for (int i2 = 0; i2 < childrenCopy.size(); ++i2) {
            if (!(childrenCopy.get(i2) instanceof AbstractConfigNodeValue)) continue;
            childrenCopy.set(i2, newValue);
            return new ConfigNodeField(childrenCopy);
        }
        throw new ConfigException.BugOrBroken("Field node doesn't have a value");
    }

    public AbstractConfigNodeValue value() {
        for (int i2 = 0; i2 < this.children.size(); ++i2) {
            if (!(this.children.get(i2) instanceof AbstractConfigNodeValue)) continue;
            return (AbstractConfigNodeValue)this.children.get(i2);
        }
        throw new ConfigException.BugOrBroken("Field node doesn't have a value");
    }

    public ConfigNodePath path() {
        for (int i2 = 0; i2 < this.children.size(); ++i2) {
            if (!(this.children.get(i2) instanceof ConfigNodePath)) continue;
            return (ConfigNodePath)this.children.get(i2);
        }
        throw new ConfigException.BugOrBroken("Field node doesn't have a path");
    }

    protected Token separator() {
        for (AbstractConfigNode child : this.children) {
            Token t;
            if (!(child instanceof ConfigNodeSingleToken) || (t = ((ConfigNodeSingleToken)child).token()) != Tokens.PLUS_EQUALS && t != Tokens.COLON && t != Tokens.EQUALS) continue;
            return t;
        }
        return null;
    }

    protected List<String> comments() {
        ArrayList<String> comments = new ArrayList<String>();
        for (AbstractConfigNode child : this.children) {
            if (!(child instanceof ConfigNodeComment)) continue;
            comments.add(((ConfigNodeComment)child).commentText());
        }
        return comments;
    }
}

