/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.mixinextras.utils;

import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.spongepowered.asm.mixin.injection.struct.Target;

public class ASMUtils {
    public static String annotationToString(AnnotationNode annotation2) {
        StringBuilder builder = new StringBuilder("@").append(ASMUtils.typeToString(Type.getType((String)annotation2.desc)));
        List values = annotation2.values;
        if (values == null || values.isEmpty()) {
            return builder.toString();
        }
        builder.append('(');
        for (int i2 = 0; i2 < values.size(); i2 += 2) {
            if (i2 != 0) {
                builder.append(", ");
            }
            String name2 = (String)values.get(i2);
            Object value2 = values.get(i2 + 1);
            builder.append(name2).append(" = ").append(ASMUtils.valueToString(value2));
        }
        builder.append(')');
        return builder.toString();
    }

    public static String typeToString(Type type) {
        String name2 = type.getClassName();
        return name2.substring(name2.lastIndexOf(46) + 1).replace('$', '.');
    }

    private static String valueToString(Object value2) {
        if (value2 instanceof String) {
            return '\"' + value2.toString() + '\"';
        }
        if (value2 instanceof Type) {
            Type type = (Type)value2;
            return ASMUtils.typeToString(type) + ".class";
        }
        if (value2 instanceof String[]) {
            String[] enumInfo = (String[])value2;
            return ASMUtils.typeToString(Type.getType((String)enumInfo[0])) + '.' + enumInfo[1];
        }
        if (value2 instanceof AnnotationNode) {
            return ASMUtils.annotationToString((AnnotationNode)value2);
        }
        if (value2 instanceof List) {
            List list = (List)value2;
            if (list.size() == 1) {
                return ASMUtils.valueToString(list.get(0));
            }
            return '{' + list.stream().map(ASMUtils::valueToString).collect(Collectors.joining(", ")) + '}';
        }
        return value2.toString();
    }

    public static boolean isPrimitive(Type type) {
        return type.getDescriptor().length() == 1;
    }

    public static MethodInsnNode getInvokeInstruction(ClassNode owner, MethodNode method) {
        boolean isInterface;
        boolean bl = isInterface = (owner.access & 0x200) != 0;
        int opcode = (method.access & 8) != 0 ? 184 : ((method.access & 2) != 0 ? 183 : (isInterface ? 185 : 182));
        return new MethodInsnNode(opcode, owner.name, method.name, method.desc, isInterface);
    }

    public static int getDummyOpcodeForType(Type type) {
        switch (type.getSort()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return 3;
            }
            case 6: {
                return 11;
            }
            case 7: {
                return 9;
            }
            case 8: {
                return 14;
            }
            case 9: 
            case 10: {
                return 1;
            }
        }
        throw new UnsupportedOperationException();
    }

    public static MethodInsnNode findInitNodeFor(Target target2, TypeInsnNode newNode) {
        int start2 = target2.indexOf((AbstractInsnNode)newNode);
        int depth = 0;
        ListIterator it = target2.insns.iterator(start2);
        while (it.hasNext()) {
            AbstractInsnNode insn = (AbstractInsnNode)it.next();
            if (insn instanceof TypeInsnNode && insn.getOpcode() == 187) {
                TypeInsnNode typeNode = (TypeInsnNode)insn;
                if (!typeNode.desc.equals(newNode.desc)) continue;
                ++depth;
                continue;
            }
            if (!(insn instanceof MethodInsnNode) || insn.getOpcode() != 183) continue;
            MethodInsnNode methodNode = (MethodInsnNode)insn;
            if (!"<init>".equals(methodNode.name) || !methodNode.owner.equals(newNode.desc) || --depth != 0) continue;
            return methodNode;
        }
        return null;
    }
}

