/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.jitsi.utils.queue;

import gg.essential.lib.jitsi.utils.logging.Logger;
import gg.essential.lib.jitsi.utils.queue.ErrorHandler;
import gg.essential.lib.jitsi.utils.queue.PacketQueue;
import java.util.concurrent.atomic.AtomicLong;

public class CountingErrorHandler
implements ErrorHandler {
    private static final Logger logger = Logger.getLogger(PacketQueue.class);
    private final AtomicLong numPacketsDropped = new AtomicLong();
    private final AtomicLong numExceptions = new AtomicLong();

    @Override
    public void packetDropped() {
        this.numPacketsDropped.incrementAndGet();
    }

    @Override
    public void packetHandlingFailed(Throwable t) {
        logger.warn("Failed to handle packet: ", t);
        this.numExceptions.incrementAndGet();
    }

    public long getNumPacketsDropped() {
        return this.numPacketsDropped.get();
    }

    public long getNumExceptions() {
        return this.numExceptions.get();
    }
}

