/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.jitsi.utils.logging2;

import com.google.common.collect.ImmutableMap;
import gg.essential.lib.jitsi.utils.collections.JMap;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class LogContext {
    public static final String CONTEXT_START_TOKEN = "[";
    public static final String CONTEXT_END_TOKEN = "]";
    protected ImmutableMap<String, String> ancestorsContext;
    protected ImmutableMap<String, String> context;
    protected String formattedContext;
    private final List<WeakReference<LogContext>> childContexts = new ArrayList<WeakReference<LogContext>>();

    public LogContext() {
        this(Collections.emptyMap());
    }

    public LogContext(Map<String, String> context) {
        this(context, (ImmutableMap<String, String>)ImmutableMap.of());
    }

    protected LogContext(Map<String, String> context, ImmutableMap<String, String> ancestorsContext) {
        this.context = ImmutableMap.copyOf(context);
        this.ancestorsContext = ancestorsContext;
        this.updateFormattedContext();
    }

    protected synchronized void updateFormattedContext() {
        ImmutableMap<String, String> combined = LogContext.combineMaps(new Map[]{this.ancestorsContext, this.context});
        this.formattedContext = LogContext.formatContext(combined);
        this.updateChildren(combined);
    }

    public synchronized LogContext createSubContext(Map<String, String> childContextData) {
        ImmutableMap<String, String> childAncestorContext = LogContext.combineMaps(new Map[]{this.ancestorsContext, this.context});
        LogContext child = new LogContext(childContextData, childAncestorContext);
        this.childContexts.add(new WeakReference<LogContext>(child));
        return child;
    }

    public void addContext(String key, String value2) {
        this.addContext(JMap.of(key, value2));
    }

    public synchronized void addContext(Map<String, String> addedContext) {
        this.context = LogContext.combineMaps(new Map[]{this.context, addedContext});
        this.updateFormattedContext();
    }

    protected synchronized void updateChildren(ImmutableMap<String, String> newAncestorContext) {
        Iterator<WeakReference<LogContext>> iter2 = this.childContexts.iterator();
        while (iter2.hasNext()) {
            LogContext c = (LogContext)iter2.next().get();
            if (c != null) {
                c.ancestorContextUpdated(newAncestorContext);
                continue;
            }
            iter2.remove();
        }
    }

    protected synchronized void ancestorContextUpdated(ImmutableMap<String, String> newAncestorContext) {
        this.ancestorsContext = newAncestorContext;
        this.updateFormattedContext();
    }

    public String toString() {
        return this.formattedContext;
    }

    @SafeVarargs
    @NotNull
    protected static ImmutableMap<String, String> combineMaps(Map<String, String> ... maps) {
        HashMap<String, String> combinedMap = new HashMap<String, String>();
        for (Map<String, String> map2 : maps) {
            combinedMap.putAll(map2);
        }
        return ImmutableMap.copyOf(combinedMap);
    }

    protected static String formatContext(Map<String, String> context) {
        StringBuilder contextString = new StringBuilder();
        String data = context.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining(" "));
        contextString.append(data);
        if (contextString.length() > 0) {
            return CONTEXT_START_TOKEN + contextString + CONTEXT_END_TOKEN;
        }
        return "";
    }
}

