/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.jitsi.utils.event;

import gg.essential.lib.jitsi.utils.logging.Logger;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;

public class PropertyChangeNotifier {
    private static final Logger logger = Logger.getLogger(PropertyChangeNotifier.class);
    private final List<PropertyChangeListener> listeners = new ArrayList<PropertyChangeListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener listener2) {
        if (listener2 == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("The specified argument listener is null and that does not make sense.");
            }
        } else {
            List<PropertyChangeListener> list = this.listeners;
            synchronized (list) {
                if (!this.listeners.contains(listener2)) {
                    this.listeners.add(listener2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void firePropertyChange(String property2, Object oldValue, Object newValue) {
        PropertyChangeListener[] ls;
        List<PropertyChangeListener> list = this.listeners;
        synchronized (list) {
            ls = this.listeners.toArray(new PropertyChangeListener[this.listeners.size()]);
        }
        if (ls.length != 0) {
            PropertyChangeEvent ev = new PropertyChangeEvent(this.getPropertyChangeSource(property2, oldValue, newValue), property2, oldValue, newValue);
            for (PropertyChangeListener l : ls) {
                try {
                    l.propertyChange(ev);
                }
                catch (Throwable t) {
                    if (t instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                        continue;
                    }
                    if (t instanceof ThreadDeath) {
                        throw (ThreadDeath)t;
                    }
                    logger.warn("A PropertyChangeListener threw an exception while handling a PropertyChangeEvent.", t);
                }
            }
        }
    }

    protected Object getPropertyChangeSource(String property2, Object oldValue, Object newValue) {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(PropertyChangeListener listener2) {
        if (listener2 != null) {
            List<PropertyChangeListener> list = this.listeners;
            synchronized (list) {
                this.listeners.remove(listener2);
            }
        }
    }
}

