/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.jitsi.utils.concurrent;

import gg.essential.lib.jitsi.utils.concurrent.RecurringRunnable;
import gg.essential.lib.jitsi.utils.logging.Logger;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;

public class RecurringRunnableExecutor
implements Executor {
    private static final Logger logger = Logger.getLogger(RecurringRunnableExecutor.class);
    private final List<RecurringRunnable> recurringRunnables = new LinkedList<RecurringRunnable>();
    private Thread thread;
    private final String name;
    private boolean closed = false;

    public RecurringRunnableExecutor() {
        this("");
    }

    public RecurringRunnableExecutor(String name2) {
        this.name = name2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deRegisterRecurringRunnable(RecurringRunnable recurringRunnable) {
        if (recurringRunnable == null) {
            return false;
        }
        List<RecurringRunnable> list = this.recurringRunnables;
        synchronized (list) {
            boolean removed = this.recurringRunnables.remove(recurringRunnable);
            if (removed) {
                this.startOrNotifyThread();
            }
            return removed;
        }
    }

    @Override
    public void execute(Runnable command) {
        Objects.requireNonNull(command, "command");
        if (!(command instanceof RecurringRunnable)) {
            throw new RejectedExecutionException("The class " + command.getClass().getName() + " of command does not implement " + RecurringRunnable.class.getName());
        }
        this.registerRecurringRunnable((RecurringRunnable)command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean run() {
        long timeToNext;
        if (this.closed || !Thread.currentThread().equals(this.thread)) {
            return false;
        }
        long minTimeToNext = 100L;
        List<RecurringRunnable> list = this.recurringRunnables;
        synchronized (list) {
            if (this.recurringRunnables.isEmpty()) {
                return false;
            }
            for (RecurringRunnable recurringRunnable : this.recurringRunnables) {
                timeToNext = recurringRunnable.getTimeUntilNextRun();
                if (minTimeToNext <= timeToNext) continue;
                minTimeToNext = timeToNext;
            }
        }
        if (minTimeToNext > 0L) {
            list = this.recurringRunnables;
            synchronized (list) {
                if (this.recurringRunnables.isEmpty()) {
                    return false;
                }
                try {
                    this.recurringRunnables.wait(minTimeToNext);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                return true;
            }
        }
        list = this.recurringRunnables;
        synchronized (list) {
            for (RecurringRunnable recurringRunnable : this.recurringRunnables) {
                timeToNext = recurringRunnable.getTimeUntilNextRun();
                if (timeToNext >= 1L) continue;
                try {
                    recurringRunnable.run();
                }
                catch (Throwable t) {
                    if (t instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                        continue;
                    }
                    if (t instanceof ThreadDeath) {
                        throw (ThreadDeath)t;
                    }
                    logger.error("The invocation of the method " + recurringRunnable.getClass().getName() + ".run() threw an exception.", t);
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerRecurringRunnable(RecurringRunnable recurringRunnable) {
        Objects.requireNonNull(recurringRunnable, "recurringRunnable");
        List<RecurringRunnable> list = this.recurringRunnables;
        synchronized (list) {
            if (this.closed) {
                return false;
            }
            if (this.recurringRunnables.contains(recurringRunnable)) {
                return false;
            }
            this.recurringRunnables.add(0, recurringRunnable);
            this.startOrNotifyThread();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runInThread() {
        try {
            while (this.run()) {
            }
        }
        finally {
            List<RecurringRunnable> list = this.recurringRunnables;
            synchronized (list) {
                if (!this.closed && Thread.currentThread().equals(this.thread)) {
                    this.thread = null;
                    this.startOrNotifyThread();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startOrNotifyThread() {
        List<RecurringRunnable> list = this.recurringRunnables;
        synchronized (list) {
            if (!this.closed && this.thread == null) {
                if (!this.recurringRunnables.isEmpty()) {
                    Thread thread = new Thread(){

                        @Override
                        public void run() {
                            RecurringRunnableExecutor.this.runInThread();
                        }
                    };
                    thread.setDaemon(true);
                    thread.setName(RecurringRunnableExecutor.class.getName() + ".thread-" + this.name);
                    boolean started = false;
                    this.thread = thread;
                    try {
                        thread.start();
                        started = true;
                    }
                    finally {
                        if (!started && thread.equals(this.thread)) {
                            this.thread = null;
                        }
                    }
                }
            } else {
                this.recurringRunnables.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        List<RecurringRunnable> list = this.recurringRunnables;
        synchronized (list) {
            this.closed = true;
            this.thread = null;
            this.recurringRunnables.notifyAll();
        }
    }
}

