/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.jitsi.utils;

import com.sun.jna.Native;
import com.sun.jna.Platform;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import gg.essential.lib.jitsi.utils.logging.Logger;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.regex.Pattern;

public final class JNIUtils {
    private static final Pattern DYLIB_PATTERN = Pattern.compile("\\.dylib$");
    private static final Logger logger = Logger.getLogger(JNIUtils.class);

    public static void loadLibrary(String libname, ClassLoader classLoader) {
        JNIUtils.loadLibrary(libname, null, classLoader);
    }

    public static <T> void loadLibrary(String libname, Class<T> clazz) {
        JNIUtils.loadLibrary(libname, clazz, clazz.getClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> void loadLibrary(String libname, Class<T> clazz, ClassLoader classLoader) {
        try {
            System.loadLibrary(libname);
            logger.info("Loading library " + libname + " from java.library.path rather than bundled version");
            return;
        }
        catch (UnsatisfiedLinkError e) {
            try {
                if (clazz == null) {
                    throw e;
                }
                JNIUtils.loadNativeInClassloader(libname, clazz, false);
            }
            catch (UnsatisfiedLinkError ulerr) {
                File embedded;
                libname = System.mapLibraryName(libname);
                if (Platform.isMac()) {
                    libname = DYLIB_PATTERN.matcher(libname).replaceFirst(".jnilib");
                }
                try {
                    embedded = Native.extractFromResourcePath((String)("/" + Platform.RESOURCE_PREFIX + "/" + libname), (ClassLoader)classLoader);
                }
                catch (IOException ioex) {
                    throw ulerr;
                }
                try {
                    if (clazz != null) {
                        JNIUtils.loadNativeInClassloader(embedded.getAbsolutePath(), clazz, true);
                    } else {
                        System.load(embedded.getAbsolutePath());
                    }
                }
                finally {
                    if (embedded.getName().startsWith("jna") && !embedded.delete()) {
                        embedded.deleteOnExit();
                    }
                }
            }
            return;
        }
    }

    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"})
    private static <T> void loadNativeInClassloader(String lib, Class<T> clazz, boolean isAbsolute) {
        try {
            Method loadLibrary0 = Runtime.getRuntime().getClass().getDeclaredMethod(isAbsolute ? "load0" : "loadLibrary0", Class.class, String.class);
            loadLibrary0.setAccessible(true);
            loadLibrary0.invoke((Object)Runtime.getRuntime(), clazz, lib);
        }
        catch (Exception e) {
            System.loadLibrary(lib);
        }
    }

    private JNIUtils() {
    }
}

