/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.jitsi.utils;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import gg.essential.lib.jitsi.service.configuration.ConfigurationService;
import gg.essential.lib.jitsi.utils.PasswordUtil;
import java.io.File;
import java.util.Map;
import java.util.regex.Pattern;

public class ConfigUtils {
    @SuppressFBWarnings(value={"UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD", "MS_SHOULD_BE_FINAL"})
    public static String PASSWORD_CMD_LINE_ARGS;
    @SuppressFBWarnings(value={"UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD", "MS_SHOULD_BE_FINAL"})
    public static String PASSWORD_SYS_PROPS;

    public static File getAbsoluteFile(String path, ConfigurationService cfg) {
        File file = new File(path);
        if (!file.isAbsolute()) {
            String scHomeDirName;
            String scHomeDirLocation;
            if (cfg == null) {
                scHomeDirLocation = System.getProperty("net.java.sip.communicator.SC_HOME_DIR_LOCATION");
                scHomeDirName = System.getProperty("net.java.sip.communicator.SC_HOME_DIR_NAME");
            } else {
                scHomeDirLocation = cfg.getScHomeDirLocation();
                scHomeDirName = cfg.getScHomeDirName();
            }
            if (scHomeDirLocation == null && (scHomeDirLocation = System.getProperty("user.home")) == null) {
                scHomeDirLocation = ".";
            }
            if (scHomeDirName == null) {
                scHomeDirName = ".";
            }
            file = new File(new File(scHomeDirLocation, scHomeDirName), path).getAbsoluteFile();
        }
        return file;
    }

    public static boolean getBoolean(ConfigurationService cfg, String property2, boolean defaultValue) {
        String s;
        boolean b = cfg == null ? ((s = System.getProperty(property2)) == null || s.length() == 0 ? defaultValue : Boolean.parseBoolean(s)) : cfg.getBoolean(property2, defaultValue);
        return b;
    }

    public static int getInt(ConfigurationService cfg, String property2, int defaultValue) {
        int i2;
        if (cfg == null) {
            String s = System.getProperty(property2);
            if (s == null || s.length() == 0) {
                i2 = defaultValue;
            } else {
                try {
                    i2 = Integer.parseInt(s);
                }
                catch (NumberFormatException nfe) {
                    i2 = defaultValue;
                }
            }
        } else {
            i2 = cfg.getInt(property2, defaultValue);
        }
        return i2;
    }

    public static long getLong(ConfigurationService cfg, String property2, long defaultValue) {
        long i2;
        if (cfg == null) {
            String s = System.getProperty(property2);
            if (s == null || s.length() == 0) {
                i2 = defaultValue;
            } else {
                try {
                    i2 = Long.parseLong(s);
                }
                catch (NumberFormatException nfe) {
                    i2 = defaultValue;
                }
            }
        } else {
            i2 = cfg.getLong(property2, defaultValue);
        }
        return i2;
    }

    public static String getString(ConfigurationService cfg, String property2, String defaultValue) {
        String s = cfg == null ? System.getProperty(property2, defaultValue) : cfg.getString(property2, defaultValue);
        return s;
    }

    public static String getString(ConfigurationService cfg, String property2, String propertyAlternative, String defaultValue) {
        String ret = ConfigUtils.getString(cfg, property2, null);
        if (ret == null) {
            ret = ConfigUtils.getString(cfg, propertyAlternative, defaultValue);
        }
        return ret;
    }

    public static String getSystemPropertiesDebugString() {
        StringBuilder str = new StringBuilder();
        try {
            Pattern exclusion = null;
            if (PASSWORD_SYS_PROPS != null) {
                exclusion = Pattern.compile(PASSWORD_SYS_PROPS, 2);
            }
            String[] passwordArgs = null;
            if (PASSWORD_CMD_LINE_ARGS != null) {
                passwordArgs = PASSWORD_CMD_LINE_ARGS.split(",");
            }
            for (Map.Entry<Object, Object> e : System.getProperties().entrySet()) {
                String key = String.valueOf(e.getKey());
                String value2 = String.valueOf(e.getValue());
                if (exclusion != null && exclusion.matcher(key).find()) {
                    value2 = "**********";
                }
                if (passwordArgs != null && "sun.java.command".equals(key)) {
                    value2 = PasswordUtil.replacePasswords(value2, passwordArgs);
                }
                str.append(key).append("=").append(value2).append("\n");
            }
        }
        catch (RuntimeException e) {
            str.append("An exception occurred while writing debug info").append(e.toString());
        }
        return str.toString();
    }
}

