/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.ice4j.socket;

import gg.essential.lib.ice4j.ice.Component;
import gg.essential.lib.ice4j.ice.ComponentSocket;
import gg.essential.lib.ice4j.socket.IceSocketWrapper;
import gg.essential.lib.ice4j.socket.IceTcpSocketWrapper;
import gg.essential.lib.ice4j.socket.MultiplexingSocket;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class IceTcpServerSocketWrapper
extends IceSocketWrapper {
    private static final Logger logger = Logger.getLogger(IceTcpServerSocketWrapper.class.getName());
    private Thread acceptThread = null;
    private final ServerSocket serverSocket;
    private boolean isRun = false;
    private final Component component;
    private final List<Socket> sockets = new ArrayList<Socket>();

    public IceTcpServerSocketWrapper(ServerSocket serverSocket, Component component3) {
        this.serverSocket = serverSocket;
        this.component = component3;
        this.acceptThread = new ThreadAccept();
        this.acceptThread.start();
    }

    @Override
    public void send(DatagramPacket p) throws IOException {
    }

    @Override
    public void receive(DatagramPacket p) throws IOException {
    }

    @Override
    public void close() {
        try {
            this.isRun = false;
            this.serverSocket.close();
            for (Socket s : this.sockets) {
                s.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.serverSocket.getInetAddress();
    }

    @Override
    public int getLocalPort() {
        return this.serverSocket.getLocalPort();
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        return this.serverSocket.getLocalSocketAddress();
    }

    @Override
    public Socket getTCPSocket() {
        if (this.sockets.size() > 0) {
            return this.sockets.get(0);
        }
        return null;
    }

    @Override
    public DatagramSocket getUDPSocket() {
        return null;
    }

    private class ThreadAccept
    extends Thread {
        private ThreadAccept() {
        }

        @Override
        public void run() {
            IceTcpServerSocketWrapper.this.isRun = true;
            while (IceTcpServerSocketWrapper.this.isRun) {
                try {
                    Socket tcpSocket = IceTcpServerSocketWrapper.this.serverSocket.accept();
                    if (tcpSocket == null) continue;
                    MultiplexingSocket multiplexingSocket = new MultiplexingSocket(tcpSocket);
                    IceTcpServerSocketWrapper.this.component.getParentStream().getParentAgent().getStunStack().addSocket(new IceTcpSocketWrapper(multiplexingSocket));
                    ComponentSocket componentSocket = IceTcpServerSocketWrapper.this.component.getComponentSocket();
                    if (componentSocket != null) {
                        componentSocket.add(multiplexingSocket);
                    }
                    IceTcpServerSocketWrapper.this.sockets.add(multiplexingSocket);
                }
                catch (IOException e) {
                    logger.info("Failed to accept TCP socket " + e);
                }
            }
        }
    }
}

