/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.ice4j.socket;

import gg.essential.lib.ice4j.socket.DatagramSocketFactory;
import gg.essential.lib.ice4j.socket.StunDatagramPacketFilter;
import gg.essential.lib.ice4j.stack.StunStack;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.DatagramChannel;

public class DelegatingDatagramSocket
extends DatagramSocket {
    private static DatagramSocketFactory delegateFactory = null;
    private static int defaultReceiveBufferSize = -1;
    protected final DatagramSocket delegate;
    private long nbReceivedPackets = 0L;
    private long nbSentPackets = 0L;
    private boolean closed = false;

    public static void setDefaultDelegateFactory(DatagramSocketFactory factory2) {
        delegateFactory = factory2;
    }

    public static void setDefaultReceiveBufferSize(int size) {
        defaultReceiveBufferSize = size;
    }

    static boolean logNonStun(long numOfPacket) {
        return numOfPacket == 1L || numOfPacket == 300L || numOfPacket == 500L || numOfPacket == 1000L || numOfPacket % 5000L == 0L;
    }

    public DelegatingDatagramSocket() throws SocketException {
        this(null, new InetSocketAddress(0));
    }

    public DelegatingDatagramSocket(DatagramSocket delegate2) throws SocketException {
        this(delegate2, null);
    }

    public DelegatingDatagramSocket(int port) throws SocketException {
        this(null, new InetSocketAddress(port));
    }

    public DelegatingDatagramSocket(int port, InetAddress laddr) throws SocketException {
        this(null, new InetSocketAddress(laddr, port));
    }

    public DelegatingDatagramSocket(SocketAddress bindaddr) throws SocketException {
        this(null, bindaddr);
    }

    public DelegatingDatagramSocket(DatagramSocket delegate2, SocketAddress address) throws SocketException {
        super((SocketAddress)null);
        if (delegate2 != null) {
            this.delegate = delegate2;
        } else {
            if (delegateFactory != null) {
                this.delegate = delegateFactory.createUnboundDatagramSocket();
            } else {
                this.delegate = null;
                this.initReceiveBufferSize();
            }
            this.bind(address);
        }
    }

    @Override
    public void bind(SocketAddress addr) throws SocketException {
        if (this.delegate == null) {
            super.bind(addr);
        } else {
            this.delegate.bind(addr);
        }
    }

    @Override
    public void close() {
        if (this.delegate != null) {
            this.delegate.close();
        }
        super.close();
        this.closed = true;
    }

    @Override
    public void connect(InetAddress address, int port) {
        if (this.delegate == null) {
            super.connect(address, port);
        } else {
            this.delegate.connect(address, port);
        }
    }

    @Override
    public void connect(SocketAddress addr) throws SocketException {
        if (this.delegate == null) {
            super.connect(addr);
        } else {
            this.delegate.connect(addr);
        }
    }

    @Override
    public void disconnect() {
        if (this.delegate == null) {
            super.disconnect();
        } else {
            this.delegate.disconnect();
        }
    }

    @Override
    public boolean getBroadcast() throws SocketException {
        return this.delegate == null ? super.getBroadcast() : this.delegate.getBroadcast();
    }

    @Override
    public DatagramChannel getChannel() {
        return this.delegate == null ? super.getChannel() : this.delegate.getChannel();
    }

    @Override
    public InetAddress getInetAddress() {
        return this.delegate == null ? super.getInetAddress() : this.delegate.getInetAddress();
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.delegate == null ? super.getLocalAddress() : this.delegate.getLocalAddress();
    }

    @Override
    public int getLocalPort() {
        return this.delegate == null ? super.getLocalPort() : this.delegate.getLocalPort();
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        return this.delegate == null ? super.getLocalSocketAddress() : this.delegate.getLocalSocketAddress();
    }

    @Override
    public int getPort() {
        return this.delegate == null ? super.getPort() : this.delegate.getPort();
    }

    @Override
    public int getReceiveBufferSize() throws SocketException {
        return this.delegate == null ? super.getReceiveBufferSize() : this.delegate.getReceiveBufferSize();
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        return this.delegate == null ? super.getRemoteSocketAddress() : this.delegate.getRemoteSocketAddress();
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        return this.delegate == null ? super.getReuseAddress() : this.delegate.getReuseAddress();
    }

    @Override
    public int getSendBufferSize() throws SocketException {
        return this.delegate == null ? super.getSendBufferSize() : this.delegate.getSendBufferSize();
    }

    @Override
    public int getSoTimeout() throws SocketException {
        return this.delegate == null ? super.getSoTimeout() : this.delegate.getSoTimeout();
    }

    @Override
    public int getTrafficClass() throws SocketException {
        return this.delegate == null ? super.getTrafficClass() : this.delegate.getTrafficClass();
    }

    @Override
    public boolean isBound() {
        return this.delegate == null ? super.isBound() : this.delegate.isBound();
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public boolean isConnected() {
        return this.delegate == null ? super.isConnected() : this.delegate.isConnected();
    }

    @Override
    public void receive(DatagramPacket p) throws IOException {
        if (this.delegate == null) {
            byte[] data = p.getData();
            p.setLength(data == null ? 0 : data.length - p.getOffset());
            super.receive(p);
            if (StunDatagramPacketFilter.isStunPacket(p) || DelegatingDatagramSocket.logNonStun(++this.nbReceivedPackets)) {
                StunStack.logPacketToPcap(p, false, this.getLocalAddress(), this.getLocalPort());
            }
        } else {
            this.delegate.receive(p);
        }
    }

    @Override
    public void send(DatagramPacket p) throws IOException {
        if (this.delegate == null) {
            block6: {
                try {
                    super.send(p);
                }
                catch (Exception ex) {
                    InetAddress tmpAddr = p.getAddress();
                    if ((ex instanceof NoRouteToHostException || ex.getMessage() != null && ex.getMessage().equals("No route to host")) && tmpAddr instanceof Inet6Address && tmpAddr.isLinkLocalAddress()) {
                        Inet6Address newAddr = Inet6Address.getByAddress("", tmpAddr.getAddress(), ((Inet6Address)super.getLocalAddress()).getScopeId());
                        p.setAddress(newAddr);
                        super.send(p);
                    }
                    if (!(ex instanceof IOException)) break block6;
                    throw (IOException)ex;
                }
            }
            if (DelegatingDatagramSocket.logNonStun(++this.nbSentPackets)) {
                StunStack.logPacketToPcap(p, true, this.getLocalAddress(), this.getLocalPort());
            }
        } else {
            this.delegate.send(p);
        }
    }

    @Override
    public void setBroadcast(boolean on2) throws SocketException {
        if (this.delegate == null) {
            super.setBroadcast(on2);
        } else {
            this.delegate.setBroadcast(on2);
        }
    }

    @Override
    public void setReceiveBufferSize(int size) throws SocketException {
        if (this.delegate == null) {
            super.setReceiveBufferSize(size);
        } else {
            this.delegate.setReceiveBufferSize(size);
        }
    }

    @Override
    public void setReuseAddress(boolean on2) throws SocketException {
        if (this.delegate == null) {
            super.setReuseAddress(on2);
        } else {
            this.delegate.setReuseAddress(on2);
        }
    }

    @Override
    public void setSendBufferSize(int size) throws SocketException {
        if (this.delegate == null) {
            super.setSendBufferSize(size);
        } else {
            this.delegate.setSendBufferSize(size);
        }
    }

    @Override
    public void setSoTimeout(int timeout2) throws SocketException {
        if (this.delegate == null) {
            super.setSoTimeout(timeout2);
        } else {
            this.delegate.setSoTimeout(timeout2);
        }
    }

    @Override
    public void setTrafficClass(int tc) throws SocketException {
        if (this.delegate == null) {
            super.setTrafficClass(tc);
        } else {
            this.delegate.setTrafficClass(tc);
        }
    }

    private void initReceiveBufferSize() throws SocketException {
        if (this.delegate == null && defaultReceiveBufferSize > 0) {
            super.setReceiveBufferSize(defaultReceiveBufferSize);
        }
    }
}

