/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.ice4j.security;

import gg.essential.lib.ice4j.security.CredentialsAuthority;
import java.util.LinkedList;
import java.util.List;

public class CredentialsManager {
    private final List<CredentialsAuthority> authorities = new LinkedList<CredentialsAuthority>();
    private CredentialsAuthority[] unmodifiableAuthorities;

    public boolean checkLocalUserName(String username) {
        for (CredentialsAuthority auth : this.getAuthorities()) {
            if (!auth.checkLocalUserName(username)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CredentialsAuthority[] getAuthorities() {
        List<CredentialsAuthority> list = this.authorities;
        synchronized (list) {
            if (this.unmodifiableAuthorities == null) {
                this.unmodifiableAuthorities = this.authorities.toArray(new CredentialsAuthority[this.authorities.size()]);
            }
            return this.unmodifiableAuthorities;
        }
    }

    public byte[] getLocalKey(String username) {
        for (CredentialsAuthority auth : this.getAuthorities()) {
            byte[] passwd = auth.getLocalKey(username);
            if (passwd == null) continue;
            return passwd;
        }
        return null;
    }

    public byte[] getRemoteKey(String username, String media) {
        for (CredentialsAuthority auth : this.getAuthorities()) {
            byte[] passwd = auth.getRemoteKey(username, media);
            if (passwd == null) continue;
            return passwd;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAuthority(CredentialsAuthority authority) {
        List<CredentialsAuthority> list = this.authorities;
        synchronized (list) {
            if (!this.authorities.contains(authority) && this.authorities.add(authority)) {
                this.unmodifiableAuthorities = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterAuthority(CredentialsAuthority authority) {
        List<CredentialsAuthority> list = this.authorities;
        synchronized (list) {
            if (this.authorities.remove(authority)) {
                this.unmodifiableAuthorities = null;
            }
        }
    }
}

