/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.ice4j.pseudotcp;

import gg.essential.lib.ice4j.pseudotcp.Option;
import gg.essential.lib.ice4j.pseudotcp.PseudoTcpSocketImpl;
import gg.essential.lib.ice4j.pseudotcp.PseudoTcpState;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;

public class PseudoTcpSocket
extends Socket {
    private final PseudoTcpSocketImpl socketImpl;
    private final Object connectLock = new Object();
    private final Object closeLock = new Object();

    PseudoTcpSocket(PseudoTcpSocketImpl socketImpl) throws SocketException {
        super(socketImpl);
        this.socketImpl = socketImpl;
    }

    public long getConversationID() {
        return this.socketImpl.getConversationID();
    }

    public void setConversationID(long convID) throws IllegalStateException {
        this.socketImpl.setConversationID(convID);
    }

    public void setMTU(int mtu) {
        this.socketImpl.setMTU(mtu);
    }

    public int getMTU() {
        return this.socketImpl.getMTU();
    }

    public long getOption(Option option2) {
        return this.socketImpl.getPTCPOption(option2);
    }

    public void setOption(Option option2, long optValue) {
        this.socketImpl.setPTCPOption(option2, optValue);
    }

    public void accept(int timeout2) throws IOException {
        this.socketImpl.accept(timeout2);
    }

    public void setDebugName(String debugName) {
        this.socketImpl.setDebugName(debugName);
    }

    public PseudoTcpState getState() {
        return this.socketImpl.getState();
    }

    @Override
    public boolean isConnected() {
        return this.getState() == PseudoTcpState.TCP_ESTABLISHED;
    }

    public boolean isConnecting() {
        PseudoTcpState currentState = this.getState();
        return currentState == PseudoTcpState.TCP_ESTABLISHED || currentState == PseudoTcpState.TCP_SYN_RECEIVED || currentState == PseudoTcpState.TCP_SYN_SENT;
    }

    @Override
    public boolean isClosed() {
        return this.getState() == PseudoTcpState.TCP_CLOSED;
    }

    @Override
    public void connect(SocketAddress endpoint) throws IOException {
        this.connect(endpoint, 0);
    }

    private void checkDestination(int dstPort) {
        if (dstPort < 0 || dstPort > 65535) {
            throw new IllegalArgumentException("Port out of range: " + dstPort);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect(SocketAddress remoteAddr, int timeout2) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (timeout2 < 0) {
            throw new IllegalArgumentException("timeout < 0");
        }
        if (this.isConnected()) {
            throw new SocketException("Already connected");
        }
        if (remoteAddr == null) {
            throw new IllegalArgumentException("remoteAddr == null");
        }
        if (!(remoteAddr instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Remote address not an InetSocketAddress: " + remoteAddr.getClass());
        }
        InetSocketAddress inetAddr = (InetSocketAddress)remoteAddr;
        if (inetAddr.getAddress() == null) {
            throw new UnknownHostException("Host is unresolved: " + inetAddr.getHostName());
        }
        int port = inetAddr.getPort();
        this.checkDestination(port);
        Object object = this.connectLock;
        synchronized (object) {
            try {
                this.socketImpl.connect(remoteAddr, timeout2);
            }
            catch (IOException e) {
                this.socketImpl.close();
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws IOException {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.isClosed()) {
                return;
            }
            this.socketImpl.close();
        }
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.socketImpl.getOutputStream();
    }

    public void accept(SocketAddress remoteAddress, int timeout2) throws IOException {
        this.socketImpl.accept(remoteAddress, timeout2);
    }

    public FileDescriptor getFileDescriptor() {
        return this.socketImpl.getFileDescriptor();
    }
}

