/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.ice4j.ice.sdp;

import gg.essential.lib.ice4j.TransportAddress;
import gg.essential.lib.ice4j.ice.Candidate;
import gov.nist.core.NameValue;
import gov.nist.javax.sdp.fields.AttributeField;
import javax.sdp.SdpException;

public class CandidateAttribute
extends AttributeField {
    public static final String NAME = "candidate";
    private static final long serialVersionUID = 1L;
    private Candidate<?> candidate;

    protected CandidateAttribute() {
        this(null);
    }

    public CandidateAttribute(Candidate<?> candidate2) {
        this.candidate = candidate2;
    }

    public NameValue getAttribute() {
        NameValue attribute = super.getAttribute();
        String name2 = this.getName();
        if (attribute == null || name2.equals(attribute.getName()) && attribute.getValue() == null) {
            attribute = new NameValue(name2, (Object)this.getValue());
        }
        return attribute;
    }

    public String getName() {
        return NAME;
    }

    public void setName(String name2) {
    }

    public boolean hasValue() {
        return true;
    }

    public String getValue() {
        StringBuffer buff = new StringBuffer();
        buff.append(this.candidate.getFoundation());
        buff.append(" ").append(this.candidate.getParentComponent().getComponentID());
        buff.append(" ").append((Object)this.candidate.getTransport());
        buff.append(" ").append(this.candidate.getPriority());
        buff.append(" ").append(this.candidate.getTransportAddress().getHostAddress());
        buff.append(" ").append(this.candidate.getTransportAddress().getPort());
        buff.append(" typ ").append((Object)this.candidate.getType());
        TransportAddress relAddr = this.candidate.getRelatedAddress();
        if (relAddr != null) {
            buff.append(" raddr ").append(relAddr.getHostAddress());
            buff.append(" rport ").append(relAddr.getPort());
        }
        return buff.toString();
    }

    public void setValue(String value2) throws SdpException {
    }

    public char getTypeChar() {
        return 'a';
    }

    public CandidateAttribute clone() {
        CandidateAttribute clone = (CandidateAttribute)((Object)super.clone());
        clone.candidate = this.candidate;
        return clone;
    }

    public String encode() {
        StringBuffer sbuff = new StringBuffer("a=");
        sbuff.append(this.getName()).append(":");
        sbuff.append(this.getValue());
        return sbuff.append("\r\n").toString();
    }
}

