/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.ice4j.ice.harvest;

import gg.essential.lib.ice4j.StunException;
import gg.essential.lib.ice4j.TransportAddress;
import gg.essential.lib.ice4j.attribute.Attribute;
import gg.essential.lib.ice4j.attribute.ChannelNumberAttribute;
import gg.essential.lib.ice4j.attribute.EvenPortAttribute;
import gg.essential.lib.ice4j.attribute.LifetimeAttribute;
import gg.essential.lib.ice4j.attribute.RequestedTransportAttribute;
import gg.essential.lib.ice4j.attribute.XorPeerAddressAttribute;
import gg.essential.lib.ice4j.attribute.XorRelayedAddressAttribute;
import gg.essential.lib.ice4j.ice.CandidateType;
import gg.essential.lib.ice4j.ice.ComponentSocket;
import gg.essential.lib.ice4j.ice.HostCandidate;
import gg.essential.lib.ice4j.ice.LocalCandidate;
import gg.essential.lib.ice4j.ice.RelayedCandidate;
import gg.essential.lib.ice4j.ice.harvest.StunCandidateHarvest;
import gg.essential.lib.ice4j.ice.harvest.TurnCandidateHarvester;
import gg.essential.lib.ice4j.message.Message;
import gg.essential.lib.ice4j.message.MessageFactory;
import gg.essential.lib.ice4j.message.Request;
import gg.essential.lib.ice4j.message.Response;
import gg.essential.lib.ice4j.socket.RelayedCandidateDatagramSocket;
import gg.essential.lib.ice4j.stack.TransactionID;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TurnCandidateHarvest
extends StunCandidateHarvest {
    private static final Logger logger = Logger.getLogger(TurnCandidateHarvest.class.getName());
    private Request requestToStartResolvingCandidate;

    public TurnCandidateHarvest(TurnCandidateHarvester harvester, HostCandidate hostCandidate) {
        super(harvester, hostCandidate);
    }

    public void close(RelayedCandidateDatagramSocket relayedCandidateSocket) {
        this.setSendKeepAliveMessageInterval(0L);
        try {
            this.sendRequest(MessageFactory.createRefreshRequest(0), false, null);
        }
        catch (StunException sex) {
            logger.log(Level.INFO, "Failed to send TURN Refresh request to delete Allocation", sex);
        }
    }

    @Override
    protected boolean completedResolvingCandidate(Request request2, Response response2) {
        if (response2 == null || !response2.isSuccessResponse() && request2.getMessageType() == '\u0003') {
            try {
                if (this.startResolvingCandidate()) {
                    return false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.completedResolvingCandidate(request2, response2);
    }

    @Override
    protected void createCandidates(Response response2) {
        this.createRelayedCandidate(response2);
        super.createCandidates(response2);
    }

    @Override
    protected Message createKeepAliveMessage(LocalCandidate candidate2) throws StunException {
        switch (candidate2.getType()) {
            case RELAYED_CANDIDATE: {
                return MessageFactory.createRefreshRequest();
            }
            case SERVER_REFLEXIVE_CANDIDATE: {
                boolean existsRelayedCandidate = false;
                for (LocalCandidate aCandidate : this.getCandidates()) {
                    if (!CandidateType.RELAYED_CANDIDATE.equals((Object)aCandidate.getType())) continue;
                    existsRelayedCandidate = true;
                    break;
                }
                return existsRelayedCandidate ? null : super.createKeepAliveMessage(candidate2);
            }
        }
        return super.createKeepAliveMessage(candidate2);
    }

    private void createRelayedCandidate(Response response2) {
        TransportAddress relayedAddress;
        RelayedCandidate relayedCandidate;
        Attribute attribute = response2.getAttribute('\u0016');
        if (attribute instanceof XorRelayedAddressAttribute && (relayedCandidate = this.createRelayedCandidate(relayedAddress = ((XorRelayedAddressAttribute)attribute).getAddress(response2.getTransactionID()), this.getMappedAddress(response2))) != null) {
            this.harvester.getStunStack().addSocket(relayedCandidate.getStunSocket(null));
            ComponentSocket componentSocket = relayedCandidate.getParentComponent().getComponentSocket();
            if (componentSocket != null) {
                componentSocket.add(relayedCandidate.getCandidateIceSocketWrapper());
            }
            this.addCandidate(relayedCandidate);
        }
    }

    protected RelayedCandidate createRelayedCandidate(TransportAddress transportAddress, TransportAddress mappedAddress) {
        return new RelayedCandidate(transportAddress, this, mappedAddress);
    }

    @Override
    protected Request createRequestToRetry(Request request2) {
        switch (request2.getMessageType()) {
            case '\u0003': {
                RequestedTransportAttribute requestedTransportAttribute = (RequestedTransportAttribute)request2.getAttribute('\u0019');
                int requestedTransport = requestedTransportAttribute == null ? 17 : requestedTransportAttribute.getRequestedTransport();
                EvenPortAttribute evenPortAttribute = (EvenPortAttribute)request2.getAttribute('\u0018');
                boolean rFlag = evenPortAttribute != null && evenPortAttribute.isRFlag();
                return MessageFactory.createAllocateRequest((byte)requestedTransport, rFlag);
            }
            case '\t': {
                ChannelNumberAttribute channelNumberAttribute = (ChannelNumberAttribute)request2.getAttribute('\f');
                char channelNumber = channelNumberAttribute.getChannelNumber();
                XorPeerAddressAttribute peerAddressAttribute = (XorPeerAddressAttribute)request2.getAttribute('\u0012');
                TransportAddress peerAddress = peerAddressAttribute.getAddress(request2.getTransactionID());
                byte[] retryTransactionID = TransactionID.createNewTransactionID().getBytes();
                Request retryChannelBindRequest = MessageFactory.createChannelBindRequest(channelNumber, peerAddress, retryTransactionID);
                try {
                    retryChannelBindRequest.setTransactionID(retryTransactionID);
                }
                catch (StunException sex) {
                    throw new UndeclaredThrowableException(sex);
                }
                return retryChannelBindRequest;
            }
            case '\b': {
                XorPeerAddressAttribute peerAddressAttribute = (XorPeerAddressAttribute)request2.getAttribute('\u0012');
                TransportAddress peerAddress = peerAddressAttribute.getAddress(request2.getTransactionID());
                byte[] retryTransactionID = TransactionID.createNewTransactionID().getBytes();
                Request retryCreatePermissionRequest = MessageFactory.createCreatePermissionRequest(peerAddress, retryTransactionID);
                try {
                    retryCreatePermissionRequest.setTransactionID(retryTransactionID);
                }
                catch (StunException sex) {
                    throw new UndeclaredThrowableException(sex);
                }
                return retryCreatePermissionRequest;
            }
            case '\u0004': {
                LifetimeAttribute lifetimeAttribute = (LifetimeAttribute)request2.getAttribute('\r');
                if (lifetimeAttribute == null) {
                    return MessageFactory.createRefreshRequest();
                }
                return MessageFactory.createRefreshRequest(lifetimeAttribute.getLifetime());
            }
        }
        return super.createRequestToRetry(request2);
    }

    @Override
    protected Request createRequestToStartResolvingCandidate() {
        if (this.requestToStartResolvingCandidate == null) {
            this.requestToStartResolvingCandidate = MessageFactory.createAllocateRequest((byte)17, false);
            return this.requestToStartResolvingCandidate;
        }
        if (this.requestToStartResolvingCandidate.getMessageType() == '\u0003') {
            this.requestToStartResolvingCandidate = super.createRequestToStartResolvingCandidate();
            return this.requestToStartResolvingCandidate;
        }
        return null;
    }

    @Override
    protected boolean processErrorOrFailure(Response response2, Request request2, TransactionID transactionID) {
        Object applicationData = transactionID.getApplicationData();
        if (applicationData instanceof RelayedCandidateDatagramSocket && ((RelayedCandidateDatagramSocket)applicationData).processErrorOrFailure(response2, request2)) {
            return true;
        }
        return super.processErrorOrFailure(response2, request2, transactionID);
    }

    @Override
    protected void processSuccess(Response response2, Request request2, TransactionID transactionID) {
        Object applicationData;
        super.processSuccess(response2, request2, transactionID);
        int lifetime = -1;
        switch (response2.getMessageType()) {
            case '\u0103': {
                LifetimeAttribute lifetimeAttribute = (LifetimeAttribute)response2.getAttribute('\r');
                lifetime = lifetimeAttribute == null ? 600 : lifetimeAttribute.getLifetime();
                break;
            }
            case '\u0104': {
                LifetimeAttribute lifetimeAttribute = (LifetimeAttribute)response2.getAttribute('\r');
                if (lifetimeAttribute == null) break;
                lifetime = lifetimeAttribute.getLifetime();
            }
        }
        if (lifetime >= 0) {
            this.setSendKeepAliveMessageInterval(1000L * (long)lifetime);
        }
        if ((applicationData = transactionID.getApplicationData()) instanceof RelayedCandidateDatagramSocket) {
            ((RelayedCandidateDatagramSocket)applicationData).processSuccess(response2, request2);
        }
    }

    public byte[] sendRequest(RelayedCandidateDatagramSocket relayedCandidateDatagramSocket, Request request2) throws StunException {
        TransactionID transactionID = TransactionID.createNewTransactionID();
        transactionID.setApplicationData(relayedCandidateDatagramSocket);
        transactionID = this.sendRequest(request2, false, transactionID);
        return transactionID == null ? null : transactionID.getBytes();
    }
}

