/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.ice4j.ice.harvest;

import gg.essential.lib.ice4j.Transport;
import gg.essential.lib.ice4j.TransportAddress;
import gg.essential.lib.ice4j.ice.Candidate;
import gg.essential.lib.ice4j.ice.Component;
import gg.essential.lib.ice4j.ice.ComponentSocket;
import gg.essential.lib.ice4j.ice.HostCandidate;
import gg.essential.lib.ice4j.ice.LocalCandidate;
import gg.essential.lib.ice4j.ice.harvest.AbstractCandidateHarvester;
import gg.essential.lib.ice4j.ice.harvest.StunCandidateHarvest;
import gg.essential.lib.ice4j.ice.harvest.TurnCandidateHarvester;
import gg.essential.lib.ice4j.security.LongTermCredential;
import gg.essential.lib.ice4j.socket.IceTcpSocketWrapper;
import gg.essential.lib.ice4j.socket.MultiplexingSocket;
import gg.essential.lib.ice4j.stack.StunStack;
import java.net.Socket;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StunCandidateHarvester
extends AbstractCandidateHarvester {
    private static final Logger logger = Logger.getLogger(StunCandidateHarvester.class.getName());
    private final List<StunCandidateHarvest> completedHarvests = new LinkedList<StunCandidateHarvest>();
    private final String shortTermCredentialUsername;
    private final List<StunCandidateHarvest> startedHarvests = new LinkedList<StunCandidateHarvest>();
    public final TransportAddress stunServer;
    private StunStack stunStack;

    public StunCandidateHarvester(TransportAddress stunServer) {
        this(stunServer, null);
    }

    public StunCandidateHarvester(TransportAddress stunServer, String shortTermCredentialUsername) {
        this.stunServer = stunServer;
        this.shortTermCredentialUsername = shortTermCredentialUsername;
        if (System.getProperty("gg.essential.lib.ice4j.MAX_CTRAN_RETRANS_TIMER") == null) {
            System.setProperty("gg.essential.lib.ice4j.MAX_CTRAN_RETRANS_TIMER", "400");
        }
        if (System.getProperty("gg.essential.lib.ice4j.MAX_RETRANSMISSIONS") == null) {
            System.setProperty("gg.essential.lib.ice4j.MAX_RETRANSMISSIONS", "3");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void completedResolvingCandidate(StunCandidateHarvest harvest) {
        boolean doNotify = false;
        List<StunCandidateHarvest> list = this.startedHarvests;
        synchronized (list) {
            this.startedHarvests.remove(harvest);
            if (this.startedHarvests.isEmpty()) {
                doNotify = true;
            }
        }
        list = this.completedHarvests;
        synchronized (list) {
            if (harvest.getCandidateCount() < 1) {
                this.completedHarvests.remove(harvest);
            } else if (!this.completedHarvests.contains(harvest)) {
                this.completedHarvests.add(harvest);
            }
        }
        list = this.startedHarvests;
        synchronized (list) {
            if (doNotify) {
                this.startedHarvests.notify();
            }
        }
    }

    protected StunCandidateHarvest createHarvest(HostCandidate hostCandidate) {
        return new StunCandidateHarvest(this, hostCandidate);
    }

    protected LongTermCredential createLongTermCredential(StunCandidateHarvest harvest, byte[] realm) {
        return null;
    }

    protected String getShortTermCredentialUsername() {
        return this.shortTermCredentialUsername;
    }

    public StunStack getStunStack() {
        return this.stunStack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<LocalCandidate> harvest(Component component3) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("starting " + component3.toShortString() + " harvest for: " + this.toString());
        }
        this.stunStack = component3.getParentStream().getParentAgent().getStunStack();
        for (Candidate list : component3.getLocalCandidates()) {
            if (!(list instanceof HostCandidate) || list.getTransport() != this.stunServer.getTransport()) continue;
            this.startResolvingCandidate((HostCandidate)list);
        }
        this.waitForResolutionEnd();
        HashSet<LocalCandidate> candidates = new HashSet<LocalCandidate>();
        List<StunCandidateHarvest> list = this.completedHarvests;
        synchronized (list) {
            for (StunCandidateHarvest completedHarvest : this.completedHarvests) {
                LocalCandidate[] completedHarvestCandidates = completedHarvest.getCandidates();
                if (completedHarvestCandidates == null || completedHarvestCandidates.length == 0) continue;
                candidates.addAll(Arrays.asList(completedHarvestCandidates));
            }
            this.completedHarvests.clear();
        }
        logger.finest("Completed " + component3.toShortString() + " harvest: " + this.toString() + ". Found " + candidates.size() + " candidates: " + this.listCandidates(candidates));
        return candidates;
    }

    private String listCandidates(Collection<? extends Candidate<?>> candidates) {
        StringBuilder retval = new StringBuilder();
        for (Candidate<?> candidate2 : candidates) {
            retval.append(candidate2.toShortString());
        }
        return retval.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startResolvingCandidate(HostCandidate hostCand) {
        if (!hostCand.getTransportAddress().canReach(this.stunServer)) {
            return;
        }
        HostCandidate cand = this.getHostCandidate(hostCand);
        if (cand == null) {
            logger.info("server/candidate address type mismatch, skipping candidate in this harvester");
            return;
        }
        StunCandidateHarvest harvest = this.createHarvest(cand);
        if (harvest == null) {
            logger.warning("failed to create harvest");
            return;
        }
        List<StunCandidateHarvest> list = this.startedHarvests;
        synchronized (list) {
            this.startedHarvests.add(harvest);
            boolean started = false;
            try {
                started = harvest.startResolvingCandidate();
            }
            catch (Exception ex) {
                started = false;
                if (logger.isLoggable(Level.INFO)) {
                    logger.log(Level.INFO, "Failed to start resolving host candidate " + hostCand, ex);
                }
            }
            finally {
                if (!started) {
                    try {
                        this.startedHarvests.remove(harvest);
                        logger.warning("harvest did not start, removed: " + harvest);
                    }
                    catch (Throwable throwable) {
                        try {
                            harvest.close();
                        }
                        catch (Exception exception) {}
                        throw throwable;
                    }
                    try {
                        harvest.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForResolutionEnd() {
        List<StunCandidateHarvest> list = this.startedHarvests;
        synchronized (list) {
            boolean interrupted = false;
            while (!this.startedHarvests.isEmpty()) {
                try {
                    this.startedHarvests.wait();
                }
                catch (InterruptedException iex) {
                    logger.info("interrupted waiting for harvests to complete, no. startedHarvests = " + this.startedHarvests.size());
                    interrupted = true;
                }
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public String toString() {
        String proto = this instanceof TurnCandidateHarvester ? "TURN" : "STUN";
        return proto + " harvester(srvr: " + this.stunServer + ")";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected HostCandidate getHostCandidate(HostCandidate hostCand) {
        if (hostCand.getTransport() != Transport.TCP) return hostCand;
        try {
            Socket sock = new Socket(this.stunServer.getAddress(), this.stunServer.getPort());
            MultiplexingSocket multiplexing = new MultiplexingSocket(sock);
            Component component3 = hostCand.getParentComponent();
            HostCandidate cand = new HostCandidate(new IceTcpSocketWrapper(multiplexing), component3, Transport.TCP);
            component3.getParentStream().getParentAgent().getStunStack().addSocket(cand.getStunSocket(null));
            ComponentSocket componentSocket = component3.getComponentSocket();
            if (componentSocket == null) return cand;
            componentSocket.add(multiplexing);
            return cand;
        }
        catch (Exception io) {
            logger.info("Exception TCP client connect: " + io);
            return null;
        }
    }
}

