/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.ice4j.ice.harvest;

import gg.essential.lib.ice4j.Transport;
import gg.essential.lib.ice4j.TransportAddress;
import gg.essential.lib.ice4j.ice.Agent;
import gg.essential.lib.ice4j.ice.Component;
import gg.essential.lib.ice4j.ice.ComponentSocket;
import gg.essential.lib.ice4j.ice.HostCandidate;
import gg.essential.lib.ice4j.ice.IceMediaStream;
import gg.essential.lib.ice4j.ice.IceProcessingState;
import gg.essential.lib.ice4j.ice.LocalCandidate;
import gg.essential.lib.ice4j.ice.harvest.AbstractUdpListener;
import gg.essential.lib.ice4j.ice.harvest.CandidateHarvester;
import gg.essential.lib.ice4j.ice.harvest.HarvestStatistics;
import gg.essential.lib.ice4j.socket.IceSocketWrapper;
import gg.essential.lib.ice4j.socket.IceUdpSocketWrapper;
import gg.essential.lib.ice4j.socket.MultiplexingDatagramSocket;
import gg.essential.lib.ice4j.socket.StunDatagramPacketFilter;
import gg.essential.lib.ice4j.stack.StunStack;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SinglePortUdpHarvester
extends AbstractUdpListener
implements CandidateHarvester {
    private static final Logger logger = Logger.getLogger(SinglePortUdpHarvester.class.getName());
    private final Map<String, MyCandidate> candidates = new ConcurrentHashMap<String, MyCandidate>();
    private HarvestStatistics harvestStatistics = new HarvestStatistics();

    public static List<SinglePortUdpHarvester> createHarvesters(int port) {
        LinkedList<SinglePortUdpHarvester> harvesters = new LinkedList<SinglePortUdpHarvester>();
        for (TransportAddress address : AbstractUdpListener.getAllowedAddresses(port)) {
            try {
                harvesters.add(new SinglePortUdpHarvester(address));
            }
            catch (IOException ioe) {
                logger.info("Failed to create SinglePortUdpHarvester for address " + address + ": " + ioe);
            }
        }
        return harvesters;
    }

    public SinglePortUdpHarvester(TransportAddress localAddress) throws IOException {
        super(localAddress);
        logger.info("Initialized SinglePortUdpHarvester with address " + this.localAddress);
    }

    @Override
    public HarvestStatistics getHarvestStatistics() {
        return this.harvestStatistics;
    }

    @Override
    protected void maybeAcceptNewSession(AbstractUdpListener.Buffer buf, InetSocketAddress remoteAddress, String ufrag) {
        MyCandidate candidate2 = this.candidates.get(ufrag);
        if (candidate2 == null) {
            return;
        }
        try {
            AbstractUdpListener.MySocket newSocket = this.addSocket(remoteAddress, ufrag);
            candidate2.addSocket(newSocket, remoteAddress);
            newSocket.addBuffer(buf);
        }
        catch (SocketException se) {
            logger.info("Could not create a socket: " + se);
        }
        catch (IOException ioe) {
            logger.info("Failed to handle new socket: " + ioe);
        }
    }

    @Override
    public Collection<LocalCandidate> harvest(Component component3) {
        IceMediaStream stream = component3.getParentStream();
        Agent agent = stream.getParentAgent();
        String ufrag = agent.getLocalUfrag();
        if (stream.getComponentCount() != 1 || agent.getStreamCount() != 1) {
            logger.info("More than one Component for an Agent, cannot harvest.");
            return new LinkedList<LocalCandidate>();
        }
        MyCandidate candidate2 = new MyCandidate(component3, ufrag);
        this.candidates.put(ufrag, candidate2);
        component3.addLocalCandidate(candidate2);
        return new ArrayList<LocalCandidate>(Arrays.asList(candidate2));
    }

    @Override
    public boolean isHostHarvester() {
        return true;
    }

    private class MyCandidate
    extends HostCandidate {
        private final String ufrag;
        private boolean freed;
        private final Map<SocketAddress, IceSocketWrapper> candidateSockets;
        private final Map<SocketAddress, DatagramSocket> sockets;

        private MyCandidate(Component component3, String ufrag) {
            super(SinglePortUdpHarvester.this.localAddress, component3);
            this.freed = false;
            this.candidateSockets = new HashMap<SocketAddress, IceSocketWrapper>();
            this.sockets = new HashMap<SocketAddress, DatagramSocket>();
            this.ufrag = ufrag;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void free() {
            Map<SocketAddress, IceSocketWrapper> map2 = this;
            synchronized (map2) {
                if (this.freed) {
                    return;
                }
                this.freed = true;
            }
            SinglePortUdpHarvester.this.candidates.remove(this.ufrag);
            map2 = this.sockets;
            synchronized (map2) {
                StunStack stunStack = this.getStunStack();
                for (Map.Entry<SocketAddress, DatagramSocket> e : this.sockets.entrySet()) {
                    DatagramSocket socket = e.getValue();
                    if (stunStack != null) {
                        TransportAddress localAddress = new TransportAddress(socket.getLocalAddress(), socket.getLocalPort(), Transport.UDP);
                        TransportAddress remoteAddress = new TransportAddress((InetSocketAddress)e.getKey(), Transport.UDP);
                        stunStack.removeSocket(localAddress, remoteAddress);
                    }
                    socket.close();
                }
                this.sockets.clear();
            }
            map2 = this.candidateSockets;
            synchronized (map2) {
                for (IceSocketWrapper wrapper : this.candidateSockets.values()) {
                    wrapper.close();
                }
                this.candidateSockets.clear();
            }
            super.free();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void addSocket(DatagramSocket socket, InetSocketAddress remoteAddress) throws IOException {
            if (this.freed) {
                throw new IOException("Candidate freed");
            }
            Component component3 = this.getParentComponent();
            if (component3 == null) {
                throw new IOException("No parent component");
            }
            IceProcessingState state2 = component3.getParentStream().getParentAgent().getState();
            if (state2 == IceProcessingState.FAILED) {
                throw new IOException("Cannot add socket to an Agent in state FAILED.");
            }
            if (state2 != null && state2.isOver() && logger.isLoggable(Level.FINE)) {
                logger.fine("Adding a socket to a completed Agent, state=" + (Object)((Object)state2));
            }
            MultiplexingDatagramSocket multiplexing = new MultiplexingDatagramSocket(socket);
            IceUdpSocketWrapper candidateSocket = new IceUdpSocketWrapper(multiplexing);
            IceUdpSocketWrapper stunSocket = new IceUdpSocketWrapper(multiplexing.getSocket(new StunDatagramPacketFilter()));
            component3.getParentStream().getParentAgent().getStunStack().addSocket(stunSocket, new TransportAddress(remoteAddress, Transport.UDP));
            ComponentSocket componentSocket = component3.getComponentSocket();
            if (componentSocket != null) {
                componentSocket.add(multiplexing);
            }
            Map<SocketAddress, Object> map2 = this.candidateSockets;
            synchronized (map2) {
                IceSocketWrapper oldSocket = this.candidateSockets.put(remoteAddress, candidateSocket);
                if (oldSocket != null) {
                    logger.warning("Replacing the socket for remote address " + remoteAddress);
                    oldSocket.close();
                }
            }
            map2 = this.sockets;
            synchronized (map2) {
                this.sockets.put(remoteAddress, socket);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected IceSocketWrapper getCandidateIceSocketWrapper(SocketAddress remoteAddress) {
            Map<SocketAddress, IceSocketWrapper> map2 = this.candidateSockets;
            synchronized (map2) {
                return this.candidateSockets.get(remoteAddress);
            }
        }
    }
}

