/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.ice4j.ice.harvest;

import gg.essential.lib.ice4j.ice.LocalCandidate;
import java.util.Collection;

public class HarvestStatistics {
    private int harvestCount = 0;
    private long lastStartHarvestingTime = -1L;
    private long lastHarvestingTime = 0L;
    private int totalCandidateCount = 0;
    protected String harvesterName;

    protected void startHarvestTiming() {
        ++this.harvestCount;
        this.lastStartHarvestingTime = System.currentTimeMillis();
    }

    protected void stopHarvestTiming(Collection<LocalCandidate> harvest) {
        if (harvest != null) {
            this.stopHarvestTiming(harvest.size());
        } else {
            this.stopHarvestTiming(0);
        }
    }

    protected void stopHarvestTiming(int candidateCount) {
        this.lastHarvestingTime = this.getHarvestDuration();
        this.lastStartHarvestingTime = -1L;
        this.totalCandidateCount += candidateCount;
    }

    public long getHarvestDuration() {
        if (this.lastStartHarvestingTime != -1L) {
            long currentHarvestingTime = System.currentTimeMillis() - this.lastStartHarvestingTime;
            if (this.lastStartHarvestingTime != -1L) {
                return this.lastHarvestingTime + currentHarvestingTime;
            }
        }
        return this.lastHarvestingTime;
    }

    public int getTotalCandidateCount() {
        return this.totalCandidateCount;
    }

    public int getHarvestCount() {
        return this.harvestCount;
    }

    protected void setName(String harvesterName) {
        this.harvesterName = harvesterName;
    }

    public String getName() {
        return this.harvesterName;
    }

    public String toString() {
        return this.harvesterName + ": time=" + this.getHarvestDuration() + "ms harvests=" + this.getHarvestCount() + " candidates=" + this.getTotalCandidateCount();
    }
}

