/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.ice4j.ice;

import gg.essential.lib.ice4j.Transport;
import gg.essential.lib.ice4j.TransportAddress;
import gg.essential.lib.ice4j.ice.CandidateExtendedType;
import gg.essential.lib.ice4j.ice.CandidateType;
import gg.essential.lib.ice4j.ice.LocalCandidate;
import gg.essential.lib.ice4j.ice.harvest.GoogleTurnCandidateHarvest;
import gg.essential.lib.ice4j.socket.GoogleRelayedCandidateDatagramSocket;
import gg.essential.lib.ice4j.socket.GoogleRelayedCandidateSocket;
import gg.essential.lib.ice4j.socket.IceSocketWrapper;
import gg.essential.lib.ice4j.socket.IceTcpSocketWrapper;
import gg.essential.lib.ice4j.socket.IceUdpSocketWrapper;
import gg.essential.lib.ice4j.socket.MultiplexingDatagramSocket;
import gg.essential.lib.ice4j.socket.MultiplexingSocket;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.SocketException;

public class GoogleRelayedCandidate
extends LocalCandidate {
    private GoogleRelayedCandidateDatagramSocket relayedCandidateDatagramSocket;
    private GoogleRelayedCandidateSocket relayedCandidateSocket = null;
    private IceSocketWrapper socket;
    private final GoogleTurnCandidateHarvest turnCandidateHarvest;
    private final String username;
    private final String password;

    public GoogleRelayedCandidate(TransportAddress transportAddress, GoogleTurnCandidateHarvest turnCandidateHarvest, TransportAddress mappedAddress, String username, String password) {
        super(transportAddress, turnCandidateHarvest.hostCandidate.getParentComponent(), CandidateType.RELAYED_CANDIDATE, CandidateExtendedType.GOOGLE_TURN_RELAYED_CANDIDATE, turnCandidateHarvest.hostCandidate.getParentComponent().findLocalCandidate(mappedAddress));
        if (transportAddress.getTransport() == Transport.TCP) {
            super.setExtendedType(CandidateExtendedType.GOOGLE_TCP_TURN_RELAYED_CANDIDATE);
        }
        this.turnCandidateHarvest = turnCandidateHarvest;
        this.username = username;
        this.password = password;
        this.setBase(this);
        this.setRelayServerAddress(turnCandidateHarvest.harvester.stunServer);
        this.setMappedAddress(mappedAddress);
    }

    private synchronized GoogleRelayedCandidateDatagramSocket getRelayedCandidateDatagramSocket() {
        if (this.relayedCandidateDatagramSocket == null) {
            try {
                this.relayedCandidateDatagramSocket = new GoogleRelayedCandidateDatagramSocket(this, this.turnCandidateHarvest, this.username);
            }
            catch (SocketException sex) {
                throw new UndeclaredThrowableException(sex);
            }
        }
        return this.relayedCandidateDatagramSocket;
    }

    private synchronized GoogleRelayedCandidateSocket getRelayedCandidateSocket() {
        if (this.relayedCandidateSocket == null) {
            try {
                this.relayedCandidateSocket = new GoogleRelayedCandidateSocket(this, this.turnCandidateHarvest, this.username);
            }
            catch (SocketException sex) {
                throw new UndeclaredThrowableException(sex);
            }
        }
        return this.relayedCandidateSocket;
    }

    @Override
    public synchronized IceSocketWrapper getCandidateIceSocketWrapper() {
        if (this.socket == null) {
            try {
                if (this.getTransport() == Transport.UDP) {
                    this.socket = new IceUdpSocketWrapper(new MultiplexingDatagramSocket(this.getRelayedCandidateDatagramSocket()));
                } else if (this.getTransport() == Transport.TCP) {
                    GoogleRelayedCandidateSocket s = this.getRelayedCandidateSocket();
                    this.socket = new IceTcpSocketWrapper(new MultiplexingSocket(s));
                }
            }
            catch (Exception sex) {
                throw new UndeclaredThrowableException(sex);
            }
        }
        return this.socket;
    }

    public String getPassword() {
        return this.password;
    }
}

