/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.ice4j.ice;

import gg.essential.lib.ice4j.ice.Agent;
import gg.essential.lib.ice4j.ice.CandidatePair;
import gg.essential.lib.ice4j.ice.CandidatePairState;
import gg.essential.lib.ice4j.ice.CandidateType;
import gg.essential.lib.ice4j.ice.CheckList;
import gg.essential.lib.ice4j.ice.Component;
import gg.essential.lib.ice4j.ice.IceMediaStream;
import gg.essential.lib.ice4j.ice.IceProcessingState;
import gg.essential.lib.ice4j.ice.LocalCandidate;
import gg.essential.lib.ice4j.ice.NominationStrategy;
import gg.essential.lib.ice4j.ice.RelayedCandidate;
import gg.essential.lib.jitsi.utils.logging2.Logger;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public class DefaultNominator
implements PropertyChangeListener {
    private final Agent parentAgent;
    private NominationStrategy strategy = NominationStrategy.NOMINATE_FIRST_VALID;
    private final Map<String, TimerTask> validatedCandidates = new HashMap<String, TimerTask>();
    private Logger logger;

    public DefaultNominator(Agent parentAgent) {
        this.parentAgent = parentAgent;
        this.logger = parentAgent.getLogger().createChildLogger(this.getClass().getName());
        parentAgent.addStateChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        String propertyName = ev.getPropertyName();
        if ("IceProcessingState".equals(propertyName)) {
            if (ev.getNewValue() != IceProcessingState.RUNNING) {
                return;
            }
            for (IceMediaStream stream : this.parentAgent.getStreams()) {
                stream.addPairChangeListener(this);
                stream.getCheckList().addStateChangeListener(this);
            }
        }
        if (!this.parentAgent.isControlling() || this.strategy == NominationStrategy.NONE) {
            return;
        }
        if (ev.getSource() instanceof CandidatePair) {
            if ("PairConsentFreshnessChanged".equals(propertyName)) {
                return;
            }
            CandidatePair validPair = (CandidatePair)ev.getSource();
            Component parentComponent = validPair.getParentComponent();
            IceMediaStream parentStream = parentComponent.getParentStream();
            if (parentStream.validListContainsNomineeForComponent(parentComponent)) {
                this.logger.debug(() -> "Keep-alive for pair: " + validPair.toShortString());
                return;
            }
        }
        if (this.strategy == NominationStrategy.NOMINATE_FIRST_VALID) {
            this.strategyNominateFirstValid(ev);
        } else if (this.strategy == NominationStrategy.NOMINATE_HIGHEST_PRIO) {
            this.strategyNominateHighestPrio(ev);
        } else if (this.strategy == NominationStrategy.NOMINATE_FIRST_HOST_OR_REFLEXIVE_VALID) {
            this.strategyNominateFirstHostOrReflexiveValid(ev);
        }
    }

    private void strategyNominateFirstValid(PropertyChangeEvent evt) {
        if ("PairValidated".equals(evt.getPropertyName())) {
            CandidatePair validPair = (CandidatePair)evt.getSource();
            this.logger.info("Nominate (first valid): " + validPair.toShortString() + ".");
            this.parentAgent.nominate(validPair);
        }
    }

    private void strategyNominateHighestPrio(PropertyChangeEvent ev) {
        String pname = ev.getPropertyName();
        if ("PairValidated".equals(pname) || "PairStateChanged".equals(pname) && ev.getNewValue() == CandidatePairState.FAILED) {
            CandidatePair validPair = (CandidatePair)ev.getSource();
            Component parentComponent = validPair.getParentComponent();
            IceMediaStream parentStream = parentComponent.getParentStream();
            CheckList parentCheckList = parentStream.getCheckList();
            if (!parentCheckList.allChecksCompleted()) {
                return;
            }
            for (Component component3 : parentStream.getComponents()) {
                CandidatePair pair = parentStream.getValidPair(component3);
                if (pair == null) continue;
                this.logger.info("Nominate (highest priority): " + validPair.toShortString());
                this.parentAgent.nominate(pair);
            }
        }
    }

    public NominationStrategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(NominationStrategy strategy) {
        this.strategy = strategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void strategyNominateFirstHostOrReflexiveValid(PropertyChangeEvent evt) {
        if ("PairValidated".equals(evt.getPropertyName())) {
            CandidatePair validPair = (CandidatePair)evt.getSource();
            Component component3 = validPair.getParentComponent();
            LocalCandidate localCandidate = validPair.getLocalCandidate();
            boolean isRelayed = localCandidate instanceof RelayedCandidate || localCandidate.getType().equals((Object)CandidateType.RELAYED_CANDIDATE) || validPair.getRemoteCandidate().getType().equals((Object)CandidateType.RELAYED_CANDIDATE);
            boolean nominate2 = false;
            Map<String, TimerTask> map2 = this.validatedCandidates;
            synchronized (map2) {
                TimerTask task = this.validatedCandidates.get(component3.toShortString());
                if (isRelayed && task == null) {
                    Timer timer2 = new Timer();
                    task = new RelayedCandidateTask(validPair);
                    this.logger.info("Wait timeout to nominate relayed candidate");
                    timer2.schedule(task, 0L);
                    this.validatedCandidates.put(component3.toShortString(), task);
                } else if (!isRelayed) {
                    if (task != null) {
                        task.cancel();
                        this.logger.info("Found a better candidate pair to nominate for " + component3.toShortString());
                    }
                    this.logger.info("Nominate (first highest valid): " + validPair.toShortString());
                    nominate2 = true;
                }
            }
            if (nominate2) {
                this.parentAgent.nominate(validPair);
            }
        }
    }

    private class RelayedCandidateTask
    extends TimerTask
    implements PropertyChangeListener {
        private static final int WAIT_TIME = 800;
        private final CandidatePair pair;
        private boolean cancelled = false;

        public RelayedCandidateTask(CandidatePair pair) {
            this.pair = pair;
            pair.getParentComponent().getParentStream().getCheckList().addChecksListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!"CheckListChecks".equals(evt.getPropertyName())) {
                return;
            }
            CheckList checkList = (CheckList)evt.getSource();
            boolean allFailed = true;
            CheckList checkList2 = checkList;
            synchronized (checkList2) {
                for (CandidatePair c : checkList) {
                    if (c == this.pair || c.getState() == CandidatePairState.FAILED) continue;
                    allFailed = false;
                    break;
                }
            }
            if (allFailed && !this.pair.isNominated()) {
                this.cancel();
                DefaultNominator.this.logger.info("Nominate (first highest valid): " + this.pair.toShortString());
                DefaultNominator.this.parentAgent.nominate(this.pair);
            }
        }

        @Override
        public boolean cancel() {
            this.cancelled = true;
            return super.cancel();
        }

        @Override
        public void run() {
            try {
                Thread.sleep(800L);
            }
            catch (InterruptedException e) {
                this.cancelled = true;
            }
            Component component3 = this.pair.getParentComponent();
            component3.getParentStream().getCheckList().removeChecksListener(this);
            DefaultNominator.this.validatedCandidates.remove(component3.toShortString());
            if (this.cancelled) {
                return;
            }
            DefaultNominator.this.logger.info("Nominate (first highest valid): " + this.pair.toShortString());
            DefaultNominator.this.parentAgent.nominate(this.pair);
        }
    }
}

