/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.ice4j.attribute;

import gg.essential.lib.ice4j.StunException;
import gg.essential.lib.ice4j.attribute.Attribute;

public class RequestedTransportAttribute
extends Attribute {
    public static final String NAME = "REQUESTED-TRANSPORT";
    public static final char DATA_LENGTH = '\u0004';
    public static final byte UDP = 17;
    public static final byte TCP = 6;
    byte transportProtocol = (byte)17;

    RequestedTransportAttribute() {
        super('\u0019');
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof RequestedTransportAttribute)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        RequestedTransportAttribute att = (RequestedTransportAttribute)obj;
        return att.getAttributeType() == this.getAttributeType() && att.getDataLength() == this.getDataLength() && att.transportProtocol == this.transportProtocol;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public char getDataLength() {
        return '\u0004';
    }

    @Override
    public byte[] encode() {
        byte[] binValue = new byte[]{(byte)(this.getAttributeType() >> 8), (byte)(this.getAttributeType() & 0xFF), (byte)(this.getDataLength() >> 8), (byte)(this.getDataLength() & 0xFF), this.transportProtocol, 0, 0, 0};
        return binValue;
    }

    @Override
    void decodeAttributeBody(byte[] attributeValue, char offset2, char length) throws StunException {
        if (length != '\u0004') {
            throw new StunException("length invalid");
        }
        this.transportProtocol = attributeValue[offset2];
    }

    public void setRequestedTransport(byte transportProtocol) {
        this.transportProtocol = transportProtocol;
    }

    public int getRequestedTransport() {
        return this.transportProtocol;
    }
}

