/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.ice4j;

public enum Transport {
    TCP("tcp"),
    UDP("udp"),
    TLS("tls"),
    DTLS("dtls"),
    SCTP("sctp"),
    SSLTCP("ssltcp");

    private final String transportName;

    private Transport(String transportName) {
        this.transportName = transportName;
    }

    public String toString() {
        return this.transportName;
    }

    public static Transport parse(String transportName) throws IllegalArgumentException {
        if (UDP.toString().equals(transportName)) {
            return UDP;
        }
        if (TCP.toString().equals(transportName)) {
            return TCP;
        }
        if (TLS.toString().equals(transportName)) {
            return TLS;
        }
        if (SCTP.toString().equals(transportName)) {
            return SCTP;
        }
        if (DTLS.toString().equals(transportName)) {
            return DTLS;
        }
        if (SSLTCP.toString().equals(transportName)) {
            return SSLTCP;
        }
        throw new IllegalArgumentException(transportName + " is not a currently supported Transport");
    }
}

