/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.gson.internal;

import gg.essential.lib.gson.JsonElement;
import gg.essential.lib.gson.JsonIOException;
import gg.essential.lib.gson.JsonNull;
import gg.essential.lib.gson.JsonParseException;
import gg.essential.lib.gson.JsonSyntaxException;
import gg.essential.lib.gson.internal.bind.TypeAdapters;
import gg.essential.lib.gson.stream.JsonReader;
import gg.essential.lib.gson.stream.JsonWriter;
import gg.essential.lib.gson.stream.MalformedJsonException;
import java.io.EOFException;
import java.io.IOException;
import java.io.Writer;

public final class Streams {
    private Streams() {
        throw new UnsupportedOperationException();
    }

    public static JsonElement parse(JsonReader reader2) throws JsonParseException {
        boolean isEmpty2 = true;
        try {
            reader2.peek();
            isEmpty2 = false;
            return TypeAdapters.JSON_ELEMENT.read(reader2);
        }
        catch (EOFException e) {
            if (isEmpty2) {
                return JsonNull.INSTANCE;
            }
            throw new JsonSyntaxException(e);
        }
        catch (MalformedJsonException e) {
            throw new JsonSyntaxException(e);
        }
        catch (IOException e) {
            throw new JsonIOException(e);
        }
        catch (NumberFormatException e) {
            throw new JsonSyntaxException(e);
        }
    }

    public static void write(JsonElement element, JsonWriter writer) throws IOException {
        TypeAdapters.JSON_ELEMENT.write(writer, element);
    }

    public static Writer writerForAppendable(Appendable appendable) {
        return appendable instanceof Writer ? (Writer)appendable : new AppendableWriter(appendable);
    }

    private static final class AppendableWriter
    extends Writer {
        private final Appendable appendable;
        private final CurrentWrite currentWrite = new CurrentWrite();

        AppendableWriter(Appendable appendable) {
            this.appendable = appendable;
        }

        @Override
        public void write(char[] chars, int offset2, int length) throws IOException {
            this.currentWrite.chars = chars;
            this.appendable.append(this.currentWrite, offset2, offset2 + length);
        }

        @Override
        public void write(int i2) throws IOException {
            this.appendable.append((char)i2);
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }

        static class CurrentWrite
        implements CharSequence {
            char[] chars;

            CurrentWrite() {
            }

            @Override
            public int length() {
                return this.chars.length;
            }

            @Override
            public char charAt(int i2) {
                return this.chars[i2];
            }

            @Override
            public CharSequence subSequence(int start2, int end) {
                return new String(this.chars, start2, end - start2);
            }
        }
    }
}

