/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.caffeine.cache;

import gg.essential.lib.caffeine.cache.FS;
import gg.essential.lib.caffeine.cache.Node;
import gg.essential.lib.caffeine.cache.UnsafeAccess;
import java.lang.ref.ReferenceQueue;

class FSR<K, V>
extends FS<K, V> {
    protected static final long WRITE_TIME_OFFSET = UnsafeAccess.objectFieldOffset(FSR.class, "writeTime");
    volatile long writeTime;

    FSR() {
    }

    FSR(K key, ReferenceQueue<K> keyReferenceQueue, V value2, ReferenceQueue<V> valueReferenceQueue, int weight, long now) {
        super(key, keyReferenceQueue, value2, valueReferenceQueue, weight, now);
        UnsafeAccess.UNSAFE.putLong(this, WRITE_TIME_OFFSET, now);
    }

    FSR(Object keyReference, V value2, ReferenceQueue<V> valueReferenceQueue, int weight, long now) {
        super(keyReference, value2, valueReferenceQueue, weight, now);
        UnsafeAccess.UNSAFE.putLong(this, WRITE_TIME_OFFSET, now);
    }

    @Override
    public final long getWriteTime() {
        return UnsafeAccess.UNSAFE.getLong(this, WRITE_TIME_OFFSET);
    }

    @Override
    public final void setWriteTime(long writeTime) {
        UnsafeAccess.UNSAFE.putLong(this, WRITE_TIME_OFFSET, writeTime);
    }

    @Override
    public final boolean casWriteTime(long expect, long update2) {
        return this.writeTime == expect && UnsafeAccess.UNSAFE.compareAndSwapLong(this, WRITE_TIME_OFFSET, expect, update2);
    }

    @Override
    public Node<K, V> newNode(K key, ReferenceQueue<K> keyReferenceQueue, V value2, ReferenceQueue<V> valueReferenceQueue, int weight, long now) {
        return new FSR<K, V>(key, keyReferenceQueue, value2, valueReferenceQueue, weight, now);
    }

    @Override
    public Node<K, V> newNode(Object keyReference, V value2, ReferenceQueue<V> valueReferenceQueue, int weight, long now) {
        return new FSR<K, V>(keyReference, value2, valueReferenceQueue, weight, now);
    }
}

