/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.image.imagescaling;

import gg.essential.image.imagescaling.ResampleFilter;

class BiCubicFilter
implements ResampleFilter {
    protected final float a;

    public BiCubicFilter() {
        this.a = -0.5f;
    }

    protected BiCubicFilter(float a) {
        this.a = a;
    }

    @Override
    public final float apply(float value2) {
        if (value2 == 0.0f) {
            return 1.0f;
        }
        if (value2 < 0.0f) {
            value2 = -value2;
        }
        float vv = value2 * value2;
        if (value2 < 1.0f) {
            return (this.a + 2.0f) * vv * value2 - (this.a + 3.0f) * vv + 1.0f;
        }
        if (value2 < 2.0f) {
            return this.a * vv * value2 - 5.0f * this.a * vv + 8.0f * this.a * value2 - 4.0f * this.a;
        }
        return 0.0f;
    }

    @Override
    public float getSamplingRadius() {
        return 2.0f;
    }

    @Override
    public String getName() {
        return "BiCubic";
    }
}

