/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.handlers;

import gg.essential.config.EssentialConfig;
import gg.essential.elementa.constraints.animation.Animations;
import gg.essential.event.gui.MouseScrollEvent;
import gg.essential.lib.kbrewster.eventbus.Subscribe;
import gg.essential.universal.UMinecraft;
import gg.essential.util.OptiFineUtil;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Options;

public class ZoomHandler {
    private static ZoomHandler instance;
    private boolean oldSmoothCamera;
    public boolean isZoomActive;
    public KeyMapping zoomKeybinding;
    private static final float normalModifier = 4.0f;
    private float currentModifier;
    private float desiredModifier;
    private float smoothZoomProgress;
    private boolean hasScrolledYet;
    private boolean zoomingOut;
    private long timeOfLastUpdate;
    private boolean isZoomToggled;
    private boolean isZoomBeingHeld;

    public ZoomHandler() {
        this.desiredModifier = this.currentModifier = 4.0f;
        this.smoothZoomProgress = 0.0f;
        this.hasScrolledYet = false;
        this.zoomingOut = false;
        this.timeOfLastUpdate = System.currentTimeMillis();
        this.isZoomToggled = false;
        this.isZoomBeingHeld = false;
    }

    public static ZoomHandler getInstance() {
        if (instance == null) {
            instance = new ZoomHandler();
        }
        return instance;
    }

    private boolean getZoomState() {
        if (!EssentialConfig.INSTANCE.getEssentialEnabled()) {
            return false;
        }
        boolean down = this.zoomKeybinding.m_90857_();
        if (!EssentialConfig.INSTANCE.getToggleToZoom()) {
            return down;
        }
        if (down) {
            if (this.isZoomBeingHeld) {
                return this.isZoomToggled;
            }
            this.isZoomBeingHeld = true;
            this.isZoomToggled = !this.isZoomToggled;
        } else {
            this.isZoomBeingHeld = false;
        }
        return this.isZoomToggled;
    }

    public float applyModifiers(float f) {
        if (OptiFineUtil.isLoaded()) {
            return f;
        }
        Options settings2 = UMinecraft.getSettings();
        if (UMinecraft.getMinecraft().f_91080_ == null && this.getZoomState()) {
            if (!this.isZoomActive) {
                this.isZoomActive = true;
                this.timeOfLastUpdate = System.currentTimeMillis();
                if (EssentialConfig.INSTANCE.getZoomSmoothCamera()) {
                    this.oldSmoothCamera = settings2.f_92067_;
                    settings2.f_92067_ = true;
                }
                this.desiredModifier = 4.0f;
                this.currentModifier = 4.0f;
            }
            f /= this.getZoomHeldModifier();
            if (EssentialConfig.INSTANCE.getSmoothZoomAnimation()) {
                f *= this.getConstantModifier();
            }
        } else {
            if (this.isZoomActive) {
                this.isZoomActive = false;
                this.hasScrolledYet = false;
                settings2.f_92067_ = this.oldSmoothCamera;
                this.queueTerrainUpdate();
                this.zoomingOut = true;
            }
            if (this.zoomingOut) {
                if (EssentialConfig.INSTANCE.getSmoothZoomAnimation()) {
                    if (this.smoothZoomProgress > 0.0f) {
                        f *= this.getConstantModifier();
                    } else {
                        this.zoomingOut = false;
                    }
                } else {
                    this.zoomingOut = false;
                }
            }
        }
        return f;
    }

    @Subscribe
    public void onMouseScroll(MouseScrollEvent event) {
        if (!this.isZoomActive || !this.getZoomState() || event.getScreen() != null) {
            return;
        }
        event.setCancelled(true);
        double moved = event.getAmount();
        if (moved > 0.0) {
            this.smoothZoomProgress = 0.0f;
            this.hasScrolledYet = true;
            this.desiredModifier += 0.25f * this.desiredModifier;
        } else if (moved < 0.0) {
            this.smoothZoomProgress = 0.0f;
            this.hasScrolledYet = true;
            this.desiredModifier -= 0.25f * this.desiredModifier;
            this.queueTerrainUpdate();
        }
    }

    private float getZoomHeldModifier() {
        long currentTime = System.currentTimeMillis();
        long timeSinceLastUpdate = currentTime - this.timeOfLastUpdate;
        if (this.desiredModifier < 1.0f) {
            this.desiredModifier = 1.0f;
        }
        if (this.desiredModifier > 600.0f) {
            this.desiredModifier = 600.0f;
        }
        if (EssentialConfig.INSTANCE.getSmoothZoomAnimation()) {
            if (this.hasScrolledYet && this.smoothZoomProgress < 1.0f) {
                this.queueTerrainUpdate();
                this.smoothZoomProgress += 0.004f * (float)timeSinceLastUpdate;
                this.smoothZoomProgress = this.smoothZoomProgress > 1.0f ? 1.0f : this.smoothZoomProgress;
                return this.currentModifier += (this.desiredModifier - this.currentModifier) * this.calculateEasing(this.smoothZoomProgress);
            }
        } else {
            this.currentModifier = this.desiredModifier;
        }
        return this.desiredModifier;
    }

    private float getConstantModifier() {
        long currentTime = System.currentTimeMillis();
        long timeSinceLastUpdate = currentTime - this.timeOfLastUpdate;
        this.timeOfLastUpdate = currentTime;
        if (this.isZoomActive) {
            if (this.hasScrolledYet) {
                return 1.0f;
            }
            if (this.smoothZoomProgress < 1.0f) {
                this.smoothZoomProgress += 0.005f * (float)timeSinceLastUpdate;
                this.smoothZoomProgress = this.smoothZoomProgress > 1.0f ? 1.0f : this.smoothZoomProgress;
                return 4.0f - 3.0f * this.calculateEasing(this.smoothZoomProgress);
            }
        } else {
            if (this.hasScrolledYet) {
                this.hasScrolledYet = false;
                this.smoothZoomProgress = 1.0f;
            }
            if (this.smoothZoomProgress > 0.0f) {
                this.smoothZoomProgress -= 0.005f * (float)timeSinceLastUpdate;
                this.smoothZoomProgress = this.smoothZoomProgress < 0.0f ? 0.0f : this.smoothZoomProgress;
                this.queueTerrainUpdate();
                float progress = 1.0f - this.smoothZoomProgress;
                float diff = 1.0f / this.currentModifier;
                return diff + (1.0f - diff) * this.calculateEasing(progress);
            }
        }
        return 1.0f;
    }

    private void queueTerrainUpdate() {
        UMinecraft.getMinecraft().f_91060_.m_109826_();
    }

    private float calculateEasing(float progress) {
        switch (EssentialConfig.INSTANCE.getSmoothZoomAlgorithm()) {
            case 0: {
                return Animations.IN_OUT_QUAD.getValue(progress);
            }
            case 1: {
                return Animations.IN_OUT_CIRCULAR.getValue(progress);
            }
            case 2: {
                return Animations.OUT_QUINT.getValue(progress);
            }
        }
        return Animations.IN_OUT_QUAD.getValue(progress);
    }
}

