/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.gui.screenshot.providers;

import gg.essential.gui.screenshot.RemoteScreenshot;
import gg.essential.gui.screenshot.ScreenshotId;
import gg.essential.gui.screenshot.downsampling.BufferBackedImage;
import gg.essential.gui.screenshot.downsampling.ErrorImage;
import gg.essential.gui.screenshot.downsampling.PixelBuffer;
import gg.essential.gui.screenshot.providers.WindowedProvider;
import gg.essential.media.model.Media;
import gg.essential.media.model.MediaVariant;
import gg.essential.util.ExtensionsKt;
import gg.essential.util.WebUtil;
import gg.essential.util.lwjgl3.api.ImageData;
import gg.essential.util.lwjgl3.api.NativeImageReader;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.IntProgression;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u000f\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B?\u0012\u0010\u0010\u0004\u001a\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0014\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t\u00a2\u0006\u0004\b\f\u0010\rJ\u0019\u0010\u0010\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J7\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00020\u00182\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u0014\u0010\b\u001a\u00020\u00078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\u001bR\u001e\u0010\u0004\u001a\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u001cR7\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00160\u00122\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00160\u00128V@VX\u0096\u008e\u0002\u00a2\u0006\u0012\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!*\u0004\b\"\u0010#R\u0014\u0010\u0006\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010%R\"\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010&\u00a8\u0006'"}, d2={"Lgg/essential/gui/screenshot/providers/CloudflareImageProvider;", "Lgg/essential/gui/screenshot/providers/WindowedProvider;", "Lgg/essential/gui/screenshot/downsampling/PixelBuffer;", "Lgg/essential/gui/screenshot/providers/WindowedImageProvider;", "fallbackProvider", "Lgg/essential/util/lwjgl3/api/NativeImageReader;", "nativeImageReader", "Lio/netty/buffer/ByteBufAllocator;", "allocator", "Lkotlin/Pair;", "", "targetResolution", "<init>", "(Lgg/essential/gui/screenshot/providers/WindowedProvider;Lgg/essential/util/lwjgl3/api/NativeImageReader;Lio/netty/buffer/ByteBufAllocator;Lkotlin/Pair;)V", "Lgg/essential/media/model/Media;", "media", "loadImage", "(Lgg/essential/media/model/Media;)Lgg/essential/gui/screenshot/downsampling/PixelBuffer;", "", "Lgg/essential/gui/screenshot/providers/WindowedProvider$Window;", "windows", "", "Lgg/essential/gui/screenshot/ScreenshotId;", "optional", "", "provide", "(Ljava/util/List;Ljava/util/Set;)Ljava/util/Map;", "Lio/netty/buffer/ByteBufAllocator;", "Lgg/essential/gui/screenshot/providers/WindowedProvider;", "<set-?>", "getItems", "()Ljava/util/List;", "setItems", "(Ljava/util/List;)V", "getItems$delegate", "(Lgg/essential/gui/screenshot/providers/CloudflareImageProvider;)Ljava/lang/Object;", "items", "Lgg/essential/util/lwjgl3/api/NativeImageReader;", "Lkotlin/Pair;", "Essential 1.18.2-forge"})
public final class CloudflareImageProvider
implements WindowedProvider<PixelBuffer> {
    @NotNull
    private final WindowedProvider<PixelBuffer> fallbackProvider;
    @NotNull
    private final NativeImageReader nativeImageReader;
    @NotNull
    private final ByteBufAllocator allocator;
    @Nullable
    private final Pair<Integer, Integer> targetResolution;

    public CloudflareImageProvider(@NotNull WindowedProvider<? extends PixelBuffer> fallbackProvider, @NotNull NativeImageReader nativeImageReader, @NotNull ByteBufAllocator allocator2, @Nullable Pair<Integer, Integer> targetResolution) {
        Intrinsics.checkNotNullParameter(fallbackProvider, (String)"fallbackProvider");
        Intrinsics.checkNotNullParameter((Object)nativeImageReader, (String)"nativeImageReader");
        Intrinsics.checkNotNullParameter((Object)allocator2, (String)"allocator");
        this.fallbackProvider = fallbackProvider;
        this.nativeImageReader = nativeImageReader;
        this.allocator = allocator2;
        this.targetResolution = targetResolution;
    }

    @Override
    @NotNull
    public List<ScreenshotId> getItems() {
        return this.fallbackProvider.getItems();
    }

    @Override
    public void setItems(@NotNull List<? extends ScreenshotId> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.fallbackProvider.setItems(list);
    }

    private static Object getItems$delegate(CloudflareImageProvider cloudflareImageProvider) {
        return Reflection.mutableProperty0((MutablePropertyReference0)((MutablePropertyReference0)new MutablePropertyReference0Impl(cloudflareImageProvider.fallbackProvider, WindowedProvider.class, "items", "getItems()Ljava/util/List;", 0)));
    }

    @Override
    @NotNull
    public Map<ScreenshotId, PixelBuffer> provide(@NotNull List<WindowedProvider.Window> windows, @NotNull Set<? extends ScreenshotId> optional) {
        Intrinsics.checkNotNullParameter(windows, (String)"windows");
        Intrinsics.checkNotNullParameter(optional, (String)"optional");
        Map map2 = new LinkedHashMap();
        block0: for (WindowedProvider.Window window : windows) {
            IntProgression intProgression = ExtensionsKt.reversed(window.getRange(), window.getBackwards());
            int i2 = intProgression.getFirst();
            int n = intProgression.getLast();
            int n2 = intProgression.getStep();
            if ((n2 <= 0 || i2 > n) && (n2 >= 0 || n > i2)) continue;
            while (true) {
                ScreenshotId item;
                if (!optional.contains(item = this.getItems().get(i2)) && item instanceof RemoteScreenshot) {
                    Map map3 = map2;
                    if (this.loadImage(((RemoteScreenshot)item).getMedia()) != null) {
                        PixelBuffer pixelBuffer;
                        map3.put(item, pixelBuffer);
                    }
                }
                if (i2 == n) continue block0;
                i2 += n2;
            }
        }
        map2.putAll(this.fallbackProvider.provide(windows, SetsKt.plus(optional, (Iterable)map2.keySet())));
        return map2;
    }

    private final PixelBuffer loadImage(Media media) {
        Object object;
        Object object2;
        if (this.targetResolution != null) {
            object2 = this.targetResolution;
            int width2 = ((Number)object2.component1()).intValue();
            int height2 = ((Number)object2.component2()).intValue();
            Object object3 = media.getVariants().get("flexible");
            if (object3 == null || (object3 = ((MediaVariant)object3).getUrl()) == null) {
                return null;
            }
            Object baseUrl = object3;
            String options2 = "width=" + width2 + ",height=" + height2;
            object = StringsKt.endsWith$default((String)baseUrl, (String)"/", (boolean)false, (int)2, null) ? (String)baseUrl + options2 : (String)baseUrl + "/" + options2;
        } else {
            object = media.getVariants().get("original");
            if (object == null || (object = ((MediaVariant)object).getUrl()) == null) {
                return null;
            }
        }
        Object url = object;
        try {
            byte[] bytes = WebUtil.downloadToBytes((String)url, "Essential Screenshot Downloader");
            ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])bytes);
            Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"wrappedBuffer(...)");
            ImageData imageData = this.nativeImageReader.getImageData(byteBuf, this.allocator);
            object2 = new BufferBackedImage(imageData);
        }
        catch (IOException e) {
            e.printStackTrace();
            object2 = new ErrorImage();
        }
        return object2;
    }
}

