/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.gui.screenshot.image;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import gg.essential.elementa.UIComponent;
import gg.essential.elementa.state.BasicState;
import gg.essential.elementa.state.State;
import gg.essential.gui.screenshot.image.PixelBufferTexture;
import gg.essential.universal.UGraphics;
import gg.essential.universal.UMatrixStack;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\b\b\u0016\u0018\u00002\u00020\u0001B\u0015\b\u0016\u0012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0017\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0006\u00a2\u0006\u0004\b\u0004\u0010\u0007J\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ-\u0010\u0012\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u001f\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lgg/essential/gui/screenshot/image/ScreenshotImage;", "Lgg/essential/elementa/UIComponent;", "Lgg/essential/gui/screenshot/image/PixelBufferTexture;", "texture", "<init>", "(Lgg/essential/gui/screenshot/image/PixelBufferTexture;)V", "Lgg/essential/elementa/state/State;", "(Lgg/essential/elementa/state/State;)V", "Lgg/essential/universal/UMatrixStack;", "matrixStack", "", "draw", "(Lgg/essential/universal/UMatrixStack;)V", "Ljava/awt/Color;", "color", "", "width", "height", "renderImage", "(Lgg/essential/universal/UMatrixStack;Ljava/awt/Color;DD)V", "Lgg/essential/elementa/state/State;", "getTexture", "()Lgg/essential/elementa/state/State;", "Essential 1.18.2-forge"})
public class ScreenshotImage
extends UIComponent {
    @NotNull
    private final State<PixelBufferTexture> texture;

    public ScreenshotImage(@NotNull State<PixelBufferTexture> texture) {
        Intrinsics.checkNotNullParameter(texture, (String)"texture");
        this.texture = texture;
    }

    @NotNull
    public final State<PixelBufferTexture> getTexture() {
        return this.texture;
    }

    public ScreenshotImage(@Nullable PixelBufferTexture texture) {
        this((State<PixelBufferTexture>)new BasicState<PixelBufferTexture>(texture));
    }

    public /* synthetic */ ScreenshotImage(PixelBufferTexture pixelBufferTexture, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            pixelBufferTexture = null;
        }
        this(pixelBufferTexture);
    }

    @Override
    public void draw(@NotNull UMatrixStack matrixStack) {
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        this.beforeDrawCompat(matrixStack);
        PixelBufferTexture textureInstance = this.texture.get();
        if (textureInstance != null) {
            double x = this.getLeft();
            double y = this.getTop();
            double width2 = this.getWidth();
            double height2 = this.getHeight();
            Color color2 = this.getColor();
            if (color2.getAlpha() == 0) {
                super.draw(matrixStack);
                return;
            }
            matrixStack.push();
            matrixStack.translate(x, y, 0.0);
            this.renderImage(matrixStack, color2, width2, height2);
            matrixStack.pop();
        }
        super.draw(matrixStack);
    }

    public final void renderImage(@NotNull UMatrixStack matrixStack, @NotNull Color color2, double width2, double height2) {
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        Intrinsics.checkNotNullParameter((Object)color2, (String)"color");
        PixelBufferTexture pixelBufferTexture = this.texture.get();
        if (pixelBufferTexture == null) {
            return;
        }
        PixelBufferTexture textureInstance = pixelBufferTexture;
        UGraphics.enableBlend();
        UGraphics.enableAlpha();
        int glId = textureInstance.m_117963_();
        UGraphics.bindTexture(0, glId);
        float red = (float)color2.getRed() / 255.0f;
        float green = (float)color2.getGreen() / 255.0f;
        float blue = (float)color2.getBlue() / 255.0f;
        float alpha = (float)color2.getAlpha() / 255.0f;
        UGraphics worldRenderer = UGraphics.getFromTessellator();
        UGraphics.configureTexture(glId, ScreenshotImage::renderImage$lambda$0);
        worldRenderer.beginWithDefaultShader(UGraphics.DrawMode.QUADS, DefaultVertexFormat.f_85819_);
        worldRenderer.pos(matrixStack, 0.0, height2, 0.0).tex(0.0, 1.0).color(red, green, blue, alpha).endVertex();
        worldRenderer.pos(matrixStack, width2, height2, 0.0).tex(1.0, 1.0).color(red, green, blue, alpha).endVertex();
        worldRenderer.pos(matrixStack, width2, 0.0, 0.0).tex(1.0, 0.0).color(red, green, blue, alpha).endVertex();
        worldRenderer.pos(matrixStack, 0.0, 0.0, 0.0).tex(0.0, 0.0).color(red, green, blue, alpha).endVertex();
        worldRenderer.drawDirect();
    }

    private static final void renderImage$lambda$0() {
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
    }
}

