/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.gui.screenshot.editor;

import gg.essential.elementa.UIComponent;
import gg.essential.elementa.UIConstraints;
import gg.essential.elementa.components.UIBlock;
import gg.essential.elementa.components.UIContainer;
import gg.essential.elementa.components.Window;
import gg.essential.elementa.constraints.CenterConstraint;
import gg.essential.elementa.constraints.HeightConstraint;
import gg.essential.elementa.constraints.PositionConstraint;
import gg.essential.elementa.constraints.RelativeConstraint;
import gg.essential.elementa.constraints.SuperConstraint;
import gg.essential.elementa.constraints.WidthConstraint;
import gg.essential.elementa.constraints.XConstraint;
import gg.essential.elementa.constraints.YConstraint;
import gg.essential.elementa.dsl.ComponentsKt;
import gg.essential.elementa.dsl.ConstraintsKt;
import gg.essential.elementa.dsl.UtilitiesKt;
import gg.essential.elementa.effects.ScissorEffect;
import gg.essential.elementa.events.UIClickEvent;
import gg.essential.elementa.state.BasicState;
import gg.essential.elementa.state.State;
import gg.essential.gui.EssentialPalette;
import gg.essential.gui.common.ExtensionsKt;
import gg.essential.gui.common.UINanoVG;
import gg.essential.gui.common.WeakState;
import gg.essential.gui.screenshot.LocalScreenshot;
import gg.essential.gui.screenshot.RemoteScreenshot;
import gg.essential.gui.screenshot.ScreenshotId;
import gg.essential.gui.screenshot.components.ScreenshotBrowser;
import gg.essential.gui.screenshot.editor.ScreenshotCanvas;
import gg.essential.gui.screenshot.editor.change.Change;
import gg.essential.gui.screenshot.editor.change.CropChange;
import gg.essential.gui.screenshot.editor.change.VectorStroke;
import gg.essential.gui.screenshot.image.PixelBufferTexture;
import gg.essential.gui.screenshot.image.ScreenshotImage;
import gg.essential.handlers.screenshot.ClientScreenshotMetadata;
import gg.essential.network.connectionmanager.media.ScreenshotManager;
import gg.essential.universal.UMatrixStack;
import gg.essential.universal.UResolution;
import gg.essential.util.Multithreading;
import gg.essential.util.lwjgl3.api.nanovg.NanoVG;
import gg.essential.vigilance.gui.VigilancePalette;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.concurrent.CompletableFuture;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadWriteProperty;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001:\u0004TUVWB\u0017\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006JE\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r2\b\b\u0002\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\r\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0013\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\r0\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J)\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170\u001a2\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0017\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\r\u0010\u001e\u001a\u00020\u001d\u00a2\u0006\u0004\b\u001e\u0010\u001fR\u0017\u0010!\u001a\u00020 8\u0006\u00a2\u0006\f\n\u0004\b!\u0010\"\u001a\u0004\b#\u0010$R\u0017\u0010&\u001a\u00020%8\u0006\u00a2\u0006\f\n\u0004\b&\u0010'\u001a\u0004\b(\u0010)R\"\u0010+\u001a\u00020*8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b+\u0010,\u001a\u0004\b-\u0010.\"\u0004\b/\u00100RE\u00103\u001a%\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020\u001d01\u00a2\u0006\u0002\b28\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b3\u00104\u001a\u0004\b5\u00106\"\u0004\b7\u00108R\u0014\u00109\u001a\u00020*8\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\b9\u0010,R!\u0010?\u001a\b\u0012\u0004\u0012\u00020\r0:8FX\u0086\u0084\u0002\u00a2\u0006\f\u001a\u0004\b;\u0010<*\u0004\b=\u0010>R\u001b\u0010D\u001a\u00020\u00018FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b@\u0010A\u001a\u0004\bB\u0010CR\u001f\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010E\u001a\u0004\bF\u0010\u0016R\u0017\u0010H\u001a\u00020G8\u0006\u00a2\u0006\f\n\u0004\bH\u0010I\u001a\u0004\bJ\u0010KR!\u0010N\u001a\b\u0012\u0004\u0012\u00020\r0:8FX\u0086\u0084\u0002\u00a2\u0006\f\u001a\u0004\bL\u0010<*\u0004\bM\u0010>R\u001b\u0010P\u001a\u00060OR\u00020\u00008\u0006\u00a2\u0006\f\n\u0004\bP\u0010Q\u001a\u0004\bR\u0010S\u00a8\u0006X"}, d2={"Lgg/essential/gui/screenshot/editor/ScreenshotCanvas;", "Lgg/essential/elementa/components/UIContainer;", "Lgg/essential/elementa/state/State;", "Lgg/essential/gui/screenshot/image/PixelBufferTexture;", "screenshot", "<init>", "(Lgg/essential/elementa/state/State;)V", "Lgg/essential/gui/screenshot/ScreenshotId;", "source", "Lgg/essential/network/connectionmanager/media/ScreenshotManager;", "screenshotManager", "Lgg/essential/gui/screenshot/components/ScreenshotBrowser;", "screenshotBrowser", "", "temp", "favorite", "viewAfter", "Ljava/util/concurrent/CompletableFuture;", "Ljava/io/File;", "exportImage", "(Lgg/essential/gui/screenshot/ScreenshotId;Lgg/essential/network/connectionmanager/media/ScreenshotManager;Lgg/essential/gui/screenshot/components/ScreenshotBrowser;ZZZ)Ljava/util/concurrent/CompletableFuture;", "getHasChanges", "()Lgg/essential/elementa/state/State;", "", "mouseX", "mouseY", "Lkotlin/Pair;", "getRelativeMousePosition", "(FF)Lkotlin/Pair;", "", "reset", "()V", "Lgg/essential/elementa/components/UIBlock;", "background", "Lgg/essential/elementa/components/UIBlock;", "getBackground", "()Lgg/essential/elementa/components/UIBlock;", "Lgg/essential/gui/screenshot/editor/ScreenshotCanvas$Crop;", "cropSettings", "Lgg/essential/gui/screenshot/editor/ScreenshotCanvas$Crop;", "getCropSettings", "()Lgg/essential/gui/screenshot/editor/ScreenshotCanvas$Crop;", "", "mouseButton", "I", "getMouseButton", "()I", "setMouseButton", "(I)V", "Lkotlin/Function4;", "Lkotlin/ExtensionFunctionType;", "onDraw", "Lkotlin/jvm/functions/Function4;", "getOnDraw", "()Lkotlin/jvm/functions/Function4;", "setOnDraw", "(Lkotlin/jvm/functions/Function4;)V", "padding", "Lgg/essential/elementa/state/BasicState;", "getRedoEnabled", "()Lgg/essential/elementa/state/BasicState;", "getRedoEnabled$delegate", "(Lgg/essential/gui/screenshot/editor/ScreenshotCanvas;)Ljava/lang/Object;", "redoEnabled", "retainedImage$delegate", "Lkotlin/properties/ReadWriteProperty;", "getRetainedImage", "()Lgg/essential/elementa/components/UIContainer;", "retainedImage", "Lgg/essential/elementa/state/State;", "getScreenshot", "Lgg/essential/elementa/UIComponent;", "screenshotDisplay", "Lgg/essential/elementa/UIComponent;", "getScreenshotDisplay", "()Lgg/essential/elementa/UIComponent;", "getUndoEnabled", "getUndoEnabled$delegate", "undoEnabled", "Lgg/essential/gui/screenshot/editor/ScreenshotCanvas$VectorEditingOverlay;", "vectorEditingOverlay", "Lgg/essential/gui/screenshot/editor/ScreenshotCanvas$VectorEditingOverlay;", "getVectorEditingOverlay", "()Lgg/essential/gui/screenshot/editor/ScreenshotCanvas$VectorEditingOverlay;", "Crop", "CropAlignment", "ImageCropItem", "VectorEditingOverlay", "Essential 1.18.2-forge"})
@SourceDebugExtension(value={"SMAP\nScreenshotCanvas.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScreenshotCanvas.kt\ngg/essential/gui/screenshot/editor/ScreenshotCanvas\n+ 2 components.kt\ngg/essential/elementa/dsl/ComponentsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,542:1\n9#2,3:543\n9#2,3:546\n9#2,3:549\n9#2,3:552\n13309#3,2:555\n1549#4:557\n1620#4,3:558\n*S KotlinDebug\n*F\n+ 1 ScreenshotCanvas.kt\ngg/essential/gui/screenshot/editor/ScreenshotCanvas\n*L\n85#1:543,3\n93#1:546,3\n100#1:549,3\n111#1:552,3\n123#1:555,2\n285#1:557\n285#1:558,3\n*E\n"})
public final class ScreenshotCanvas
extends UIContainer {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final State<PixelBufferTexture> screenshot;
    @NotNull
    private Function4<? super UIContainer, ? super Float, ? super Float, ? super Integer, Unit> onDraw;
    private int mouseButton;
    private final int padding;
    @NotNull
    private final UIComponent screenshotDisplay;
    @NotNull
    private final UIBlock background;
    @NotNull
    private final Crop cropSettings;
    @NotNull
    private final ReadWriteProperty retainedImage$delegate;
    @NotNull
    private final VectorEditingOverlay vectorEditingOverlay;

    /*
     * WARNING - void declaration
     */
    public ScreenshotCanvas(@NotNull State<PixelBufferTexture> screenshot) {
        void $this$vectorEditingOverlay_u24lambda_u243;
        UIConstraints $this$retainedImage_delegate_u24lambda_u242;
        UIConstraints $this$background_u24lambda_u241;
        UIConstraints $this$screenshotDisplay_u24lambda_u240;
        UIComponent uIComponent;
        Intrinsics.checkNotNullParameter(screenshot, (String)"screenshot");
        this.screenshot = screenshot;
        this.onDraw = onDraw.1.INSTANCE;
        this.mouseButton = -1;
        this.padding = 2;
        UIComponent $this$constrain$iv = new UIContainer(this){
            final /* synthetic */ ScreenshotCanvas this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseMove(@NotNull Window window) {
                Intrinsics.checkNotNullParameter((Object)window, (String)"window");
                if (this.this$0.getMouseButton() != -1) {
                    Pair<Float, Float> pair = this.getMousePosition();
                    float x = ((Number)pair.component1()).floatValue();
                    float y = ((Number)pair.component2()).floatValue();
                    this.this$0.getOnDraw().invoke((Object)this, (Object)Float.valueOf(x), (Object)Float.valueOf(y), (Object)this.this$0.getMouseButton());
                }
                super.mouseMove(window);
            }

            public void draw(@NotNull UMatrixStack matrixStack) {
                Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
                this.this$0.getVectorEditingOverlay().draw(matrixStack);
                super.draw(matrixStack);
            }
        }.onMouseClick((Function2<? super UIComponent, ? super UIClickEvent, Unit>)((Function2)new Function2<UIComponent, UIClickEvent, Unit>(this){
            final /* synthetic */ ScreenshotCanvas this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull UIComponent $this$onMouseClick, @NotNull UIClickEvent event) {
                Intrinsics.checkNotNullParameter((Object)$this$onMouseClick, (String)"$this$onMouseClick");
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.this$0.setMouseButton(event.getMouseButton());
                event.stopPropagation();
            }
        })).onMouseRelease((Function1<? super UIComponent, Unit>)((Function1)new Function1<UIComponent, Unit>(this){
            final /* synthetic */ ScreenshotCanvas this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull UIComponent $this$onMouseRelease) {
                Intrinsics.checkNotNullParameter((Object)$this$onMouseRelease, (String)"$this$onMouseRelease");
                this.this$0.setMouseButton(-1);
            }
        }));
        boolean $i$f$constrain = false;
        UIComponent $this$constrain_u24lambda_u240$iv = uIComponent = $this$constrain$iv;
        boolean bl = false;
        UIConstraints uIConstraints = $this$constrain_u24lambda_u240$iv.getConstraints();
        ScreenshotCanvas screenshotCanvas = this;
        boolean bl2 = false;
        $this$screenshotDisplay_u24lambda_u240.setHeight(ConstraintsKt.minus(UtilitiesKt.percent(100), UtilitiesKt.pixels$default(this.padding * 2, false, false, 3, null)));
        $this$screenshotDisplay_u24lambda_u240.setWidth(ConstraintsKt.minus(UtilitiesKt.percent(100), UtilitiesKt.pixels$default(this.padding * 2, false, false, 3, null)));
        $this$screenshotDisplay_u24lambda_u240.setX(UtilitiesKt.pixels$default(this.padding, false, false, 3, null));
        $this$screenshotDisplay_u24lambda_u240.setY(UtilitiesKt.pixels$default(this.padding, false, false, 3, null));
        screenshotCanvas.screenshotDisplay = ComponentsKt.childOf(uIComponent, this);
        $this$constrain$iv = new UIBlock(VigilancePalette.INSTANCE.getModalBackground());
        $i$f$constrain = false;
        $this$constrain_u24lambda_u240$iv = uIComponent = $this$constrain$iv;
        bl = false;
        $this$screenshotDisplay_u24lambda_u240 = $this$constrain_u24lambda_u240$iv.getConstraints();
        screenshotCanvas = this;
        boolean bl3 = false;
        $this$background_u24lambda_u241.setHeight(UtilitiesKt.percent(100));
        $this$background_u24lambda_u241.setWidth(UtilitiesKt.percent(100));
        screenshotCanvas.background = (UIBlock)ComponentsKt.childOf(uIComponent, this.screenshotDisplay);
        this.cropSettings = new Crop(null, null, null, null, 15, null);
        $this$constrain$iv = new UIContainer();
        $i$f$constrain = false;
        $this$constrain_u24lambda_u240$iv = uIComponent = $this$constrain$iv;
        bl = false;
        $this$background_u24lambda_u241 = $this$constrain_u24lambda_u240$iv.getConstraints();
        screenshotCanvas = this;
        boolean bl4 = false;
        $this$retainedImage_delegate_u24lambda_u242.setX(new RelativeConstraint(1.0f).bindValue(this.cropSettings.getLeft()));
        $this$retainedImage_delegate_u24lambda_u242.setY(new RelativeConstraint(1.0f).bindValue(this.cropSettings.getTop()));
        $this$retainedImage_delegate_u24lambda_u242.setWidth(new RelativeConstraint(1.0f).bindValue(this.cropSettings.getRight().zip(this.cropSettings.getLeft()).map(retainedImage.2.1.INSTANCE)));
        $this$retainedImage_delegate_u24lambda_u242.setHeight(new RelativeConstraint(1.0f).bindValue(this.cropSettings.getBottom().zip(this.cropSettings.getTop()).map(retainedImage.2.2.INSTANCE)));
        screenshotCanvas.retainedImage$delegate = ComponentsKt.provideDelegate(ComponentsKt.effect(ComponentsKt.childOf(uIComponent, this.screenshotDisplay), new ScissorEffect(null, false, 3, null)), this, $$delegatedProperties[0]);
        $this$constrain$iv = new VectorEditingOverlay(this, this.screenshot);
        $i$f$constrain = false;
        $this$constrain_u24lambda_u240$iv = uIComponent = $this$constrain$iv;
        bl = false;
        $this$retainedImage_delegate_u24lambda_u242 = $this$constrain_u24lambda_u240$iv.getConstraints();
        screenshotCanvas = this;
        boolean bl5 = false;
        $this$vectorEditingOverlay_u24lambda_u243.setX((XConstraint)ConstraintsKt.boundTo((SuperConstraint)UtilitiesKt.getPixels(0), this.screenshotDisplay));
        $this$vectorEditingOverlay_u24lambda_u243.setY((YConstraint)ConstraintsKt.boundTo((SuperConstraint)UtilitiesKt.getPixels(0), this.screenshotDisplay));
        $this$vectorEditingOverlay_u24lambda_u243.setHeight((HeightConstraint)ConstraintsKt.boundTo((SuperConstraint)UtilitiesKt.percent(100), this.screenshotDisplay));
        $this$vectorEditingOverlay_u24lambda_u243.setWidth((WidthConstraint)ConstraintsKt.boundTo((SuperConstraint)UtilitiesKt.percent(100), this.screenshotDisplay));
        screenshotCanvas.vectorEditingOverlay = (VectorEditingOverlay)ComponentsKt.childOf(uIComponent, this.getRetainedImage());
        CropAlignment[] $this$forEach$iv = CropAlignment.values();
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int j = 0; j < n; ++j) {
            CropAlignment element$iv;
            CropAlignment alignment = element$iv = $this$forEach$iv[j];
            boolean bl6 = false;
            ComponentsKt.childOf((UIComponent)new ImageCropItem(alignment), this);
        }
    }

    @NotNull
    public final State<PixelBufferTexture> getScreenshot() {
        return this.screenshot;
    }

    @NotNull
    public final Function4<UIContainer, Float, Float, Integer, Unit> getOnDraw() {
        return this.onDraw;
    }

    public final void setOnDraw(@NotNull Function4<? super UIContainer, ? super Float, ? super Float, ? super Integer, Unit> function4) {
        Intrinsics.checkNotNullParameter(function4, (String)"<set-?>");
        this.onDraw = function4;
    }

    public final int getMouseButton() {
        return this.mouseButton;
    }

    public final void setMouseButton(int n) {
        this.mouseButton = n;
    }

    @NotNull
    public final UIComponent getScreenshotDisplay() {
        return this.screenshotDisplay;
    }

    @NotNull
    public final UIBlock getBackground() {
        return this.background;
    }

    @NotNull
    public final Crop getCropSettings() {
        return this.cropSettings;
    }

    @NotNull
    public final UIContainer getRetainedImage() {
        return (UIContainer)this.retainedImage$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @NotNull
    public final VectorEditingOverlay getVectorEditingOverlay() {
        return this.vectorEditingOverlay;
    }

    @NotNull
    public final BasicState<Boolean> getUndoEnabled() {
        return this.vectorEditingOverlay.getUndoEnabled();
    }

    private static Object getUndoEnabled$delegate(ScreenshotCanvas screenshotCanvas) {
        return Reflection.property0((PropertyReference0)((PropertyReference0)new PropertyReference0Impl((Object)screenshotCanvas.vectorEditingOverlay, VectorEditingOverlay.class, "undoEnabled", "getUndoEnabled()Lgg/essential/elementa/state/BasicState;", 0)));
    }

    @NotNull
    public final BasicState<Boolean> getRedoEnabled() {
        return this.vectorEditingOverlay.getRedoEnabled();
    }

    private static Object getRedoEnabled$delegate(ScreenshotCanvas screenshotCanvas) {
        return Reflection.property0((PropertyReference0)((PropertyReference0)new PropertyReference0Impl((Object)screenshotCanvas.vectorEditingOverlay, VectorEditingOverlay.class, "redoEnabled", "getRedoEnabled()Lgg/essential/elementa/state/BasicState;", 0)));
    }

    @NotNull
    public final State<Boolean> getHasChanges() {
        return this.getUndoEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final CompletableFuture<File> exportImage(@NotNull ScreenshotId source, @NotNull ScreenshotManager screenshotManager, @NotNull ScreenshotBrowser screenshotBrowser, boolean temp, boolean favorite, boolean viewAfter) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)screenshotManager, (String)"screenshotManager");
        Intrinsics.checkNotNullParameter((Object)((Object)screenshotBrowser), (String)"screenshotBrowser");
        Crop cropSettings = this.cropSettings.clone();
        CompletableFuture<File> completableFuture = new CompletableFuture<File>();
        Closeable closeable = source.open();
        Throwable throwable = null;
        try {
            BufferedImage bufferedImage;
            Object it = (InputStream)closeable;
            boolean bl = false;
            try {
                BufferedImage bufferedImage2 = bufferedImage = ImageIO.read((InputStream)it);
                if (bufferedImage2 == null) {
                    throw new IOException("Failed to load original image from " + source);
                }
                Intrinsics.checkNotNull((Object)bufferedImage2);
            }
            catch (Exception e) {
                completableFuture.completeExceptionally(e);
                CompletableFuture<File> completableFuture2 = completableFuture;
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                return completableFuture2;
            }
            it = bufferedImage;
        }
        catch (Throwable it) {
            throwable = it;
            throw it;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Object screenshot = it;
        int fullWidth = ((BufferedImage)screenshot).getWidth();
        int fullHeight = ((BufferedImage)screenshot).getHeight();
        int drawableWidth = (int)this.screenshotDisplay.getWidth() * (int)UResolution.getScaleFactor();
        FloatBuffer buffer = BufferUtils.createFloatBuffer((int)(fullWidth * fullHeight * 4));
        VectorEditingOverlay vectorEditingOverlay = this.vectorEditingOverlay;
        VectorEditingOverlay veoCopy2 = new VectorEditingOverlay(this, buffer, vectorEditingOverlay){
            final /* synthetic */ FloatBuffer $buffer;
            {
                this.$buffer = $buffer;
                super($receiver, $super_call_param$1);
            }

            protected void render(@NotNull UMatrixStack matrixStack, float width2, float height2) {
                Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
                super.render(matrixStack, width2, height2);
                GL11.glReadPixels((int)0, (int)0, (int)((int)width2), (int)((int)height2), (int)6408, (int)5126, (FloatBuffer)this.$buffer);
            }

            public void renderImage(@NotNull UMatrixStack matrixStack, float width2, float height2) {
                Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
            }
        };
        veoCopy2.setScale((float)fullWidth / (float)drawableWidth);
        veoCopy2.drawFrameBuffer((double)fullWidth / UResolution.getScaleFactor(), (double)fullHeight / UResolution.getScaleFactor());
        veoCopy2.delete();
        Multithreading.runAsync(() -> ScreenshotCanvas.exportImage$lambda$7(buffer, fullWidth, fullHeight, (BufferedImage)screenshot, cropSettings, temp, completableFuture, screenshotManager, source, screenshotBrowser, favorite, viewAfter));
        return completableFuture;
    }

    public static /* synthetic */ CompletableFuture exportImage$default(ScreenshotCanvas screenshotCanvas, ScreenshotId screenshotId, ScreenshotManager screenshotManager, ScreenshotBrowser screenshotBrowser, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        return screenshotCanvas.exportImage(screenshotId, screenshotManager, screenshotBrowser, bl, bl2, bl3);
    }

    @NotNull
    public final Pair<Float, Float> getRelativeMousePosition(float mouseX, float mouseY) {
        float width2 = this.screenshotDisplay.getWidth();
        float height2 = this.screenshotDisplay.getHeight();
        return TuplesKt.to((Object)RangesKt.coerceIn((Comparable)Float.valueOf(mouseX / width2), (ClosedFloatingPointRange)RangesKt.rangeTo((float)0.0f, (float)1.0f)), (Object)RangesKt.coerceIn((Comparable)Float.valueOf(mouseY / height2), (ClosedFloatingPointRange)RangesKt.rangeTo((float)0.0f, (float)1.0f)));
    }

    public final void reset() {
        this.cropSettings.reset();
        this.vectorEditingOverlay.reset();
    }

    /*
     * WARNING - void declaration
     */
    private static final void exportImage$lambda$7(FloatBuffer $buffer, int $fullWidth, int $fullHeight, BufferedImage $screenshot, Crop $cropSettings, boolean $temp, CompletableFuture $completableFuture, ScreenshotManager $screenshotManager, ScreenshotId $source, ScreenshotBrowser $screenshotBrowser, boolean $favorite, boolean $viewAfter) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$screenshot, (String)"$screenshot");
        Intrinsics.checkNotNullParameter((Object)$cropSettings, (String)"$cropSettings");
        Intrinsics.checkNotNullParameter((Object)$completableFuture, (String)"$completableFuture");
        Intrinsics.checkNotNullParameter((Object)$screenshotManager, (String)"$screenshotManager");
        Intrinsics.checkNotNullParameter((Object)$source, (String)"$source");
        Intrinsics.checkNotNullParameter((Object)((Object)$screenshotBrowser), (String)"$screenshotBrowser");
        $buffer.rewind();
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)$buffer.limit());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void i2;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((int)($buffer.get((int)i2) * 255.0f));
        }
        int[] imgData2 = CollectionsKt.toIntArray((Collection)CollectionsKt.flatten((Iterable)CollectionsKt.reversed((Iterable)CollectionsKt.chunked((Iterable)((List)destination$iv$iv), (int)($fullWidth * 4), (Function1)exportImage.1.imgData.2.INSTANCE))));
        BufferedImage image2 = new BufferedImage($fullWidth, $fullHeight, 2);
        image2.setRGB(0, 0, $fullWidth, $fullHeight, imgData2, 0, $fullWidth);
        $screenshot.getGraphics().drawImage(image2, 0, 0, null);
        int left2 = (int)((float)$fullWidth * ((Number)$cropSettings.getLeft().get()).floatValue());
        int right = (int)((float)$fullWidth * ((Number)$cropSettings.getRight().get()).floatValue());
        int top = (int)((float)$fullHeight * ((Number)$cropSettings.getTop().get()).floatValue());
        int bottom = (int)((float)$fullHeight * ((Number)$cropSettings.getBottom().get()).floatValue());
        BufferedImage croppedImage = $screenshot.getSubimage(left2, top, right - left2, bottom - top);
        if ($temp) {
            File tempFile = File.createTempFile("screenshot", null);
            ImageIO.write((RenderedImage)croppedImage, "png", tempFile);
            $completableFuture.complete(tempFile);
        } else {
            ClientScreenshotMetadata clientScreenshotMetadata;
            ScreenshotId screenshotId = $source;
            if (screenshotId instanceof LocalScreenshot) {
                clientScreenshotMetadata = $screenshotManager.getScreenshotMetadataManager().getOrCreateMetadata(((LocalScreenshot)$source).getPath());
            } else if (screenshotId instanceof RemoteScreenshot) {
                clientScreenshotMetadata = new ClientScreenshotMetadata(((RemoteScreenshot)$source).getMedia());
            } else {
                throw new NoWhenBranchMatchedException();
            }
            $completableFuture.complete($screenshotManager.handleScreenshotEdited($source, clientScreenshotMetadata, croppedImage, $screenshotBrowser, $favorite, $viewAfter));
        }
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(ScreenshotCanvas.class, "retainedImage", "getRetainedImage()Lgg/essential/elementa/components/UIContainer;", 0)))};
        $$delegatedProperties = kPropertyArray;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\r\b\u0086\b\u0018\u00002\u00020\u0001BG\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\n\u001a\u00020\u0000\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\f\u0010\rJ\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000e\u0010\rJ\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000f\u0010\rJ\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0010\u0010\rJP\u0010\u0011\u001a\u00020\u00002\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001a\u0010\u0018\u001a\u00020\u00172\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u0096\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0010\u0010\u001b\u001a\u00020\u001aH\u00d6\u0001\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\r\u0010\u001d\u001a\u00020\u0014\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u000f\u0010 \u001a\u00020\u001fH\u0016\u00a2\u0006\u0004\b \u0010!R(\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0007\u0010\"\u001a\u0004\b#\u0010\r\"\u0004\b$\u0010%R(\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0004\u0010\"\u001a\u0004\b&\u0010\r\"\u0004\b'\u0010%R(\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010\"\u001a\u0004\b(\u0010\r\"\u0004\b)\u0010%R(\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0006\u0010\"\u001a\u0004\b*\u0010\r\"\u0004\b+\u0010%\u00a8\u0006,"}, d2={"Lgg/essential/gui/screenshot/editor/ScreenshotCanvas$Crop;", "", "Lgg/essential/elementa/state/State;", "", "left", "right", "top", "bottom", "<init>", "(Lgg/essential/elementa/state/State;Lgg/essential/elementa/state/State;Lgg/essential/elementa/state/State;Lgg/essential/elementa/state/State;)V", "clone", "()Lgg/essential/gui/screenshot/editor/ScreenshotCanvas$Crop;", "component1", "()Lgg/essential/elementa/state/State;", "component2", "component3", "component4", "copy", "(Lgg/essential/elementa/state/State;Lgg/essential/elementa/state/State;Lgg/essential/elementa/state/State;Lgg/essential/elementa/state/State;)Lgg/essential/gui/screenshot/editor/ScreenshotCanvas$Crop;", "other", "", "copyFrom", "(Lgg/essential/gui/screenshot/editor/ScreenshotCanvas$Crop;)V", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "reset", "()V", "", "toString", "()Ljava/lang/String;", "Lgg/essential/elementa/state/State;", "getBottom", "setBottom", "(Lgg/essential/elementa/state/State;)V", "getLeft", "setLeft", "getRight", "setRight", "getTop", "setTop", "Essential 1.18.2-forge"})
    public static final class Crop {
        @NotNull
        private State<Float> left;
        @NotNull
        private State<Float> right;
        @NotNull
        private State<Float> top;
        @NotNull
        private State<Float> bottom;

        public Crop(@NotNull State<Float> left2, @NotNull State<Float> right, @NotNull State<Float> top, @NotNull State<Float> bottom) {
            Intrinsics.checkNotNullParameter(left2, (String)"left");
            Intrinsics.checkNotNullParameter(right, (String)"right");
            Intrinsics.checkNotNullParameter(top, (String)"top");
            Intrinsics.checkNotNullParameter(bottom, (String)"bottom");
            this.left = left2;
            this.right = right;
            this.top = top;
            this.bottom = bottom;
        }

        public /* synthetic */ Crop(State state2, State state3, State state4, State state5, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                state2 = new BasicState<Float>(Float.valueOf(0.0f));
            }
            if ((n & 2) != 0) {
                state3 = new BasicState<Float>(Float.valueOf(1.0f));
            }
            if ((n & 4) != 0) {
                state4 = new BasicState<Float>(Float.valueOf(0.0f));
            }
            if ((n & 8) != 0) {
                state5 = new BasicState<Float>(Float.valueOf(1.0f));
            }
            this(state2, state3, state4, state5);
        }

        @NotNull
        public final State<Float> getLeft() {
            return this.left;
        }

        public final void setLeft(@NotNull State<Float> state2) {
            Intrinsics.checkNotNullParameter(state2, (String)"<set-?>");
            this.left = state2;
        }

        @NotNull
        public final State<Float> getRight() {
            return this.right;
        }

        public final void setRight(@NotNull State<Float> state2) {
            Intrinsics.checkNotNullParameter(state2, (String)"<set-?>");
            this.right = state2;
        }

        @NotNull
        public final State<Float> getTop() {
            return this.top;
        }

        public final void setTop(@NotNull State<Float> state2) {
            Intrinsics.checkNotNullParameter(state2, (String)"<set-?>");
            this.top = state2;
        }

        @NotNull
        public final State<Float> getBottom() {
            return this.bottom;
        }

        public final void setBottom(@NotNull State<Float> state2) {
            Intrinsics.checkNotNullParameter(state2, (String)"<set-?>");
            this.bottom = state2;
        }

        @NotNull
        public String toString() {
            return "Crop[left=" + this.left.get() + ",right=" + this.right.get() + ",top=" + this.top.get() + ",bottom=" + this.bottom.get() + "]";
        }

        public boolean equals(@Nullable Object other) {
            if (!(other instanceof Crop)) {
                return false;
            }
            return ((Number)((Crop)other).left.get()).floatValue() == ((Number)this.left.get()).floatValue() && ((Number)((Crop)other).right.get()).floatValue() == ((Number)this.right.get()).floatValue() && ((Number)((Crop)other).top.get()).floatValue() == ((Number)this.top.get()).floatValue() && ((Number)((Crop)other).bottom.get()).floatValue() == ((Number)this.bottom.get()).floatValue();
        }

        public final void reset() {
            this.left.set(Float.valueOf(0.0f));
            this.right.set(Float.valueOf(1.0f));
            this.top.set(Float.valueOf(0.0f));
            this.bottom.set(Float.valueOf(1.0f));
        }

        @NotNull
        public final Crop clone() {
            return new Crop((State<Float>)new BasicState<Float>(this.left.get()), (State<Float>)new BasicState<Float>(this.right.get()), (State<Float>)new BasicState<Float>(this.top.get()), (State<Float>)new BasicState<Float>(this.bottom.get()));
        }

        public final void copyFrom(@NotNull Crop other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            this.left.set(other.left.get());
            this.right.set(other.right.get());
            this.top.set(other.top.get());
            this.bottom.set(other.bottom.get());
        }

        @NotNull
        public final State<Float> component1() {
            return this.left;
        }

        @NotNull
        public final State<Float> component2() {
            return this.right;
        }

        @NotNull
        public final State<Float> component3() {
            return this.top;
        }

        @NotNull
        public final State<Float> component4() {
            return this.bottom;
        }

        @NotNull
        public final Crop copy(@NotNull State<Float> left2, @NotNull State<Float> right, @NotNull State<Float> top, @NotNull State<Float> bottom) {
            Intrinsics.checkNotNullParameter(left2, (String)"left");
            Intrinsics.checkNotNullParameter(right, (String)"right");
            Intrinsics.checkNotNullParameter(top, (String)"top");
            Intrinsics.checkNotNullParameter(bottom, (String)"bottom");
            return new Crop(left2, right, top, bottom);
        }

        public static /* synthetic */ Crop copy$default(Crop crop, State state2, State state3, State state4, State state5, int n, Object object) {
            if ((n & 1) != 0) {
                state2 = crop.left;
            }
            if ((n & 2) != 0) {
                state3 = crop.right;
            }
            if ((n & 4) != 0) {
                state4 = crop.top;
            }
            if ((n & 8) != 0) {
                state5 = crop.bottom;
            }
            return crop.copy(state2, state3, state4, state5);
        }

        public int hashCode() {
            int result = this.left.hashCode();
            result = result * 31 + this.right.hashCode();
            result = result * 31 + this.top.hashCode();
            result = result * 31 + this.bottom.hashCode();
            return result;
        }

        public Crop() {
            this(null, null, null, null, 15, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0010\u000b\n\u0002\b\u0017\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B5\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0002\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\u0004\b\b\u0010\tR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\n\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\n\u001a\u0004\b\r\u0010\fR\u0017\u0010\u0005\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\n\u001a\u0004\b\u000e\u0010\fR\u0017\u0010\u0006\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\n\u001a\u0004\b\u000f\u0010\fR\u0017\u0010\u0007\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\n\u001a\u0004\b\u0010\u0010\fj\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018\u00a8\u0006\u0019"}, d2={"Lgg/essential/gui/screenshot/editor/ScreenshotCanvas$CropAlignment;", "", "", "alignOpX", "alignOpY", "centerX", "centerY", "corner", "<init>", "(Ljava/lang/String;IZZZZZ)V", "Z", "getAlignOpX", "()Z", "getAlignOpY", "getCenterX", "getCenterY", "getCorner", "TOP_LEFT", "TOP_CENTER", "TOP_RIGHT", "RIGHT_CENTER", "BOTTOM_RIGHT", "BOTTOM_CENTER", "BOTTOM_LEFT", "LEFT_CENTER", "Essential 1.18.2-forge"})
    public static final class CropAlignment
    extends Enum<CropAlignment> {
        private final boolean alignOpX;
        private final boolean alignOpY;
        private final boolean centerX;
        private final boolean centerY;
        private final boolean corner;
        public static final /* enum */ CropAlignment TOP_LEFT = new CropAlignment("TOP_LEFT", 0, false, false, false, false, true, 12, null);
        public static final /* enum */ CropAlignment TOP_CENTER = new CropAlignment("TOP_CENTER", 1, false, false, true, false, false, 8, null);
        public static final /* enum */ CropAlignment TOP_RIGHT = new CropAlignment("TOP_RIGHT", 2, true, false, false, false, true, 12, null);
        public static final /* enum */ CropAlignment RIGHT_CENTER = new CropAlignment("RIGHT_CENTER", 3, true, false, false, true, false, 4, null);
        public static final /* enum */ CropAlignment BOTTOM_RIGHT = new CropAlignment("BOTTOM_RIGHT", 4, true, true, false, false, true, 12, null);
        public static final /* enum */ CropAlignment BOTTOM_CENTER = new CropAlignment("BOTTOM_CENTER", 5, false, true, true, false, false, 8, null);
        public static final /* enum */ CropAlignment BOTTOM_LEFT = new CropAlignment("BOTTOM_LEFT", 6, false, true, false, false, true, 12, null);
        public static final /* enum */ CropAlignment LEFT_CENTER = new CropAlignment("LEFT_CENTER", 7, false, false, false, true, false, 4, null);
        private static final /* synthetic */ CropAlignment[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private CropAlignment(boolean alignOpX, boolean alignOpY, boolean centerX, boolean centerY, boolean corner) {
            this.alignOpX = alignOpX;
            this.alignOpY = alignOpY;
            this.centerX = centerX;
            this.centerY = centerY;
            this.corner = corner;
        }

        /* synthetic */ CropAlignment(String string, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 4) != 0) {
                bl3 = false;
            }
            if ((n2 & 8) != 0) {
                bl4 = false;
            }
            this(bl, bl2, bl3, bl4, bl5);
        }

        public final boolean getAlignOpX() {
            return this.alignOpX;
        }

        public final boolean getAlignOpY() {
            return this.alignOpY;
        }

        public final boolean getCenterX() {
            return this.centerX;
        }

        public final boolean getCenterY() {
            return this.centerY;
        }

        public final boolean getCorner() {
            return this.corner;
        }

        public static CropAlignment[] values() {
            return (CropAlignment[])$VALUES.clone();
        }

        public static CropAlignment valueOf(String value2) {
            return Enum.valueOf(CropAlignment.class, value2);
        }

        @NotNull
        public static EnumEntries<CropAlignment> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = cropAlignmentArray = new CropAlignment[]{CropAlignment.TOP_LEFT, CropAlignment.TOP_CENTER, CropAlignment.TOP_RIGHT, CropAlignment.RIGHT_CENTER, CropAlignment.BOTTOM_RIGHT, CropAlignment.BOTTOM_CENTER, CropAlignment.BOTTOM_LEFT, CropAlignment.LEFT_CENTER};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\n\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0006\u001a\u0004\b\u0007\u0010\bR\"\u0010\n\u001a\u00020\t8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\"\u0010\u0011\u001a\u00020\u00108\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\"\u0010\u0017\u001a\u00020\u00108\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0017\u0010\u0012\u001a\u0004\b\u0018\u0010\u0014\"\u0004\b\u0019\u0010\u0016\u00a8\u0006\u001a"}, d2={"Lgg/essential/gui/screenshot/editor/ScreenshotCanvas$ImageCropItem;", "Lgg/essential/elementa/components/UIContainer;", "Lgg/essential/gui/screenshot/editor/ScreenshotCanvas$CropAlignment;", "alignment", "<init>", "(Lgg/essential/gui/screenshot/editor/ScreenshotCanvas;Lgg/essential/gui/screenshot/editor/ScreenshotCanvas$CropAlignment;)V", "Lgg/essential/gui/screenshot/editor/ScreenshotCanvas$CropAlignment;", "getAlignment", "()Lgg/essential/gui/screenshot/editor/ScreenshotCanvas$CropAlignment;", "", "dragging", "Z", "getDragging", "()Z", "setDragging", "(Z)V", "", "xDragOffset", "F", "getXDragOffset", "()F", "setXDragOffset", "(F)V", "yDragOffset", "getYDragOffset", "setYDragOffset", "Essential 1.18.2-forge"})
    @SourceDebugExtension(value={"SMAP\nScreenshotCanvas.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScreenshotCanvas.kt\ngg/essential/gui/screenshot/editor/ScreenshotCanvas$ImageCropItem\n+ 2 components.kt\ngg/essential/elementa/dsl/ComponentsKt\n*L\n1#1,542:1\n9#2,3:543\n13#2,2:546\n9#2,3:548\n15#2:551\n13#2,2:552\n9#2,3:554\n15#2:557\n13#2,2:558\n9#2,3:560\n15#2:563\n*S KotlinDebug\n*F\n+ 1 ScreenshotCanvas.kt\ngg/essential/gui/screenshot/editor/ScreenshotCanvas$ImageCropItem\n*L\n343#1:543,3\n359#1:546,2\n360#1:548,3\n359#1:551\n367#1:552,2\n368#1:554,3\n367#1:557\n376#1:558,2\n377#1:560,3\n376#1:563\n*E\n"})
    public final class ImageCropItem
    extends UIContainer {
        @NotNull
        private final CropAlignment alignment;
        private boolean dragging;
        private float xDragOffset;
        private float yDragOffset;

        /*
         * WARNING - void declaration
         */
        public ImageCropItem(CropAlignment alignment) {
            void $this$constrain$iv;
            void var6_10;
            Intrinsics.checkNotNullParameter((Object)((Object)alignment), (String)"alignment");
            this.alignment = alignment;
            UIComponent uIComponent = this;
            ScreenshotCanvas screenshotCanvas = ScreenshotCanvas.this;
            boolean $i$f$constrain = false;
            void $this$constrain_u24lambda_u240$iv = var6_10 = $this$constrain$iv;
            boolean bl4 = false;
            UIConstraints $this$_init__u24lambda_u240 = $this$constrain_u24lambda_u240$iv.getConstraints();
            boolean bl2 = false;
            $this$_init__u24lambda_u240.setHeight(UtilitiesKt.pixels$default(15, false, false, 3, null));
            $this$_init__u24lambda_u240.setWidth(UtilitiesKt.pixels$default(15, false, false, 3, null));
            $this$_init__u24lambda_u240.setX((XConstraint)ConstraintsKt.boundTo((SuperConstraint)(this.alignment.getCenterX() ? (PositionConstraint)new CenterConstraint() : (PositionConstraint)UtilitiesKt.pixels$default(-screenshotCanvas.padding, this.alignment.getAlignOpX(), false, 2, null)), screenshotCanvas.getRetainedImage()));
            $this$_init__u24lambda_u240.setY((YConstraint)ConstraintsKt.boundTo((SuperConstraint)(this.alignment.getCenterY() ? (PositionConstraint)new CenterConstraint() : (PositionConstraint)UtilitiesKt.pixels$default(-screenshotCanvas.padding, this.alignment.getAlignOpY(), false, 2, null)), screenshotCanvas.getRetainedImage()));
            if (this.alignment.getCorner()) {
                void $this$_init__u24lambda_u244;
                ImageCropItem $this$_init__u24lambda_u242;
                UIComponent uIComponent2;
                UIComponent uIComponent3;
                $this$addChild$iv = this;
                boolean $i$f$addChild = false;
                $this$addChild_u24lambda_u241$iv = uIComponent3 = $this$addChild$iv;
                boolean bl3 = false;
                ImageCropItem bl4 = (ImageCropItem)$this$addChild_u24lambda_u241$iv;
                UIComponent uIComponent4 = $this$addChild_u24lambda_u241$iv;
                boolean bl5 = false;
                UIComponent $this$constrain$iv2 = new UIBlock(EssentialPalette.TEXT);
                boolean $i$f$constrain2 = false;
                UIComponent $this$constrain_u24lambda_u240$iv2 = uIComponent2 = $this$constrain$iv2;
                boolean $i$a$-apply-ComponentsKt$constrain$1$iv2 = false;
                UIConstraints $this$lambda_u242_u24lambda_u241 = $this$constrain_u24lambda_u240$iv2.getConstraints();
                boolean bl6 = false;
                $this$lambda_u242_u24lambda_u241.setX(UtilitiesKt.pixels($this$_init__u24lambda_u242.alignment.getAlignOpX() ? 0 : 0, false, false));
                $this$lambda_u242_u24lambda_u241.setY(UtilitiesKt.pixels(0, $this$_init__u24lambda_u242.alignment.getAlignOpY(), false));
                $this$lambda_u242_u24lambda_u241.setWidth(UtilitiesKt.pixels$default(15, false, false, 3, null));
                $this$lambda_u242_u24lambda_u241.setHeight(UtilitiesKt.pixels$default(2, false, false, 3, null));
                uIComponent4.addChild(uIComponent2);
                $this$addChild$iv = this;
                $i$f$addChild = false;
                $this$addChild_u24lambda_u241$iv = uIComponent3 = $this$addChild$iv;
                bl3 = false;
                $this$_init__u24lambda_u242 = (ImageCropItem)$this$addChild_u24lambda_u241$iv;
                uIComponent4 = $this$addChild_u24lambda_u241$iv;
                boolean bl7 = false;
                $this$constrain$iv2 = new UIBlock(EssentialPalette.TEXT);
                $i$f$constrain2 = false;
                $this$constrain_u24lambda_u240$iv2 = uIComponent2 = $this$constrain$iv2;
                $i$a$-apply-ComponentsKt$constrain$1$iv2 = false;
                UIConstraints $this$lambda_u244_u24lambda_u243 = $this$constrain_u24lambda_u240$iv2.getConstraints();
                boolean bl8 = false;
                $this$lambda_u244_u24lambda_u243.setX(UtilitiesKt.pixels(0, $this$_init__u24lambda_u244.alignment.getAlignOpX(), false));
                $this$lambda_u244_u24lambda_u243.setY(UtilitiesKt.pixels($this$_init__u24lambda_u244.alignment.getAlignOpY() ? 0 : 0, false, false));
                $this$lambda_u244_u24lambda_u243.setWidth(UtilitiesKt.pixels$default(2, false, false, 3, null));
                $this$lambda_u244_u24lambda_u243.setHeight(UtilitiesKt.pixels$default(15, false, false, 3, null));
                uIComponent4.addChild(uIComponent2);
            } else {
                void $this$_init__u24lambda_u246;
                UIComponent uIComponent5;
                UIComponent uIComponent6;
                $this$addChild$iv = this;
                boolean $i$f$addChild = false;
                $this$addChild_u24lambda_u241$iv = uIComponent6 = $this$addChild$iv;
                boolean bl9 = false;
                ImageCropItem $this$_init__u24lambda_u244 = (ImageCropItem)$this$addChild_u24lambda_u241$iv;
                UIComponent uIComponent7 = $this$addChild_u24lambda_u241$iv;
                boolean bl10 = false;
                UIComponent $this$constrain$iv3 = new UIBlock(EssentialPalette.TEXT);
                boolean $i$f$constrain3 = false;
                UIComponent $this$constrain_u24lambda_u240$iv3 = uIComponent5 = $this$constrain$iv3;
                boolean $i$a$-apply-ComponentsKt$constrain$1$iv3 = false;
                UIConstraints $this$lambda_u246_u24lambda_u245 = $this$constrain_u24lambda_u240$iv3.getConstraints();
                boolean bl11 = false;
                $this$lambda_u246_u24lambda_u245.setX(UtilitiesKt.pixels(0, $this$_init__u24lambda_u246.alignment.getAlignOpX(), false));
                $this$lambda_u246_u24lambda_u245.setY(UtilitiesKt.pixels(0, $this$_init__u24lambda_u246.alignment.getAlignOpY(), false));
                $this$lambda_u246_u24lambda_u245.setHeight(UtilitiesKt.pixels$default($this$_init__u24lambda_u246.alignment.getCenterY() ? 15 : 2, false, false, 3, null));
                $this$lambda_u246_u24lambda_u245.setWidth(UtilitiesKt.pixels$default($this$_init__u24lambda_u246.alignment.getCenterX() ? 15 : 2, false, false, 3, null));
                uIComponent7.addChild(uIComponent5);
            }
            this.onMouseEnter((Function1<? super UIComponent, Unit>)((Function1)5.INSTANCE));
            this.onMouseLeave((Function1<? super UIComponent, Unit>)((Function1)6.INSTANCE));
            Ref.ObjectRef oldCrop = new Ref.ObjectRef();
            this.onMouseClick((Function2<? super UIComponent, ? super UIClickEvent, Unit>)((Function2)new Function2<UIComponent, UIClickEvent, Unit>((Ref.ObjectRef<Crop>)oldCrop){
                final /* synthetic */ Ref.ObjectRef<Crop> $oldCrop;
                {
                    this.$oldCrop = $oldCrop;
                    super(2);
                }

                public final void invoke(@NotNull UIComponent $this$onMouseClick, @NotNull UIClickEvent it) {
                    Intrinsics.checkNotNullParameter((Object)$this$onMouseClick, (String)"$this$onMouseClick");
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    this.setDragging(true);
                    this.setXDragOffset(it.getRelativeX() + (float)(this.getAlignment().getAlignOpX() ? ScreenshotCanvas.this.padding : -ScreenshotCanvas.this.padding));
                    this.setYDragOffset(it.getRelativeY() + (float)(this.getAlignment().getAlignOpY() ? ScreenshotCanvas.this.padding : -ScreenshotCanvas.this.padding));
                    this.$oldCrop.element = ScreenshotCanvas.this.getCropSettings().clone();
                }
            }));
            this.onMouseRelease((Function1<? super UIComponent, Unit>)((Function1)new Function1<UIComponent, Unit>((Ref.ObjectRef<Crop>)oldCrop, ScreenshotCanvas.this){
                final /* synthetic */ Ref.ObjectRef<Crop> $oldCrop;
                final /* synthetic */ ScreenshotCanvas this$1;
                {
                    this.$oldCrop = $oldCrop;
                    this.this$1 = $receiver2;
                    super(1);
                }

                public final void invoke(@NotNull UIComponent $this$onMouseRelease) {
                    Intrinsics.checkNotNullParameter((Object)$this$onMouseRelease, (String)"$this$onMouseRelease");
                    boolean wasDragging = this.getDragging();
                    this.setDragging(false);
                    if (Intrinsics.areEqual((Object)this.$oldCrop.element, (Object)this.this$1.getCropSettings()) || !wasDragging) {
                        return;
                    }
                    Crop crop = (Crop)this.$oldCrop.element;
                    if (crop == null) {
                        return;
                    }
                    this.this$1.getVectorEditingOverlay().pushChange(new CropChange(crop, this.this$1.getCropSettings().clone()));
                }
            }));
            this.onMouseDrag((Function4<? super UIComponent, ? super Float, ? super Float, ? super Integer, Unit>)((Function4)new Function4<UIComponent, Float, Float, Integer, Unit>(){

                public final void invoke(@NotNull UIComponent $this$onMouseDrag, float f, float f2, int n) {
                    Intrinsics.checkNotNullParameter((Object)$this$onMouseDrag, (String)"$this$onMouseDrag");
                    if (this.getDragging()) {
                        Pair pair = this.getMousePosition();
                        float mouseX = ((Number)pair.component1()).floatValue();
                        float mouseY = ((Number)pair.component2()).floatValue();
                        float relativeX = mouseX - ScreenshotCanvas.this.getScreenshotDisplay().getLeft();
                        float relativeY = mouseY - ScreenshotCanvas.this.getScreenshotDisplay().getTop();
                        float adjustedMouseX = this.getAlignment().getAlignOpX() ? relativeX + ($this$onMouseDrag.getWidth() - this.getXDragOffset()) : relativeX - this.getXDragOffset();
                        float adjustedMouseY = this.getAlignment().getAlignOpY() ? relativeY + ($this$onMouseDrag.getHeight() - this.getYDragOffset()) : relativeY - this.getYDragOffset();
                        Pair<Float, Float> pair2 = ScreenshotCanvas.this.getRelativeMousePosition(adjustedMouseX, adjustedMouseY);
                        float x = ((Number)pair2.component1()).floatValue();
                        float y = ((Number)pair2.component2()).floatValue();
                        float minSize = 0.1f;
                        switch (WhenMappings.$EnumSwitchMapping$0[this.getAlignment().ordinal()]) {
                            case 1: {
                                ScreenshotCanvas.this.getCropSettings().getTop().set(Float.valueOf(RangesKt.coerceAtMost((float)y, (float)(((Number)ScreenshotCanvas.this.getCropSettings().getBottom().get()).floatValue() - minSize))));
                                ScreenshotCanvas.this.getCropSettings().getLeft().set(Float.valueOf(RangesKt.coerceAtMost((float)x, (float)(((Number)ScreenshotCanvas.this.getCropSettings().getRight().get()).floatValue() - minSize))));
                                break;
                            }
                            case 2: {
                                ScreenshotCanvas.this.getCropSettings().getTop().set(Float.valueOf(RangesKt.coerceAtMost((float)y, (float)(((Number)ScreenshotCanvas.this.getCropSettings().getBottom().get()).floatValue() - minSize))));
                                break;
                            }
                            case 3: {
                                ScreenshotCanvas.this.getCropSettings().getTop().set(Float.valueOf(RangesKt.coerceAtMost((float)y, (float)(((Number)ScreenshotCanvas.this.getCropSettings().getBottom().get()).floatValue() - minSize))));
                                ScreenshotCanvas.this.getCropSettings().getRight().set(Float.valueOf(RangesKt.coerceAtLeast((float)x, (float)(((Number)ScreenshotCanvas.this.getCropSettings().getLeft().get()).floatValue() + minSize))));
                                break;
                            }
                            case 4: {
                                ScreenshotCanvas.this.getCropSettings().getRight().set(Float.valueOf(RangesKt.coerceAtLeast((float)x, (float)(((Number)ScreenshotCanvas.this.getCropSettings().getLeft().get()).floatValue() + minSize))));
                                break;
                            }
                            case 5: {
                                ScreenshotCanvas.this.getCropSettings().getBottom().set(Float.valueOf(RangesKt.coerceAtLeast((float)y, (float)(((Number)ScreenshotCanvas.this.getCropSettings().getTop().get()).floatValue() + minSize))));
                                ScreenshotCanvas.this.getCropSettings().getRight().set(Float.valueOf(RangesKt.coerceAtLeast((float)x, (float)(((Number)ScreenshotCanvas.this.getCropSettings().getLeft().get()).floatValue() + minSize))));
                                break;
                            }
                            case 6: {
                                ScreenshotCanvas.this.getCropSettings().getBottom().set(Float.valueOf(RangesKt.coerceAtLeast((float)y, (float)(((Number)ScreenshotCanvas.this.getCropSettings().getTop().get()).floatValue() + minSize))));
                                break;
                            }
                            case 7: {
                                ScreenshotCanvas.this.getCropSettings().getBottom().set(Float.valueOf(RangesKt.coerceAtLeast((float)y, (float)(((Number)ScreenshotCanvas.this.getCropSettings().getTop().get()).floatValue() + minSize))));
                                ScreenshotCanvas.this.getCropSettings().getLeft().set(Float.valueOf(RangesKt.coerceAtMost((float)x, (float)(((Number)ScreenshotCanvas.this.getCropSettings().getRight().get()).floatValue() - minSize))));
                                break;
                            }
                            case 8: {
                                ScreenshotCanvas.this.getCropSettings().getLeft().set(Float.valueOf(RangesKt.coerceAtMost((float)x, (float)(((Number)ScreenshotCanvas.this.getCropSettings().getRight().get()).floatValue() - minSize))));
                            }
                        }
                        $this$onMouseDrag.animationFrame();
                    }
                }

                @Metadata(mv={1, 9, 0}, k=3, xi=48)
                public final class WhenMappings {
                    public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                    static {
                        int[] nArray = new int[CropAlignment.values().length];
                        try {
                            nArray[CropAlignment.TOP_LEFT.ordinal()] = 1;
                        }
                        catch (NoSuchFieldError noSuchFieldError) {
                            // empty catch block
                        }
                        try {
                            nArray[CropAlignment.TOP_CENTER.ordinal()] = 2;
                        }
                        catch (NoSuchFieldError noSuchFieldError) {
                            // empty catch block
                        }
                        try {
                            nArray[CropAlignment.TOP_RIGHT.ordinal()] = 3;
                        }
                        catch (NoSuchFieldError noSuchFieldError) {
                            // empty catch block
                        }
                        try {
                            nArray[CropAlignment.RIGHT_CENTER.ordinal()] = 4;
                        }
                        catch (NoSuchFieldError noSuchFieldError) {
                            // empty catch block
                        }
                        try {
                            nArray[CropAlignment.BOTTOM_RIGHT.ordinal()] = 5;
                        }
                        catch (NoSuchFieldError noSuchFieldError) {
                            // empty catch block
                        }
                        try {
                            nArray[CropAlignment.BOTTOM_CENTER.ordinal()] = 6;
                        }
                        catch (NoSuchFieldError noSuchFieldError) {
                            // empty catch block
                        }
                        try {
                            nArray[CropAlignment.BOTTOM_LEFT.ordinal()] = 7;
                        }
                        catch (NoSuchFieldError noSuchFieldError) {
                            // empty catch block
                        }
                        try {
                            nArray[CropAlignment.LEFT_CENTER.ordinal()] = 8;
                        }
                        catch (NoSuchFieldError noSuchFieldError) {
                            // empty catch block
                        }
                        $EnumSwitchMapping$0 = nArray;
                    }
                }
            }));
        }

        @NotNull
        public final CropAlignment getAlignment() {
            return this.alignment;
        }

        public final boolean getDragging() {
            return this.dragging;
        }

        public final void setDragging(boolean bl) {
            this.dragging = bl;
        }

        public final float getXDragOffset() {
            return this.xDragOffset;
        }

        public final void setXDragOffset(float f) {
            this.xDragOffset = f;
        }

        public final float getYDragOffset() {
            return this.yDragOffset;
        }

        public final void setYDragOffset(float f) {
            this.yDragOffset = f;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0096\u0004\u0018\u00002\u00020\u0001B\u0015\b\u0016\u0012\n\u0010\u0003\u001a\u00060\u0000R\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0017\u0012\u000e\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006\u00a2\u0006\u0004\b\u0004\u0010\tJ\u0019\u0010\f\u001a\u00060\u0000R\u00020\u00022\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u0011\u0010\u000e\u001a\u00060\u0000R\u00020\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ'\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0012H\u0014\u00a2\u0006\u0004\b\u0016\u0010\u0017J'\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0017J/\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0012H\u0014\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\r\u0010\u001d\u001a\u00020\u0015\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0011\u0010\u001f\u001a\u00060\u0000R\u00020\u0002\u00a2\u0006\u0004\b\u001f\u0010\u000fR\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00020\n0 8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010\"R\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020\n0 8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010\"R\u001f\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00068\u0006\u00a2\u0006\f\n\u0004\b\b\u0010$\u001a\u0004\b%\u0010&R\u001d\u0010)\u001a\b\u0012\u0004\u0012\u00020(0'8\u0006\u00a2\u0006\f\n\u0004\b)\u0010*\u001a\u0004\b+\u0010,R\"\u0010-\u001a\u00020\u00128\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b-\u0010.\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u0014\u00104\u001a\u0002038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b4\u00105R\u001d\u00106\u001a\b\u0012\u0004\u0012\u00020(0'8\u0006\u00a2\u0006\f\n\u0004\b6\u0010*\u001a\u0004\b7\u0010,R\u001c\u00109\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u0007088\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b9\u0010:\u00a8\u0006;"}, d2={"Lgg/essential/gui/screenshot/editor/ScreenshotCanvas$VectorEditingOverlay;", "Lgg/essential/gui/common/UINanoVG;", "Lgg/essential/gui/screenshot/editor/ScreenshotCanvas;", "veo", "<init>", "(Lgg/essential/gui/screenshot/editor/ScreenshotCanvas;Lgg/essential/gui/screenshot/editor/ScreenshotCanvas$VectorEditingOverlay;)V", "Lgg/essential/elementa/state/State;", "Lgg/essential/gui/screenshot/image/PixelBufferTexture;", "image", "(Lgg/essential/gui/screenshot/editor/ScreenshotCanvas;Lgg/essential/elementa/state/State;)V", "Lgg/essential/gui/screenshot/editor/change/Change;", "change", "pushChange", "(Lgg/essential/gui/screenshot/editor/change/Change;)Lgg/essential/gui/screenshot/editor/ScreenshotCanvas$VectorEditingOverlay;", "redo", "()Lgg/essential/gui/screenshot/editor/ScreenshotCanvas$VectorEditingOverlay;", "Lgg/essential/universal/UMatrixStack;", "matrixStack", "", "width", "height", "", "render", "(Lgg/essential/universal/UMatrixStack;FF)V", "renderImage", "Lgg/essential/util/lwjgl3/api/nanovg/NanoVG;", "vg", "renderVG", "(Lgg/essential/universal/UMatrixStack;Lgg/essential/util/lwjgl3/api/nanovg/NanoVG;FF)V", "reset", "()V", "undo", "Ljava/util/Stack;", "future", "Ljava/util/Stack;", "history", "Lgg/essential/elementa/state/State;", "getImage", "()Lgg/essential/elementa/state/State;", "Lgg/essential/elementa/state/BasicState;", "", "redoEnabled", "Lgg/essential/elementa/state/BasicState;", "getRedoEnabled", "()Lgg/essential/elementa/state/BasicState;", "scale", "F", "getScale", "()F", "setScale", "(F)V", "Lgg/essential/gui/screenshot/image/ScreenshotImage;", "screenshotImage", "Lgg/essential/gui/screenshot/image/ScreenshotImage;", "undoEnabled", "getUndoEnabled", "Lgg/essential/gui/common/WeakState;", "weakImage", "Lgg/essential/gui/common/WeakState;", "Essential 1.18.2-forge"})
    @SourceDebugExtension(value={"SMAP\nScreenshotCanvas.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScreenshotCanvas.kt\ngg/essential/gui/screenshot/editor/ScreenshotCanvas$VectorEditingOverlay\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,542:1\n800#2,11:543\n1855#2,2:554\n1#3:556\n*S KotlinDebug\n*F\n+ 1 ScreenshotCanvas.kt\ngg/essential/gui/screenshot/editor/ScreenshotCanvas$VectorEditingOverlay\n*L\n170#1:543,11\n170#1:554,2\n*E\n"})
    public class VectorEditingOverlay
    extends UINanoVG {
        @NotNull
        private final State<PixelBufferTexture> image;
        @NotNull
        private final Stack<Change> history;
        @NotNull
        private final Stack<Change> future;
        @NotNull
        private final ScreenshotImage screenshotImage;
        private float scale;
        @NotNull
        private final BasicState<Boolean> undoEnabled;
        @NotNull
        private final BasicState<Boolean> redoEnabled;
        @NotNull
        private final WeakState<PixelBufferTexture> weakImage;
        final /* synthetic */ ScreenshotCanvas this$0;

        public VectorEditingOverlay(@NotNull ScreenshotCanvas this$0, State<PixelBufferTexture> image2) {
            Intrinsics.checkNotNullParameter(image2, (String)"image");
            this.this$0 = this$0;
            this.image = image2;
            this.history = new Stack();
            this.future = new Stack();
            this.screenshotImage = new ScreenshotImage(this.image);
            this.scale = 1.0f;
            this.undoEnabled = new BasicState<Boolean>(false);
            this.redoEnabled = new BasicState<Boolean>(false);
            this.weakImage = ExtensionsKt.weak(this.image);
            this.weakImage.onSetValue((Function1<PixelBufferTexture, Unit>)((Function1)new Function1<PixelBufferTexture, Unit>(){

                public final void invoke(@Nullable PixelBufferTexture it) {
                    this.markDirty();
                }
            }));
        }

        @NotNull
        public final State<PixelBufferTexture> getImage() {
            return this.image;
        }

        public final float getScale() {
            return this.scale;
        }

        public final void setScale(float f) {
            this.scale = f;
        }

        @NotNull
        public final BasicState<Boolean> getUndoEnabled() {
            return this.undoEnabled;
        }

        @NotNull
        public final BasicState<Boolean> getRedoEnabled() {
            return this.redoEnabled;
        }

        public final void reset() {
            this.undoEnabled.set(false);
            this.redoEnabled.set(false);
            this.history.clear();
            this.future.clear();
            this.markDirty();
        }

        public VectorEditingOverlay(@NotNull ScreenshotCanvas this$0, VectorEditingOverlay veo) {
            Intrinsics.checkNotNullParameter((Object)veo, (String)"veo");
            this(this$0, veo.image);
            this.history.addAll((Collection<Change>)veo.history);
            this.future.addAll((Collection<Change>)veo.future);
            this.undoEnabled.set(veo.undoEnabled.get());
            this.redoEnabled.set(veo.redoEnabled.get());
        }

        @Override
        protected void render(@NotNull UMatrixStack matrixStack, float width2, float height2) {
            Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
            this.renderImage(matrixStack, width2, height2);
            super.render(matrixStack, width2, height2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void renderVG(@NotNull UMatrixStack matrixStack, @NotNull NanoVG vg, float width2, float height2) {
            void $this$forEach$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
            Intrinsics.checkNotNullParameter((Object)vg, (String)"vg");
            Iterable $this$filterIsInstance$iv = this.history;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof VectorStroke)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                VectorStroke vs = (VectorStroke)element$iv;
                boolean bl = false;
                vs.render(vg, width2, height2, this.scale);
            }
        }

        public void renderImage(@NotNull UMatrixStack matrixStack, float width2, float height2) {
            Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
            Color color2 = Color.WHITE;
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"WHITE");
            this.screenshotImage.renderImage(matrixStack, color2, width2, height2);
        }

        @NotNull
        public final VectorEditingOverlay pushChange(@NotNull Change change) {
            VectorEditingOverlay vectorEditingOverlay;
            Intrinsics.checkNotNullParameter((Object)change, (String)"change");
            VectorEditingOverlay $this$pushChange_u24lambda_u241 = vectorEditingOverlay = this;
            boolean bl = false;
            $this$pushChange_u24lambda_u241.future.clear();
            $this$pushChange_u24lambda_u241.history.push(change);
            $this$pushChange_u24lambda_u241.markDirty();
            $this$pushChange_u24lambda_u241.undoEnabled.set(true);
            $this$pushChange_u24lambda_u241.redoEnabled.set(false);
            return vectorEditingOverlay;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final VectorEditingOverlay undo() {
            VectorEditingOverlay vectorEditingOverlay = this;
            ScreenshotCanvas screenshotCanvas = this.this$0;
            VectorEditingOverlay $this$undo_u24lambda_u243 = vectorEditingOverlay;
            boolean bl = false;
            if (!$this$undo_u24lambda_u243.history.empty()) {
                void it;
                Change change;
                $this$undo_u24lambda_u243.redoEnabled.set(true);
                Change change2 = change = $this$undo_u24lambda_u243.history.pop();
                Stack<Change> stack = $this$undo_u24lambda_u243.future;
                boolean bl2 = false;
                it.undo(screenshotCanvas);
                stack.push(change);
                $this$undo_u24lambda_u243.undoEnabled.set(!$this$undo_u24lambda_u243.history.isEmpty());
            }
            return vectorEditingOverlay;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final VectorEditingOverlay redo() {
            VectorEditingOverlay vectorEditingOverlay = this;
            ScreenshotCanvas screenshotCanvas = this.this$0;
            VectorEditingOverlay $this$redo_u24lambda_u245 = vectorEditingOverlay;
            boolean bl = false;
            if (!$this$redo_u24lambda_u245.future.empty()) {
                void it;
                Change change;
                Change change2 = change = $this$redo_u24lambda_u245.future.pop();
                Stack<Change> stack = $this$redo_u24lambda_u245.history;
                boolean bl2 = false;
                it.redo(screenshotCanvas);
                stack.push(change);
                $this$redo_u24lambda_u245.undoEnabled.set(true);
                $this$redo_u24lambda_u245.redoEnabled.set(!$this$redo_u24lambda_u245.future.isEmpty());
            }
            return vectorEditingOverlay;
        }
    }
}

