/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.gui.screenshot.downsampling;

import gg.essential.gui.screenshot.downsampling.PixelBuffer;
import gg.essential.util.lwjgl3.api.ImageData;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.DefaultByteBufHolder;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u00002\u00020\u00012\u00020\u0002B\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u001f\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u0005\u0010\fJ\u000f\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0012\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0011J\u000f\u0010\u0013\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0011J\u000f\u0010\u0014\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0014\u0010\u000fJ\u001d\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aR$\u0010\u0004\u001a\u0004\u0018\u00010\u00038\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0004\u0010\u001b\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u0006R\u0014\u0010\t\u001a\u00020\u00078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u001fR\u0014\u0010\b\u001a\u00020\u00078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\u001fR\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010 \u00a8\u0006!"}, d2={"Lgg/essential/gui/screenshot/downsampling/BufferBackedImage;", "Lio/netty/buffer/DefaultByteBufHolder;", "Lgg/essential/gui/screenshot/downsampling/PixelBuffer;", "Lgg/essential/util/lwjgl3/api/ImageData;", "data", "<init>", "(Lgg/essential/util/lwjgl3/api/ImageData;)V", "", "imageWidth", "imageHeight", "Lio/netty/buffer/ByteBuf;", "nativeBuffer", "(IILio/netty/buffer/ByteBuf;)V", "Ljava/nio/ByteBuffer;", "getBuffer", "()Ljava/nio/ByteBuffer;", "getChannels", "()I", "getHeight", "getWidth", "prepareDirectBuffer", "index", "", "value", "", "set", "(IB)V", "Lgg/essential/util/lwjgl3/api/ImageData;", "getData", "()Lgg/essential/util/lwjgl3/api/ImageData;", "setData", "I", "Lio/netty/buffer/ByteBuf;", "Essential 1.18.2-forge"})
public final class BufferBackedImage
extends DefaultByteBufHolder
implements PixelBuffer {
    private final int imageWidth;
    private final int imageHeight;
    @NotNull
    private final ByteBuf nativeBuffer;
    @Nullable
    private ImageData data;

    public BufferBackedImage(int imageWidth, int imageHeight, @NotNull ByteBuf nativeBuffer) {
        Intrinsics.checkNotNullParameter((Object)nativeBuffer, (String)"nativeBuffer");
        super(nativeBuffer);
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
        this.nativeBuffer = nativeBuffer;
    }

    @Nullable
    public final ImageData getData() {
        return this.data;
    }

    public final void setData(@Nullable ImageData imageData) {
        this.data = imageData;
    }

    public BufferBackedImage(@NotNull ImageData data) {
        Intrinsics.checkNotNullParameter((Object)((Object)data), (String)"data");
        this(data.getWidth(), data.getHeight(), data.getData());
        this.data = data;
    }

    public final void set(int index2, byte value2) {
        this.nativeBuffer.setByte(index2, (int)value2);
    }

    @Override
    public int getWidth() {
        return this.imageWidth;
    }

    @Override
    public int getHeight() {
        return this.imageHeight;
    }

    @Override
    public int getChannels() {
        return this.nativeBuffer.capacity() / (this.imageWidth * this.imageHeight);
    }

    @Override
    @NotNull
    public ByteBuffer getBuffer() {
        ByteBuffer byteBuffer = this.nativeBuffer.nioBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"nioBuffer(...)");
        return byteBuffer;
    }

    @Override
    @NotNull
    public ByteBuffer prepareDirectBuffer() {
        boolean bl = this.nativeBuffer.isDirect();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        ByteBuffer byteBuffer = this.nativeBuffer.nioBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"nioBuffer(...)");
        return byteBuffer;
    }
}

