/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.gui.screenshot.concurrent;

import gg.essential.gui.screenshot.concurrent.PrioritizedCallable;
import gg.essential.gui.screenshot.concurrent.PrioritizedTask;
import gg.essential.gui.screenshot.concurrent.ScreenshotWorkerThreadFactory;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.PriorityQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0002\u0012\u0013B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J)\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\t\"\u0004\b\u0000\u0010\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007H\u0014\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\r\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\r\u0010\u000eR\u0014\u0010\u0010\u001a\u00020\u000f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0014"}, d2={"Lgg/essential/gui/screenshot/concurrent/PriorityThreadPoolExecutor;", "Ljava/util/concurrent/ThreadPoolExecutor;", "", "numThreads", "<init>", "(I)V", "T", "Ljava/util/concurrent/Callable;", "callable", "Ljava/util/concurrent/RunnableFuture;", "newTaskFor", "(Ljava/util/concurrent/Callable;)Ljava/util/concurrent/RunnableFuture;", "Ljava/lang/Runnable;", "stealBackgroundTask", "()Ljava/lang/Runnable;", "Lgg/essential/gui/screenshot/concurrent/PriorityThreadPoolExecutor$MultiBlockingQueue;", "queue", "Lgg/essential/gui/screenshot/concurrent/PriorityThreadPoolExecutor$MultiBlockingQueue;", "AbstractUnboundedBlockingQueue", "MultiBlockingQueue", "Essential 1.18.2-forge"})
public final class PriorityThreadPoolExecutor
extends ThreadPoolExecutor {
    @NotNull
    private final MultiBlockingQueue queue;

    public PriorityThreadPoolExecutor(int numThreads) {
        super(numThreads, numThreads, 0L, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)new MultiBlockingQueue(), ScreenshotWorkerThreadFactory.INSTANCE);
        BlockingQueue<Runnable> blockingQueue = this.getQueue();
        Intrinsics.checkNotNull(blockingQueue, (String)"null cannot be cast to non-null type gg.essential.gui.screenshot.concurrent.PriorityThreadPoolExecutor.MultiBlockingQueue");
        this.queue = (MultiBlockingQueue)blockingQueue;
    }

    @Override
    @NotNull
    protected <T> RunnableFuture<T> newTaskFor(@NotNull Callable<T> callable2) {
        Intrinsics.checkNotNullParameter(callable2, (String)"callable");
        return callable2 instanceof PrioritizedCallable ? (RunnableFuture)new PrioritizedTask((PrioritizedCallable)callable2) : (RunnableFuture)new FutureTask<T>(callable2);
    }

    @Nullable
    public final Runnable stealBackgroundTask() {
        return this.queue.pollBackgroundTask();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010)\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\"\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u00028\u00000\u00022\b\u0012\u0004\u0012\u00028\u00000\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00028\u0000H$\u00a2\u0006\u0004\b\b\u0010\tJ\u001f\u0010\r\u001a\u00020\f2\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00000\nH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ'\u0010\r\u001a\u00020\f2\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00000\n2\u0006\u0010\u000f\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\r\u0010\u0010J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u0011H\u0096\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\u0014\u0010\tJ'\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0019J!\u0010\u001a\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0006\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u000f\u0010\u001f\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u001f\u0010 J\u000f\u0010!\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b!\u0010\"R\u001a\u0010$\u001a\u00020#8\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b$\u0010%\u001a\u0004\b&\u0010'R\u001c\u0010*\u001a\n )*\u0004\u0018\u00010(0(8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b*\u0010+\u00a8\u0006,"}, d2={"Lgg/essential/gui/screenshot/concurrent/PriorityThreadPoolExecutor$AbstractUnboundedBlockingQueue;", "T", "Ljava/util/AbstractQueue;", "Ljava/util/concurrent/BlockingQueue;", "<init>", "()V", "e", "", "doOffer", "(Ljava/lang/Object;)Z", "", "c", "", "drainTo", "(Ljava/util/Collection;)I", "max", "(Ljava/util/Collection;I)I", "", "iterator", "()Ljava/util/Iterator;", "offer", "", "timeout", "Ljava/util/concurrent/TimeUnit;", "unit", "(Ljava/lang/Object;JLjava/util/concurrent/TimeUnit;)Z", "poll", "(JLjava/util/concurrent/TimeUnit;)Ljava/lang/Object;", "", "put", "(Ljava/lang/Object;)V", "remainingCapacity", "()I", "take", "()Ljava/lang/Object;", "Ljava/util/concurrent/locks/ReentrantLock;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "getLock", "()Ljava/util/concurrent/locks/ReentrantLock;", "Ljava/util/concurrent/locks/Condition;", "kotlin.jvm.PlatformType", "notEmpty", "Ljava/util/concurrent/locks/Condition;", "Essential 1.18.2-forge"})
    private static abstract class AbstractUnboundedBlockingQueue<T>
    extends AbstractQueue<T>
    implements BlockingQueue<T> {
        @NotNull
        private final ReentrantLock lock = new ReentrantLock();
        private final Condition notEmpty = this.lock.newCondition();

        @NotNull
        protected final ReentrantLock getLock() {
            return this.lock;
        }

        @Override
        @NotNull
        public Iterator<T> iterator() {
            throw new UnsupportedOperationException();
        }

        protected abstract boolean doOffer(T var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean offer(T e) {
            boolean bl;
            Lock lock = this.lock;
            lock.lock();
            try {
                boolean bl2;
                boolean bl3 = false;
                boolean it = bl2 = this.doOffer(e);
                boolean bl4 = false;
                this.notEmpty.signal();
                bl = bl2;
            }
            finally {
                lock.unlock();
            }
            return bl;
        }

        @Override
        public boolean offer(T e, long timeout2, @NotNull TimeUnit unit) {
            Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
            return this.offer(e);
        }

        @Override
        public void put(T e) {
            this.offer(e);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public T poll(long timeout2, @NotNull TimeUnit unit) {
            Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
            long nanos = 0L;
            nanos = unit.toNanos(timeout2);
            Lock lock = this.lock;
            lock.lock();
            try {
                boolean bl = false;
                while (nanos > 0L) {
                    Object result = this.poll();
                    if (result != null) {
                        Object e = result;
                        return (T)e;
                    }
                    nanos = this.notEmpty.awaitNanos(nanos);
                }
                T t = null;
                return t;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T take() {
            Lock lock = this.lock;
            lock.lock();
            try {
                boolean bl = false;
                while (true) {
                    Object result;
                    if ((result = this.poll()) != null) {
                        Object e = result;
                        return (T)e;
                    }
                    this.notEmpty.await();
                }
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        public int remainingCapacity() {
            return Integer.MAX_VALUE;
        }

        @Override
        public int drainTo(@NotNull Collection<? super T> c) {
            Intrinsics.checkNotNullParameter(c, (String)"c");
            return this.drainTo(c, Integer.MAX_VALUE);
        }

        @Override
        public int drainTo(@NotNull Collection<? super T> c, int max) {
            int drained;
            Intrinsics.checkNotNullParameter(c, (String)"c");
            for (drained = 0; drained < max; ++drained) {
                Object e = this.poll();
                if (e == null) break;
                c.add(e);
            }
            return drained;
        }

        public abstract int getSize();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0011\u0010\t\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0011\u0010\u000b\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0004\b\u000b\u0010\nJ\u000f\u0010\f\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\f\u0010\nR\"\u0010\u000f\u001a\u0010\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\u00020\u00020\r8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014R\"\u0010\u0015\u001a\u0010\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\u00020\u00020\r8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0010R\u0014\u0010\u0019\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001a"}, d2={"Lgg/essential/gui/screenshot/concurrent/PriorityThreadPoolExecutor$MultiBlockingQueue;", "Lgg/essential/gui/screenshot/concurrent/PriorityThreadPoolExecutor$AbstractUnboundedBlockingQueue;", "Ljava/lang/Runnable;", "<init>", "()V", "e", "", "doOffer", "(Ljava/lang/Runnable;)Z", "peek", "()Ljava/lang/Runnable;", "poll", "pollBackgroundTask", "Ljava/util/PriorityQueue;", "kotlin.jvm.PlatformType", "backgroundQueue", "Ljava/util/PriorityQueue;", "Lgg/essential/gui/screenshot/concurrent/PrioritizedTask;", "", "backgroundTaskDiscriminator", "Lgg/essential/gui/screenshot/concurrent/PrioritizedTask;", "regularQueue", "", "getSize", "()I", "size", "Essential 1.18.2-forge"})
    @SourceDebugExtension(value={"SMAP\nPriorityThreadPoolExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PriorityThreadPoolExecutor.kt\ngg/essential/gui/screenshot/concurrent/PriorityThreadPoolExecutor$MultiBlockingQueue\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,134:1\n1#2:135\n*E\n"})
    private static final class MultiBlockingQueue
    extends AbstractUnboundedBlockingQueue<Runnable> {
        @NotNull
        private final PriorityQueue<Runnable> regularQueue = new PriorityQueue<Runnable>(10, PrioritizedCallable.Companion.getComparator());
        @NotNull
        private final PriorityQueue<Runnable> backgroundQueue = new PriorityQueue<Runnable>(10, PrioritizedCallable.Companion.getComparator());
        @NotNull
        private final PrioritizedTask<Unit> backgroundTaskDiscriminator = new PrioritizedTask((PrioritizedCallable)new PrioritizedCallable<Unit>(){

            public void call() {
            }
        });

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getSize() {
            int n;
            Lock lock = this.getLock();
            lock.lock();
            try {
                boolean bl = false;
                n = this.regularQueue.size() + this.backgroundQueue.size();
            }
            finally {
                lock.unlock();
            }
            return n;
        }

        @Override
        protected boolean doOffer(@NotNull Runnable e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            PriorityQueue<Runnable> queue = PrioritizedCallable.Companion.getComparator().compare(e, this.backgroundTaskDiscriminator) >= 0 ? this.backgroundQueue : this.regularQueue;
            return queue.offer(e);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public Runnable poll() {
            Runnable runnable;
            Lock lock = this.getLock();
            lock.lock();
            try {
                boolean bl = false;
                Runnable runnable2 = this.regularQueue.poll();
                if (runnable2 == null) {
                    runnable2 = this.backgroundQueue.poll();
                }
                runnable = runnable2;
            }
            finally {
                lock.unlock();
            }
            return runnable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public Runnable peek() {
            Runnable runnable;
            Lock lock = this.getLock();
            lock.lock();
            try {
                boolean bl = false;
                Runnable runnable2 = this.regularQueue.peek();
                if (runnable2 == null) {
                    runnable2 = this.backgroundQueue.peek();
                }
                runnable = runnable2;
            }
            finally {
                lock.unlock();
            }
            return runnable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public final Runnable pollBackgroundTask() {
            Runnable runnable;
            Lock lock = this.getLock();
            lock.lock();
            try {
                boolean bl = false;
                runnable = this.backgroundQueue.poll();
            }
            finally {
                lock.unlock();
            }
            return runnable;
        }
    }
}

