/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.gui.screenshot.components;

import gg.essential.elementa.state.BasicState;
import gg.essential.elementa.state.State;
import gg.essential.gui.screenshot.LocalScreenshot;
import gg.essential.gui.screenshot.RemoteScreenshot;
import gg.essential.gui.screenshot.ScreenshotId;
import gg.essential.gui.screenshot.components.ScreenshotProperties;
import gg.essential.gui.screenshot.components.ScreenshotStateManager;
import gg.essential.handlers.screenshot.ClientScreenshotMetadata;
import gg.essential.network.connectionmanager.media.ScreenshotManager;
import gg.essential.util.Multithreading;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010%\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001b\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001b\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\b2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\r\u0010\u000bJ\u001b\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\b2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000f\u0010\u000bJ\u0015\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0011\u0010\u0012J!\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000e0\b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\b\u00a2\u0006\u0004\b\u0014\u0010\u0015J%\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\f0\bH\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018R&\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u00198\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR&\u0010\u001c\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\b0\u00198\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001bR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lgg/essential/gui/screenshot/components/ScreenshotStateManager;", "", "Lgg/essential/network/connectionmanager/media/ScreenshotManager;", "screenshotManager", "<init>", "(Lgg/essential/network/connectionmanager/media/ScreenshotManager;)V", "Lgg/essential/gui/screenshot/components/ScreenshotProperties;", "properties", "Lgg/essential/elementa/state/State;", "", "getAspectRatio", "(Lgg/essential/gui/screenshot/components/ScreenshotProperties;)Lgg/essential/elementa/state/State;", "", "getFavoriteState", "", "getFavoriteTextState", "", "handleDelete", "(Lgg/essential/gui/screenshot/components/ScreenshotProperties;)V", "favorite", "mapFavoriteText", "(Lgg/essential/elementa/state/State;)Lgg/essential/elementa/state/State;", "state", "registerFavoriteState", "(Lgg/essential/gui/screenshot/components/ScreenshotProperties;Lgg/essential/elementa/state/State;)V", "", "aspectMap", "Ljava/util/Map;", "favoriteMap", "Lgg/essential/network/connectionmanager/media/ScreenshotManager;", "Essential 1.18.2-forge"})
public final class ScreenshotStateManager {
    @NotNull
    private final ScreenshotManager screenshotManager;
    @NotNull
    private final Map<ScreenshotProperties, State<Boolean>> favoriteMap;
    @NotNull
    private final Map<ScreenshotProperties, State<Float>> aspectMap;

    public ScreenshotStateManager(@NotNull ScreenshotManager screenshotManager) {
        Intrinsics.checkNotNullParameter((Object)screenshotManager, (String)"screenshotManager");
        this.screenshotManager = screenshotManager;
        this.favoriteMap = new LinkedHashMap();
        this.aspectMap = new LinkedHashMap();
    }

    private final void registerFavoriteState(ScreenshotProperties properties2, State<Boolean> state2) {
        state2.onSetValue((Function1<Boolean, Unit>)((Function1)new Function1<Boolean, Unit>(properties2, this){
            final /* synthetic */ ScreenshotProperties $properties;
            final /* synthetic */ ScreenshotStateManager this$0;
            {
                this.$properties = $properties;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(boolean it) {
                Multithreading.runAsync(() -> registerFavoriteState.1.invoke$lambda$0(this.$properties, this.this$0, it));
            }

            private static final void invoke$lambda$0(ScreenshotProperties $properties, ScreenshotStateManager this$0, boolean $it) {
                ClientScreenshotMetadata clientScreenshotMetadata;
                Intrinsics.checkNotNullParameter((Object)$properties, (String)"$properties");
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                ScreenshotId id2 = $properties.getId();
                if (id2 instanceof LocalScreenshot) {
                    clientScreenshotMetadata = ScreenshotStateManager.access$getScreenshotManager$p(this$0).setFavorite(((LocalScreenshot)id2).getPath(), $it);
                } else if (id2 instanceof RemoteScreenshot) {
                    clientScreenshotMetadata = ScreenshotStateManager.access$getScreenshotManager$p(this$0).setFavorite(((RemoteScreenshot)id2).getMedia(), $it);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                $properties.setMetadata(clientScreenshotMetadata);
            }
        }));
    }

    @NotNull
    public final State<Float> getAspectRatio(@NotNull ScreenshotProperties properties2) {
        Intrinsics.checkNotNullParameter((Object)properties2, (String)"properties");
        State state2 = this.aspectMap.computeIfAbsent(properties2, arg_0 -> ScreenshotStateManager.getAspectRatio$lambda$0(getAspectRatio.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)state2, (String)"computeIfAbsent(...)");
        return state2;
    }

    @NotNull
    public final State<Boolean> getFavoriteState(@NotNull ScreenshotProperties properties2) {
        Intrinsics.checkNotNullParameter((Object)properties2, (String)"properties");
        State state2 = this.favoriteMap.computeIfAbsent(properties2, arg_0 -> ScreenshotStateManager.getFavoriteState$lambda$1((Function1)new Function1<ScreenshotProperties, State<Boolean>>(this){
            final /* synthetic */ ScreenshotStateManager this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final State<Boolean> invoke(@NotNull ScreenshotProperties it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ClientScreenshotMetadata clientScreenshotMetadata = it.getMetadata();
                BasicState<Boolean> basicState = new BasicState<Boolean>(clientScreenshotMetadata != null ? clientScreenshotMetadata.getFavorite() : false);
                ScreenshotStateManager screenshotStateManager = this.this$0;
                BasicState<Boolean> state2 = basicState;
                boolean bl = false;
                ScreenshotStateManager.access$registerFavoriteState(screenshotStateManager, it, state2);
                return basicState;
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)state2, (String)"computeIfAbsent(...)");
        return state2;
    }

    @NotNull
    public final State<String> getFavoriteTextState(@NotNull ScreenshotProperties properties2) {
        Intrinsics.checkNotNullParameter((Object)properties2, (String)"properties");
        return this.mapFavoriteText(this.getFavoriteState(properties2));
    }

    @NotNull
    public final State<String> mapFavoriteText(@NotNull State<Boolean> favorite) {
        Intrinsics.checkNotNullParameter(favorite, (String)"favorite");
        return favorite.map(mapFavoriteText.1.INSTANCE);
    }

    public final void handleDelete(@NotNull ScreenshotProperties properties2) {
        Intrinsics.checkNotNullParameter((Object)properties2, (String)"properties");
        this.aspectMap.remove(properties2);
        this.favoriteMap.remove(properties2);
    }

    private static final State getAspectRatio$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (State)$tmp0.invoke(p0);
    }

    private static final State getFavoriteState$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (State)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ ScreenshotManager access$getScreenshotManager$p(ScreenshotStateManager $this) {
        return $this.screenshotManager;
    }

    public static final /* synthetic */ void access$registerFavoriteState(ScreenshotStateManager $this, ScreenshotProperties properties2, State state2) {
        $this.registerFavoriteState(properties2, state2);
    }
}

