/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.gui.screenshot.components;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import gg.essential.elementa.UIComponent;
import gg.essential.elementa.effects.Effect;
import gg.essential.gui.EssentialPalette;
import gg.essential.universal.UGraphics;
import gg.essential.universal.UMatrixStack;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001f\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ7\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lgg/essential/gui/screenshot/components/CheckerboardBackgroundEffect;", "Lgg/essential/elementa/effects/Effect;", "<init>", "()V", "Lgg/essential/universal/UMatrixStack;", "matrixStack", "", "beforeDraw", "(Lgg/essential/universal/UMatrixStack;)V", "Lgg/essential/elementa/UIComponent;", "component", "drawCheckerBoard", "(Lgg/essential/universal/UMatrixStack;Lgg/essential/elementa/UIComponent;)V", "Lgg/essential/universal/UGraphics;", "graphics", "", "x", "y", "Ljava/awt/Color;", "color", "drawVertex", "(Lgg/essential/universal/UGraphics;Lgg/essential/universal/UMatrixStack;DDLjava/awt/Color;)V", "Essential 1.18.2-forge"})
public final class CheckerboardBackgroundEffect
extends Effect {
    @Override
    public void beforeDraw(@NotNull UMatrixStack matrixStack) {
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        this.drawCheckerBoard(matrixStack, this.getBoundComponent());
    }

    private final void drawCheckerBoard(UMatrixStack matrixStack, UIComponent component3) {
        double left2 = component3.getLeft();
        double top = component3.getTop();
        double right = component3.getRight();
        double bottom = component3.getBottom();
        UGraphics graphics = UGraphics.getFromTessellator();
        graphics.beginWithDefaultShader(UGraphics.DrawMode.QUADS, DefaultVertexFormat.f_85815_);
        int n = (int)(right - left2);
        for (int x = 0; x < n; ++x) {
            int n2 = (int)(bottom - top);
            for (int y = 0; y < n2; ++y) {
                Color color2 = (x + y) % 2 == 0 ? Color.LIGHT_GRAY : EssentialPalette.TEXT_HIGHLIGHT;
                Intrinsics.checkNotNull((Object)graphics);
                double d = left2 + (double)x;
                double d2 = top + (double)y;
                Intrinsics.checkNotNull((Object)color2);
                this.drawVertex(graphics, matrixStack, d, d2, color2);
                this.drawVertex(graphics, matrixStack, left2 + (double)x, top + (double)y + 1.0, color2);
                this.drawVertex(graphics, matrixStack, left2 + (double)x + 1.0, top + (double)y + 1.0, color2);
                this.drawVertex(graphics, matrixStack, left2 + (double)x + 1.0, top + (double)y, color2);
            }
        }
        graphics.drawDirect();
    }

    private final void drawVertex(UGraphics graphics, UMatrixStack matrixStack, double x, double y, Color color2) {
        graphics.pos(matrixStack, x, y, 0.0).color((float)color2.getRed() / 255.0f, (float)color2.getGreen() / 255.0f, (float)color2.getBlue() / 255.0f, (float)color2.getAlpha() / 255.0f).endVertex();
    }
}

