/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.gui.multiplayer;

import gg.essential.Essential;
import gg.essential.connectionmanager.common.enums.ActivityType;
import gg.essential.connectionmanager.common.packet.telemetry.ClientTelemetryPacket;
import gg.essential.mixins.ext.client.gui.ServerListEntryNormalExtKt;
import gg.essential.mixins.ext.client.multiplayer.ServerDataExtKt;
import gg.essential.mixins.transformers.client.gui.ServerListEntryNormalAccessor;
import gg.essential.mixins.transformers.client.gui.ServerSelectionListAccessor;
import gg.essential.network.connectionmanager.ConnectionManager;
import gg.essential.network.connectionmanager.profile.ProfileManager;
import gg.essential.network.connectionmanager.serverdiscovery.ServerDiscoveryManager;
import gg.essential.network.connectionmanager.sps.SPSManager;
import gg.essential.serverdiscovery.model.ServerDiscovery;
import gg.essential.universal.UMinecraft;
import gg.essential.upnp.model.UPnPSession;
import gg.essential.util.ExtensionsKt;
import gg.essential.util.MinecraftUtils;
import gg.essential.util.UUIDUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.gui.screens.multiplayer.ServerSelectionList;
import net.minecraft.client.multiplayer.ServerData;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0019\u0010\u000f\u001a\u00020\n2\b\b\u0002\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J-\u0010\u0016\u001a \u0012\u001c\u0012\u001a\u0012\b\u0012\u00060\u0013R\u00020\u0004\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00140\u00120\u0011H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0013\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\b0\u0011\u00a2\u0006\u0004\b\u0018\u0010\u0017J(\u0010\u001c\u001a\u001b\u0012\t\u0012\u00070\u0015\u00a2\u0006\u0002\b\u001a\u0012\f\u0012\n \u001b*\u0004\u0018\u00010\b0\b0\u0019H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0015\u0010\u001e\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\r\u0010 \u001a\u00020\n\u00a2\u0006\u0004\b \u0010!J'\u0010\"\u001a\u0012 \u001b*\b\u0018\u00010\u0013R\u00020\u00040\u0013R\u00020\u00042\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\"\u0010#J\u0017\u0010$\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b$\u0010\fJ\r\u0010%\u001a\u00020\n\u00a2\u0006\u0004\b%\u0010!J\u000f\u0010&\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b&\u0010!J\u0015\u0010)\u001a\u00020\n2\u0006\u0010(\u001a\u00020'\u00a2\u0006\u0004\b)\u0010*R\u0019\u0010,\u001a\u00070+\u00a2\u0006\u0002\b\u001a8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b,\u0010-R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010.R\u0019\u00100\u001a\u00070/\u00a2\u0006\u0002\b\u001a8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b0\u00101R\u001c\u00103\u001a\n \u001b*\u0004\u0018\u000102028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b3\u00104RH\u00108\u001a6\u0012\u0014\u0012\u0012 \u001b*\b\u0018\u00010\u0013R\u00020\u00040\u0013R\u00020\u0004 \u001b*\u001a\u0012\u0014\u0012\u0012 \u001b*\b\u0018\u00010\u0013R\u00020\u00040\u0013R\u00020\u0004\u0018\u0001050\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u00107R8\u0010;\u001a&\u0012\f\u0012\n \u001b*\u0004\u0018\u00010909 \u001b*\u0012\u0012\f\u0012\n \u001b*\u0004\u0018\u00010909\u0018\u0001050\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u00107R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010<R\u0019\u0010>\u001a\u00070=\u00a2\u0006\u0002\b\u001a8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b>\u0010?\u00a8\u0006@"}, d2={"Lgg/essential/gui/multiplayer/EssentialServerSelectionList;", "", "Lnet/minecraft/client/gui/screens/multiplayer/JoinMultiplayerScreen;", "owner", "Lnet/minecraft/client/gui/screens/multiplayer/ServerSelectionList;", "serverSelectionList", "<init>", "(Lnet/minecraft/client/gui/screens/multiplayer/JoinMultiplayerScreen;Lnet/minecraft/client/gui/screens/multiplayer/ServerSelectionList;)V", "Lnet/minecraft/client/multiplayer/ServerData;", "serverData", "", "addFavorite", "(Lnet/minecraft/client/multiplayer/ServerData;)V", "", "clearLan", "clearServerList", "(Z)V", "", "Lkotlin/Pair;", "Lnet/minecraft/client/gui/screens/multiplayer/ServerSelectionList$OnlineServerEntry;", "", "", "getFeaturedServers", "()Ljava/util/Collection;", "getFriendsServers", "", "Lorg/jetbrains/annotations/NotNull;", "kotlin.jvm.PlatformType", "getKnownServers", "()Ljava/util/Map;", "isFavorite", "(Lnet/minecraft/client/multiplayer/ServerData;)Z", "loadFeaturedServers", "()V", "newEntry", "(Lnet/minecraft/client/multiplayer/ServerData;)Lnet/minecraft/client/gui/screens/multiplayer/ServerSelectionList$OnlineServerEntry;", "sendFavoriteTelemetryPacket", "updateFriendsServers", "updateList", "Ljava/util/UUID;", "uuid", "updatePlayerStatus", "(Ljava/util/UUID;)V", "Lgg/essential/network/connectionmanager/ConnectionManager;", "connectionManager", "Lgg/essential/network/connectionmanager/ConnectionManager;", "Lnet/minecraft/client/gui/screens/multiplayer/JoinMultiplayerScreen;", "Lgg/essential/network/connectionmanager/profile/ProfileManager;", "profileManager", "Lgg/essential/network/connectionmanager/profile/ProfileManager;", "Lgg/essential/network/connectionmanager/serverdiscovery/ServerDiscoveryManager;", "serverDiscoveryManager", "Lgg/essential/network/connectionmanager/serverdiscovery/ServerDiscoveryManager;", "", "getServerListInternet", "()Ljava/util/List;", "serverListInternet", "Lnet/minecraft/client/gui/screens/multiplayer/ServerSelectionList$NetworkServerEntry;", "getServerListLan", "serverListLan", "Lnet/minecraft/client/gui/screens/multiplayer/ServerSelectionList;", "Lgg/essential/network/connectionmanager/sps/SPSManager;", "spsManager", "Lgg/essential/network/connectionmanager/sps/SPSManager;", "Essential 1.18.2-forge"})
@SourceDebugExtension(value={"SMAP\nEssentialServerSelectionList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EssentialServerSelectionList.kt\ngg/essential/gui/multiplayer/EssentialServerSelectionList\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,205:1\n1179#2,2:206\n1253#2,4:208\n*S KotlinDebug\n*F\n+ 1 EssentialServerSelectionList.kt\ngg/essential/gui/multiplayer/EssentialServerSelectionList\n*L\n52#1:206,2\n52#1:208,4\n*E\n"})
public final class EssentialServerSelectionList {
    @NotNull
    private final JoinMultiplayerScreen owner;
    @NotNull
    private final ServerSelectionList serverSelectionList;
    @NotNull
    private final ConnectionManager connectionManager;
    @NotNull
    private final ProfileManager profileManager;
    @NotNull
    private final SPSManager spsManager;
    private final ServerDiscoveryManager serverDiscoveryManager;

    public EssentialServerSelectionList(@NotNull JoinMultiplayerScreen owner, @NotNull ServerSelectionList serverSelectionList) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)serverSelectionList, (String)"serverSelectionList");
        this.owner = owner;
        this.serverSelectionList = serverSelectionList;
        ConnectionManager connectionManager = Essential.getInstance().getConnectionManager();
        Intrinsics.checkNotNullExpressionValue((Object)connectionManager, (String)"getConnectionManager(...)");
        this.connectionManager = connectionManager;
        ProfileManager profileManager = this.connectionManager.getProfileManager();
        Intrinsics.checkNotNullExpressionValue((Object)profileManager, (String)"getProfileManager(...)");
        this.profileManager = profileManager;
        SPSManager sPSManager = this.connectionManager.getSpsManager();
        Intrinsics.checkNotNullExpressionValue((Object)sPSManager, (String)"getSpsManager(...)");
        this.spsManager = sPSManager;
        this.serverDiscoveryManager = this.connectionManager.getServerDiscoveryManager();
    }

    private final List<ServerSelectionList.OnlineServerEntry> getServerListInternet() {
        ServerSelectionList serverSelectionList = this.serverSelectionList;
        Intrinsics.checkNotNull((Object)serverSelectionList, (String)"null cannot be cast to non-null type gg.essential.mixins.transformers.client.gui.ServerSelectionListAccessor");
        return ((ServerSelectionListAccessor)serverSelectionList).getServerListInternet();
    }

    private final List<ServerSelectionList.NetworkServerEntry> getServerListLan() {
        ServerSelectionList serverSelectionList = this.serverSelectionList;
        Intrinsics.checkNotNull((Object)serverSelectionList, (String)"null cannot be cast to non-null type gg.essential.mixins.transformers.client.gui.ServerSelectionListAccessor");
        return ((ServerSelectionListAccessor)serverSelectionList).getServerListLan();
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, ServerData> getKnownServers() {
        void $this$associateTo$iv$iv;
        Iterable $this$associate$iv = (Iterable)RangesKt.until((int)0, (int)this.owner.m_99732_().m_105445_());
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        Iterator iterator = $this$associateTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv$iv = ((IntIterator)iterator).nextInt();
            Map map2 = destination$iv$iv;
            int it = element$iv$iv;
            boolean bl = false;
            ServerData data = this.owner.m_99732_().m_105432_(it);
            Pair pair = TuplesKt.to((Object)this.serverDiscoveryManager.normalizeAddress(data.f_105363_), (Object)data);
            map2.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    public final boolean isFavorite(@NotNull ServerData serverData) {
        Intrinsics.checkNotNullParameter((Object)serverData, (String)"serverData");
        return this.getKnownServers().containsKey(this.serverDiscoveryManager.normalizeAddress(serverData.f_105363_));
    }

    public final void addFavorite(@NotNull ServerData serverData) {
        Intrinsics.checkNotNullParameter((Object)serverData, (String)"serverData");
        this.sendFavoriteTelemetryPacket(serverData);
        this.owner.m_99732_().m_105443_(serverData);
        this.owner.m_99732_().m_105442_();
    }

    private final void sendFavoriteTelemetryPacket(ServerData serverData) {
        ServerDiscovery serverDiscovery = this.serverDiscoveryManager.findServerByAddress(serverData.f_105363_);
        if (serverDiscovery == null) {
            return;
        }
        ServerDiscovery discovery = serverDiscovery;
        this.connectionManager.getTelemetryManager().enqueue(new ClientTelemetryPacket("FEATURED_SERVER_FAVORITE", MapsKt.mapOf((Pair)TuplesKt.to((Object)"server", (Object)discovery.getId()))));
    }

    private final Collection<Pair<ServerSelectionList.OnlineServerEntry, List<String>>> getFeaturedServers() {
        Map<String, ServerData> knownServers = this.getKnownServers();
        List entries = new ArrayList();
        for (ServerDiscovery server : this.serverDiscoveryManager.getServers().values()) {
            if (!server.getProtocolVersions().contains(MinecraftUtils.getCurrentProtocolVersion())) continue;
            Intrinsics.checkNotNull((Object)server);
            entries.add(new Pair((Object)this.newEntry(ExtensionsKt.toServerData(server, knownServers)), server.getTags()));
        }
        return entries;
    }

    @NotNull
    public final Collection<ServerData> getFriendsServers() {
        Object object;
        Map entries = new LinkedHashMap();
        boolean mcServerType = false;
        for (UPnPSession uPnPSession : this.spsManager.getRemoteSessions()) {
            String string;
            ServerData serverData;
            Intrinsics.checkNotNullExpressionValue((Object)this.spsManager.getSpsAddress(uPnPSession.getHostUUID()), (String)"getSpsAddress(...)");
            ServerData $this$getFriendsServers_u24lambda_u241 = serverData = new ServerData("Loading username\u2026", string, mcServerType);
            boolean bl = false;
            ServerDataExtKt.setTrusted(ServerDataExtKt.getExt($this$getFriendsServers_u24lambda_u241), false);
            ServerData server = serverData;
            server.m_105379_(ServerData.ServerPackStatus.PROMPT);
            UUIDUtil.getName(uPnPSession.getHostUUID()).thenAcceptAsync(arg_0 -> EssentialServerSelectionList.getFriendsServers$lambda$2((Function1)new Function1<String, Unit>(server){
                final /* synthetic */ ServerData $server;
                {
                    this.$server = $server;
                    super(1);
                }

                public final void invoke(String it) {
                    Intrinsics.checkNotNull((Object)it);
                    this.$server.f_105362_ = StringsKt.endsWith((String)it, (String)"s", (boolean)true) ? it + "'" : it + "'s";
                }
            }, arg_0), ExtensionsKt.getExecutor(UMinecraft.getMinecraft()));
            entries.put(string, server);
        }
        Set addresses = new LinkedHashSet();
        addresses.addAll(this.connectionManager.getSocialManager().getIncomingServerInvites().values());
        for (Map.Entry<UUID, Pair<ActivityType, String>> entry : this.profileManager.getActivities().entrySet()) {
            UUID uuid = entry.getKey();
            Pair<ActivityType, String> activityAddressPair = entry.getValue();
            if (Intrinsics.areEqual((Object)uuid, (Object)UUIDUtil.getClientUUID()) || activityAddressPair.getFirst() != ActivityType.PLAYING || (object = (CharSequence)activityAddressPair.getSecond()) == null || StringsKt.isBlank((CharSequence)object) || Intrinsics.areEqual((Object)activityAddressPair.getSecond(), (Object)"Singleplayer")) continue;
            Object object2 = activityAddressPair.getSecond();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"<get-second>(...)");
            addresses.add(object2);
        }
        Map<String, ServerData> map2 = this.getKnownServers();
        for (String address : addresses) {
            if (this.spsManager.isSpsAddress(address)) continue;
            Object object3 = map2.get(address);
            if (object3 == null) {
                ServerDiscovery serverDiscovery = this.serverDiscoveryManager.findServerByAddress(address);
                object3 = serverDiscovery != null ? ExtensionsKt.toServerData(serverDiscovery, map2) : null;
                if (object3 == null) {
                    ServerData serverData;
                    ServerData $this$getFriendsServers_u24lambda_u243 = serverData = new ServerData("Server", address, mcServerType);
                    boolean bl = false;
                    ServerDataExtKt.setTrusted(ServerDataExtKt.getExt($this$getFriendsServers_u24lambda_u243), false);
                    $this$getFriendsServers_u24lambda_u243.m_105379_(ServerData.ServerPackStatus.PROMPT);
                    object3 = serverData;
                }
            }
            ServerData server = object3;
            object = entries;
            String string = server.f_105363_;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ip");
            object.put(string, server);
        }
        return entries.values();
    }

    public final void updateFriendsServers() {
        EssentialServerSelectionList.clearServerList$default(this, false, 1, null);
        for (ServerData entry : this.getFriendsServers()) {
            this.getServerListInternet().add(this.newEntry(entry));
        }
        this.updateList();
    }

    public final void loadFeaturedServers() {
        EssentialServerSelectionList.clearServerList$default(this, false, 1, null);
        for (Pair<ServerSelectionList.OnlineServerEntry, List<String>> featuredServer : this.getFeaturedServers()) {
            List list = (List)featuredServer.getSecond();
            boolean bl = list != null ? list.contains("EVENT") : false;
            if (bl) {
                this.getServerListInternet().add(0, (ServerSelectionList.OnlineServerEntry)featuredServer.getFirst());
                continue;
            }
            this.getServerListInternet().add((ServerSelectionList.OnlineServerEntry)featuredServer.getFirst());
        }
        this.updateList();
    }

    private final void clearServerList(boolean clearLan) {
        this.getServerListInternet().clear();
        if (clearLan) {
            this.getServerListLan().clear();
        }
    }

    static /* synthetic */ void clearServerList$default(EssentialServerSelectionList essentialServerSelectionList, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        essentialServerSelectionList.clearServerList(bl);
    }

    private final void updateList() {
        ServerSelectionList serverSelectionList = this.serverSelectionList;
        Intrinsics.checkNotNull((Object)serverSelectionList, (String)"null cannot be cast to non-null type gg.essential.mixins.transformers.client.gui.ServerSelectionListAccessor");
        ((ServerSelectionListAccessor)serverSelectionList).updateList();
    }

    public final void updatePlayerStatus(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        for (ServerSelectionList.OnlineServerEntry entry : this.getServerListInternet()) {
            Intrinsics.checkNotNull((Object)entry);
            ServerListEntryNormalExtKt.getFriends(ServerListEntryNormalExtKt.getExt(entry)).updatePlayerStatus(uuid);
        }
    }

    private final ServerSelectionList.OnlineServerEntry newEntry(ServerData serverData) {
        return ServerListEntryNormalAccessor.create(this.serverSelectionList, this.owner, serverData);
    }

    private static final void getFriendsServers$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }
}

