/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.gui.elementa.essentialmarkdown.drawables;

import gg.essential.elementa.UIComponent;
import gg.essential.elementa.components.UIImage;
import gg.essential.elementa.constraints.ConstraintType;
import gg.essential.elementa.constraints.XConstraint;
import gg.essential.elementa.constraints.YConstraint;
import gg.essential.elementa.constraints.resolution.ConstraintVisitor;
import gg.essential.elementa.dsl.ComponentsKt;
import gg.essential.elementa.dsl.UtilitiesKt;
import gg.essential.gui.elementa.essentialmarkdown.DrawState;
import gg.essential.gui.elementa.essentialmarkdown.EssentialMarkdown;
import gg.essential.gui.elementa.essentialmarkdown.drawables.Drawable;
import gg.essential.gui.elementa.essentialmarkdown.selection.ImageCursor;
import gg.essential.universal.UMatrixStack;
import java.awt.Color;
import java.net.URL;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u00011B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0007J(\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020 H\u0016J\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020\tH\u0016J \u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020\u001a2\u0006\u0010-\u001a\u00020\u001aH\u0014J\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\tH\u0016R\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00060\rR\u00020\u0000X\u0082.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u00060\rR\u00020\u0000X\u0082.\u00a2\u0006\u0002\n\u0000R$\u0010\u0010\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u00062"}, d2={"Lgg/essential/gui/elementa/essentialmarkdown/drawables/ImageDrawable;", "Lgg/essential/gui/elementa/essentialmarkdown/drawables/Drawable;", "md", "Lgg/essential/gui/elementa/essentialmarkdown/EssentialMarkdown;", "url", "Ljava/net/URL;", "fallback", "(Lgg/essential/gui/elementa/essentialmarkdown/EssentialMarkdown;Ljava/net/URL;Lgg/essential/gui/elementa/essentialmarkdown/drawables/Drawable;)V", "hasLoaded", "", "image", "Lgg/essential/elementa/components/UIImage;", "imageX", "Lgg/essential/gui/elementa/essentialmarkdown/drawables/ImageDrawable$ShiftableMDPixelConstraint;", "imageY", "value", "selected", "getSelected", "()Z", "setSelected", "(Z)V", "getUrl", "()Ljava/net/URL;", "cursorAt", "", "mouseX", "", "mouseY", "dragged", "mouseButton", "", "cursorAtEnd", "Lgg/essential/gui/elementa/essentialmarkdown/selection/ImageCursor;", "cursorAtStart", "draw", "", "matrixStack", "Lgg/essential/universal/UMatrixStack;", "state", "Lgg/essential/gui/elementa/essentialmarkdown/DrawState;", "hasSelectedText", "layoutImpl", "Lgg/essential/gui/elementa/essentialmarkdown/drawables/Drawable$Layout;", "x", "y", "width", "selectedText", "", "asMarkdown", "ShiftableMDPixelConstraint", "essential-gui-elementa"})
public final class ImageDrawable
extends Drawable {
    @NotNull
    private final URL url;
    @NotNull
    private final Drawable fallback;
    private boolean selected;
    private ShiftableMDPixelConstraint imageX;
    private ShiftableMDPixelConstraint imageY;
    @NotNull
    private final UIImage image;
    private boolean hasLoaded;

    public ImageDrawable(@NotNull EssentialMarkdown md, @NotNull URL url, @NotNull Drawable fallback) {
        Intrinsics.checkNotNullParameter((Object)md, (String)"md");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)fallback, (String)"fallback");
        super(md);
        this.url = url;
        this.fallback = fallback;
        this.image = (UIImage)ComponentsKt.childOf((UIComponent)UIImage.Companion.ofURL(this.url), md);
    }

    @NotNull
    public final URL getUrl() {
        return this.url;
    }

    public final boolean getSelected() {
        return this.selected;
    }

    public final void setSelected(boolean value2) {
        this.selected = value2;
        if (value2) {
            this.image.setColor(UtilitiesKt.toConstraint(new Color(200, 200, 255, 255)));
        } else {
            Color color2 = Color.WHITE;
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"WHITE");
            this.image.setColor(UtilitiesKt.toConstraint(color2));
        }
    }

    @Override
    @NotNull
    protected Drawable.Layout layoutImpl(float x, float y, float width2) {
        Drawable.Layout layout2;
        if (this.image.isLoaded()) {
            this.imageX = new ShiftableMDPixelConstraint(x, 0.0f);
            this.imageY = new ShiftableMDPixelConstraint(y, 0.0f);
            ShiftableMDPixelConstraint shiftableMDPixelConstraint = this.imageX;
            if (shiftableMDPixelConstraint == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"imageX");
                shiftableMDPixelConstraint = null;
            }
            this.image.setX(shiftableMDPixelConstraint);
            ShiftableMDPixelConstraint shiftableMDPixelConstraint2 = this.imageY;
            if (shiftableMDPixelConstraint2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"imageY");
                shiftableMDPixelConstraint2 = null;
            }
            this.image.setY(shiftableMDPixelConstraint2);
            float aspectRatio = this.image.getImageWidth() / this.image.getImageHeight();
            float imageWidth = RangesKt.coerceAtMost((float)this.image.getImageWidth(), (float)width2);
            float imageHeight = imageWidth / aspectRatio;
            this.image.setWidth(UtilitiesKt.pixels$default(Float.valueOf(imageWidth), false, false, 3, null));
            this.image.setHeight(UtilitiesKt.pixels$default(Float.valueOf(imageHeight), false, false, 3, null));
            layout2 = new Drawable.Layout(x, y, imageWidth, imageHeight, null, 16, null);
        } else {
            layout2 = this.fallback.layout(x, y, width2);
        }
        return layout2;
    }

    @Override
    public void draw(@NotNull UMatrixStack matrixStack, @NotNull DrawState state2) {
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        if (!this.image.isLoaded()) {
            this.fallback.drawCompat(matrixStack, state2);
        } else {
            ShiftableMDPixelConstraint shiftableMDPixelConstraint;
            if (!this.hasLoaded) {
                this.hasLoaded = true;
                this.getMd().layout();
            }
            if ((shiftableMDPixelConstraint = this.imageX) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"imageX");
                shiftableMDPixelConstraint = null;
            }
            shiftableMDPixelConstraint.setShift(state2.getXShift());
            ShiftableMDPixelConstraint shiftableMDPixelConstraint2 = this.imageY;
            if (shiftableMDPixelConstraint2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"imageY");
                shiftableMDPixelConstraint2 = null;
            }
            shiftableMDPixelConstraint2.setShift(state2.getYShift());
            this.image.drawCompat(matrixStack);
        }
    }

    @NotNull
    public Void cursorAt(float mouseX, float mouseY, boolean dragged, int mouseButton) {
        throw new IllegalStateException("never called");
    }

    @NotNull
    public ImageCursor cursorAtStart() {
        return new ImageCursor(this);
    }

    @NotNull
    public ImageCursor cursorAtEnd() {
        return new ImageCursor(this);
    }

    @Override
    @NotNull
    public String selectedText(boolean asMarkdown) {
        if (asMarkdown) {
            return " ![" + this.fallback.selectedText(true) + "](" + this.url + ") ";
        }
        return "" + ' ' + this.url + ' ';
    }

    @Override
    public boolean hasSelectedText() {
        return this.selected;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u000fH\u0016J\u0010\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u000fH\u0016J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u0005\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\b\"\u0004\b\u001b\u0010\r\u00a8\u0006%"}, d2={"Lgg/essential/gui/elementa/essentialmarkdown/drawables/ImageDrawable$ShiftableMDPixelConstraint;", "Lgg/essential/elementa/constraints/XConstraint;", "Lgg/essential/elementa/constraints/YConstraint;", "base", "", "shift", "(Lgg/essential/gui/elementa/essentialmarkdown/drawables/ImageDrawable;FF)V", "getBase", "()F", "cachedValue", "getCachedValue", "()Ljava/lang/Float;", "setCachedValue", "(F)V", "constrainTo", "Lgg/essential/elementa/UIComponent;", "getConstrainTo", "()Lgg/essential/elementa/UIComponent;", "setConstrainTo", "(Lgg/essential/elementa/UIComponent;)V", "recalculate", "", "getRecalculate", "()Z", "setRecalculate", "(Z)V", "getShift", "setShift", "getXPositionImpl", "component", "getYPositionImpl", "visitImpl", "", "visitor", "Lgg/essential/elementa/constraints/resolution/ConstraintVisitor;", "type", "Lgg/essential/elementa/constraints/ConstraintType;", "essential-gui-elementa"})
    private final class ShiftableMDPixelConstraint
    implements XConstraint,
    YConstraint {
        private final float base;
        private float shift;
        private float cachedValue;
        private boolean recalculate;
        @Nullable
        private UIComponent constrainTo;

        public ShiftableMDPixelConstraint(float base, float shift) {
            this.base = base;
            this.shift = shift;
            this.recalculate = true;
        }

        public final float getBase() {
            return this.base;
        }

        public final float getShift() {
            return this.shift;
        }

        public final void setShift(float f) {
            this.shift = f;
        }

        @Override
        @NotNull
        public Float getCachedValue() {
            return Float.valueOf(this.cachedValue);
        }

        @Override
        public void setCachedValue(float f) {
            this.cachedValue = f;
        }

        @Override
        public boolean getRecalculate() {
            return this.recalculate;
        }

        @Override
        public void setRecalculate(boolean bl) {
            this.recalculate = bl;
        }

        @Override
        @Nullable
        public UIComponent getConstrainTo() {
            return this.constrainTo;
        }

        @Override
        public void setConstrainTo(@Nullable UIComponent uIComponent) {
            this.constrainTo = uIComponent;
        }

        @Override
        public float getXPositionImpl(@NotNull UIComponent component3) {
            Intrinsics.checkNotNullParameter((Object)component3, (String)"component");
            return this.base + this.shift;
        }

        @Override
        public float getYPositionImpl(@NotNull UIComponent component3) {
            Intrinsics.checkNotNullParameter((Object)component3, (String)"component");
            return this.base + this.shift;
        }

        @Override
        public void visitImpl(@NotNull ConstraintVisitor visitor, @NotNull ConstraintType type) {
            Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        }
    }
}

