/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.gui.elementa.effects;

import gg.essential.elementa.effects.Effect;
import gg.essential.gui.elementa.effects.GradientEffect;
import gg.essential.gui.elementa.state.v2.State;
import gg.essential.universal.UGraphics;
import gg.essential.universal.UMatrixStack;
import gg.essential.universal.shader.UShader;
import gg.essential.util.GuiElementaPlatform;
import java.awt.Color;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL11;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB=\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lgg/essential/gui/elementa/effects/GradientEffect;", "Lgg/essential/elementa/effects/Effect;", "topLeft", "Lgg/essential/gui/elementa/state/v2/State;", "Ljava/awt/Color;", "topRight", "bottomLeft", "bottomRight", "(Lgg/essential/gui/elementa/state/v2/State;Lgg/essential/gui/elementa/state/v2/State;Lgg/essential/gui/elementa/state/v2/State;Lgg/essential/gui/elementa/state/v2/State;)V", "beforeChildrenDraw", "", "matrixStack", "Lgg/essential/universal/UMatrixStack;", "Companion", "essential-gui-elementa"})
public final class GradientEffect
extends Effect {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final State<Color> topLeft;
    @NotNull
    private final State<Color> topRight;
    @NotNull
    private final State<Color> bottomLeft;
    @NotNull
    private final State<Color> bottomRight;
    @Language(value="GLSL")
    @NotNull
    private static final String vertSource = "varying vec4 vColor;\n\nvoid main() {\n    gl_Position = gl_ProjectionMatrix * gl_ModelViewMatrix * gl_Vertex;\n    vColor = gl_Color;\n}";
    @Language(value="GLSL")
    @NotNull
    private static final String fragSource = "varying vec4 vColor;\n\nvoid main() {\n    // Generate four pseudo-random values in range [-0.5; 0.5] for the current fragment coords, based on\n    // Vlachos 2016, \"Advanced VR Rendering\"\n    vec4 noise = vec4(dot(vec2(171.0, 231.0), gl_FragCoord.xy));\n    noise = fract(noise / vec4(103.0, 71.0, 97.0, 127.0)) - 0.5;\n\n    // Apply dithering, i.e. randomly offset all the values within a color band, so there are no harsh\n    // edges between different bands after quantization.\n    gl_FragColor = vColor + noise / 255.0;\n}";
    @NotNull
    private static final Lazy<UShader> shader$delegate = LazyKt.lazy((Function0)Companion.shader.2.INSTANCE);

    public GradientEffect(@NotNull State<? extends Color> topLeft, @NotNull State<? extends Color> topRight, @NotNull State<? extends Color> bottomLeft, @NotNull State<? extends Color> bottomRight) {
        Intrinsics.checkNotNullParameter(topLeft, (String)"topLeft");
        Intrinsics.checkNotNullParameter(topRight, (String)"topRight");
        Intrinsics.checkNotNullParameter(bottomLeft, (String)"bottomLeft");
        Intrinsics.checkNotNullParameter(bottomRight, (String)"bottomRight");
        this.topLeft = topLeft;
        this.topRight = topRight;
        this.bottomLeft = bottomLeft;
        this.bottomRight = bottomRight;
    }

    @Override
    public void beforeChildrenDraw(@NotNull UMatrixStack matrixStack) {
        boolean dither;
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        Color topLeft = this.topLeft.get();
        Color topRight = this.topRight.get();
        Color bottomLeft = this.bottomLeft.get();
        Color bottomRight = this.bottomRight.get();
        boolean bl = dither = !Intrinsics.areEqual((Object)topLeft, (Object)topRight) || !Intrinsics.areEqual((Object)topLeft, (Object)bottomLeft) || !Intrinsics.areEqual((Object)bottomLeft, (Object)bottomRight);
        if (dither) {
            GradientEffect.Companion.getShader().bind();
        }
        UGraphics buffer = UGraphics.getFromTessellator();
        if (dither) {
            buffer.beginWithActiveShader(UGraphics.DrawMode.QUADS, UGraphics.CommonVertexFormats.POSITION_COLOR);
        } else {
            buffer.beginWithDefaultShader(UGraphics.DrawMode.QUADS, UGraphics.CommonVertexFormats.POSITION_COLOR);
        }
        double x1 = this.getBoundComponent().getLeft();
        double x2 = this.getBoundComponent().getRight();
        double y1 = this.getBoundComponent().getTop();
        double y2 = this.getBoundComponent().getBottom();
        buffer.pos(matrixStack, x2, y1, 0.0).color(topRight).endVertex();
        buffer.pos(matrixStack, x1, y1, 0.0).color(topLeft).endVertex();
        buffer.pos(matrixStack, x1, y2, 0.0).color(bottomLeft).endVertex();
        buffer.pos(matrixStack, x2, y2, 0.0).color(bottomRight).endVertex();
        int prevAlphaTestFunc = 0;
        float prevAlphaTestRef = 0.0f;
        if (!GuiElementaPlatform.Companion.getPlatform$essential_gui_elementa().isCoreProfile()) {
            prevAlphaTestFunc = GL11.glGetInteger((int)3009);
            prevAlphaTestRef = GL11.glGetFloat((int)3010);
            GuiElementaPlatform.Companion.getPlatform$essential_gui_elementa().glAlphaFunc(519, 0.0f);
        }
        UGraphics.enableDepth();
        UGraphics.depthFunc(519);
        buffer.drawDirect();
        UGraphics.disableDepth();
        UGraphics.depthFunc(515);
        if (!GuiElementaPlatform.Companion.getPlatform$essential_gui_elementa().isCoreProfile()) {
            GuiElementaPlatform.Companion.getPlatform$essential_gui_elementa().glAlphaFunc(prevAlphaTestFunc, prevAlphaTestRef);
        }
        if (dither) {
            GradientEffect.Companion.getShader().unbind();
        }
    }

    public static final /* synthetic */ String access$getVertSource$cp() {
        return vertSource;
    }

    public static final /* synthetic */ String access$getFragSource$cp() {
        return fragSource;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\u000b\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lgg/essential/gui/elementa/effects/GradientEffect$Companion;", "", "()V", "fragSource", "", "shader", "Lgg/essential/universal/shader/UShader;", "getShader", "()Lgg/essential/universal/shader/UShader;", "shader$delegate", "Lkotlin/Lazy;", "vertSource", "essential-gui-elementa"})
    public static final class Companion {
        private Companion() {
        }

        private final UShader getShader() {
            Lazy lazy2 = shader$delegate;
            return (UShader)lazy2.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

