/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.gui.account.factory;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.exceptions.InvalidCredentialsException;
import gg.essential.Essential;
import gg.essential.api.gui.NotificationBuilder;
import gg.essential.elementa.components.Window;
import gg.essential.gui.EssentialPalette;
import gg.essential.gui.account.MicrosoftUserAuthentication;
import gg.essential.gui.account.factory.ManagedSessionFactory;
import gg.essential.gui.notification.ExtensionsKt;
import gg.essential.gui.notification.Notifications;
import gg.essential.lib.gson.Gson;
import gg.essential.lib.gson.GsonBuilder;
import gg.essential.lib.gson.JsonDeserializationContext;
import gg.essential.lib.gson.JsonDeserializer;
import gg.essential.lib.gson.JsonElement;
import gg.essential.lib.gson.JsonObject;
import gg.essential.lib.gson.JsonSerializationContext;
import gg.essential.lib.gson.JsonSerializer;
import gg.essential.lib.gson.JsonSyntaxException;
import gg.essential.util.StringsKt;
import gg.essential.util.USession;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FileSystemException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u00045678B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0019\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u001b\u0010\u000f\u001a\u00020\u000e2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001f\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\r\u0010\u0019\u001a\u00020\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u0018J\u0017\u0010\u001e\u001a\n \u001d*\u0004\u0018\u00010\u001c0\u001cH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fR\u001c\u0010!\u001a\n \u001d*\u0004\u0018\u00010 0 8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010\"R$\u0010$\u001a\u0004\u0018\u00010#8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b$\u0010%\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u0014\u0010+\u001a\u00020*8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b+\u0010,R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010-R \u00101\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000e0.8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u001c\u00103\u001a\n \u001d*\u0004\u0018\u000102028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b3\u00104\u00a8\u00069"}, d2={"Lgg/essential/gui/account/factory/MicrosoftAccountSessionFactory;", "Lgg/essential/gui/account/factory/ManagedSessionFactory;", "Ljava/nio/file/Path;", "savePath", "<init>", "(Ljava/nio/file/Path;)V", "Ljava/util/UUID;", "uuid", "Ljava/time/Instant;", "getExpiryTime", "(Ljava/util/UUID;)Ljava/time/Instant;", "Ljava/util/concurrent/CompletableFuture;", "Ljava/net/URI;", "future", "Lgg/essential/util/USession;", "login", "(Ljava/util/concurrent/CompletableFuture;)Lgg/essential/util/USession;", "session", "", "force", "refresh", "(Lgg/essential/util/USession;Z)Lgg/essential/util/USession;", "", "refreshRefreshToken", "(Ljava/util/UUID;)V", "refreshRefreshTokensIfNecessary", "()V", "remove", "", "kotlin.jvm.PlatformType", "save", "()Ljava/lang/Object;", "Lgg/essential/lib/gson/Gson;", "gson", "Lgg/essential/lib/gson/Gson;", "Lgg/essential/gui/account/MicrosoftUserAuthentication;", "latestAuthService", "Lgg/essential/gui/account/MicrosoftUserAuthentication;", "getLatestAuthService", "()Lgg/essential/gui/account/MicrosoftUserAuthentication;", "setLatestAuthService", "(Lgg/essential/gui/account/MicrosoftUserAuthentication;)V", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "Ljava/nio/file/Path;", "", "getSessions", "()Ljava/util/Map;", "sessions", "Lgg/essential/gui/account/factory/MicrosoftAccountSessionFactory$State;", "state", "Lgg/essential/gui/account/factory/MicrosoftAccountSessionFactory$State;", "GameProfileSerializer", "InstantSerializer", "MicrosoftAccount", "State", "Essential 1.18.2-forge"})
@SourceDebugExtension(value={"SMAP\nMicrosoftAccountSessionFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MicrosoftAccountSessionFactory.kt\ngg/essential/gui/account/factory/MicrosoftAccountSessionFactory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,233:1\n1#2:234\n1179#3,2:235\n1253#3,4:237\n*S KotlinDebug\n*F\n+ 1 MicrosoftAccountSessionFactory.kt\ngg/essential/gui/account/factory/MicrosoftAccountSessionFactory\n*L\n159#1:235,2\n159#1:237,4\n*E\n"})
public final class MicrosoftAccountSessionFactory
implements ManagedSessionFactory {
    @NotNull
    private final Path savePath;
    @Nullable
    private MicrosoftUserAuthentication latestAuthService;
    private final Gson gson;
    @NotNull
    private final ReentrantReadWriteLock lock;
    private final State state;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public MicrosoftAccountSessionFactory(@NotNull Path savePath) {
        Object object;
        Throwable $this$gson_u24lambda_u2402;
        Intrinsics.checkNotNullParameter((Object)savePath, (String)"savePath");
        this.savePath = savePath;
        Object object2 = new GsonBuilder();
        GsonBuilder gsonBuilder = object2;
        MicrosoftAccountSessionFactory microsoftAccountSessionFactory = this;
        boolean bl = false;
        ((GsonBuilder)((Object)$this$gson_u24lambda_u2402)).registerTypeAdapter((Type)((Object)GameProfile.class), new GameProfileSerializer());
        ((GsonBuilder)((Object)$this$gson_u24lambda_u2402)).registerTypeAdapter((Type)((Object)Instant.class), new InstantSerializer());
        microsoftAccountSessionFactory.gson = ((GsonBuilder)object2).create();
        this.lock = new ReentrantReadWriteLock();
        MicrosoftAccountSessionFactory microsoftAccountSessionFactory2 = this;
        if (Files.exists(this.savePath, new LinkOption[0])) {
            microsoftAccountSessionFactory = microsoftAccountSessionFactory2;
            try {
                State state2;
                object2 = Files.newBufferedReader(this.savePath);
                MicrosoftAccountSessionFactory microsoftAccountSessionFactory3 = microsoftAccountSessionFactory;
                $this$gson_u24lambda_u2402 = null;
                try {
                    BufferedReader it = (BufferedReader)object2;
                    boolean bl2 = false;
                    state2 = this.gson.fromJson((Reader)it, State.class);
                }
                catch (Throwable throwable) {
                    $this$gson_u24lambda_u2402 = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object2, (Throwable)$this$gson_u24lambda_u2402);
                }
                microsoftAccountSessionFactory2 = microsoftAccountSessionFactory3;
                object2 = state2;
            }
            catch (JsonSyntaxException $this$gson_u24lambda_u2402) {
                void e;
                try {
                    microsoftAccountSessionFactory2 = microsoftAccountSessionFactory;
                    CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                    Files.move(this.savePath, this.savePath.resolveSibling(this.savePath.getFileName() + ".bak"), copyOptionArray);
                }
                catch (IOException iOException) {
                    microsoftAccountSessionFactory2 = microsoftAccountSessionFactory;
                }
                e.printStackTrace();
                ExtensionsKt.error$default(Notifications.INSTANCE, "Account Error", "Failed to load accounts. Please add them again.", null, null, null, 28, null);
                object2 = new State(new ArrayList());
            }
            object = object2;
        } else {
            object = new State(new ArrayList());
        }
        microsoftAccountSessionFactory2.state = object;
    }

    @Nullable
    public final MicrosoftUserAuthentication getLatestAuthService() {
        return this.latestAuthService;
    }

    public final void setLatestAuthService(@Nullable MicrosoftUserAuthentication microsoftUserAuthentication) {
        this.latestAuthService = microsoftUserAuthentication;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Object save() {
        CopyOption[] copyOptionArray;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int j = 0; j < n; ++j) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            Object object;
            boolean bl = false;
            Path tempFile = Files.createTempFile(this.savePath.getParent(), "essential-microsoft-accounts", ".json", new FileAttribute[0]);
            try {
                String string = this.gson.toJson(this.state);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
                byte[] byArray = string.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                Files.write(tempFile, byArray, new OpenOption[0]);
                try {
                    object = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE};
                    object = Files.move(tempFile, this.savePath, object);
                }
                catch (FileSystemException e) {
                    e.printStackTrace();
                    CopyOption[] copyOptionArray2 = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                    object = Files.move(tempFile, this.savePath, copyOptionArray2);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                ExtensionsKt.error$default(Notifications.INSTANCE, "Account Error", "Unable to save your accounts.", null, null, null, 28, null);
                object = Unit.INSTANCE;
            }
            finally {
                Files.deleteIfExists(tempFile);
            }
            copyOptionArray = object;
        }
        finally {
            for (int j = 0; j < n; ++j) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        return copyOptionArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int j = 0; j < n; ++j) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            MicrosoftAccount microsoftAccount;
            Object v0;
            block8: {
                boolean bl = false;
                Iterable iterable = this.state.getAccounts();
                for (Object t : iterable) {
                    MicrosoftAccount it = (MicrosoftAccount)t;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getUuid(), (Object)uuid)) continue;
                    v0 = t;
                    break block8;
                }
                v0 = null;
            }
            if ((MicrosoftAccount)v0 == null) {
                return;
            }
            MicrosoftAccount account = microsoftAccount;
            this.state.getAccounts().remove(account);
            this.save();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int j = 0; j < n; ++j) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final USession login(@NotNull CompletableFuture<URI> future2) {
        USession uSession;
        MicrosoftUserAuthentication userAuthService;
        Intrinsics.checkNotNullParameter(future2, (String)"future");
        this.latestAuthService = userAuthService = new MicrosoftUserAuthentication();
        Pair pair = MicrosoftUserAuthentication.logIn$default(userAuthService, future2, false, 2, null);
        GameProfile profile2 = (GameProfile)pair.component1();
        String token = (String)pair.component2();
        UUID uUID = profile2.getId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getId(...)");
        String string = profile2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        MicrosoftAccount account = new MicrosoftAccount(uUID, string, token, userAuthService);
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int j = 0; j < n; ++j) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            this.state.getAccounts().removeIf(arg_0 -> MicrosoftAccountSessionFactory.login$lambda$6$lambda$5((Function1)new Function1<MicrosoftAccount, Boolean>(profile2){
                final /* synthetic */ GameProfile $profile;
                {
                    this.$profile = $profile;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull MicrosoftAccount it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return Intrinsics.areEqual((Object)it.getUuid(), (Object)this.$profile.getId());
                }
            }, arg_0));
            this.state.getAccounts().add(account);
            this.save();
            uSession = account.toSession();
        }
        finally {
            for (int j = 0; j < n; ++j) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        return uSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public USession refresh(@NotNull USession session, boolean force) {
        USession uSession;
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int j = 0; j < n; ++j) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            Object v0;
            block10: {
                boolean bl = false;
                Iterable iterable = this.state.getAccounts();
                for (Object t : iterable) {
                    MicrosoftAccount it = (MicrosoftAccount)t;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getUuid(), (Object)session.getUuid())) continue;
                    v0 = t;
                    break block10;
                }
                v0 = null;
            }
            MicrosoftAccount microsoftAccount = v0;
            if (microsoftAccount == null) {
                throw new InvalidCredentialsException();
            }
            MicrosoftAccount account = microsoftAccount;
            try {
                MicrosoftUserAuthentication microsoftUserAuthentication = account.getAuth();
                CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
                Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
                Pair<GameProfile, String> pair = microsoftUserAuthentication.logIn(completableFuture, force);
                GameProfile profile2 = (GameProfile)pair.component1();
                String token = (String)pair.component2();
                String string = profile2.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                account.setName(string);
                account.setAccessToken(token);
            }
            finally {
                this.save();
            }
            uSession = account.toSession();
        }
        finally {
            for (int j = 0; j < n; ++j) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        return uSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Instant getExpiryTime(UUID uuid) {
        Instant instant;
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            Object object;
            Object v0;
            block4: {
                boolean bl = false;
                Iterable iterable = this.state.getAccounts();
                for (Object t : iterable) {
                    MicrosoftAccount it = (MicrosoftAccount)t;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getUuid(), (Object)uuid)) continue;
                    v0 = t;
                    break block4;
                }
                v0 = null;
            }
            instant = (object = (MicrosoftAccount)v0) != null && (object = ((MicrosoftAccount)object).getAuth()) != null ? ((MicrosoftUserAuthentication)object).getExpiryTime() : null;
        }
        finally {
            readLock.unlock();
        }
        return instant;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void refreshRefreshToken(UUID uuid) {
        Object v0;
        block5: {
            Iterable iterable = this.state.getAccounts();
            for (Object t : iterable) {
                MicrosoftAccount it = (MicrosoftAccount)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getUuid(), (Object)uuid)) continue;
                v0 = t;
                break block5;
            }
            v0 = null;
        }
        MicrosoftAccount microsoftAccount = v0;
        if (microsoftAccount == null) {
            throw new InvalidCredentialsException();
        }
        MicrosoftAccount account = microsoftAccount;
        try {
            account.getAuth().refreshRefreshToken();
        }
        finally {
            this.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<UUID, USession> getSessions() {
        Map map2;
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            void $this$associateTo$iv$iv;
            boolean bl = false;
            Iterable $this$associate$iv = this.state.getAccounts();
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map3 = destination$iv$iv;
                MicrosoftAccount it = (MicrosoftAccount)element$iv$iv;
                boolean bl2 = false;
                Pair pair = TuplesKt.to((Object)it.getUuid(), (Object)it.toSession());
                map3.put(pair.getFirst(), pair.getSecond());
            }
            map2 = destination$iv$iv;
        }
        finally {
            readLock.unlock();
        }
        return map2;
    }

    public final void refreshRefreshTokensIfNecessary() {
        for (Map.Entry<UUID, USession> entry : this.getSessions().entrySet()) {
            Instant it;
            UUID uuid = entry.getKey();
            USession session = entry.getValue();
            if (this.getExpiryTime(uuid) == null) continue;
            boolean bl = false;
            String username = session.getUsername();
            Essential.logger.debug(username + " " + uuid + " expires " + it);
            if (!it.isBefore(Instant.now().plus(76L, ChronoUnit.DAYS))) continue;
            Essential.logger.info("Refreshing the refresh token for " + username + " " + uuid);
            try {
                this.refreshRefreshToken(uuid);
            }
            catch (InvalidCredentialsException e) {
                Window.Companion.enqueueRenderOperation((Function0<Unit>)((Function0)new Function0<Unit>(username){
                    final /* synthetic */ String $username;
                    {
                        this.$username = $username;
                        super(0);
                    }

                    public final void invoke() {
                        ExtensionsKt.error$default(Notifications.INSTANCE, "Account Error", "", null, null, (Function1)new Function1<NotificationBuilder, Unit>(this.$username){
                            final /* synthetic */ String $username;
                            {
                                this.$username = $username;
                                super(1);
                            }

                            public final void invoke(@NotNull NotificationBuilder $this$error) {
                                Intrinsics.checkNotNullParameter((Object)$this$error, (String)"$this$error");
                                ExtensionsKt.markdownBody$default($this$error, "An error occurred while trying to keep " + StringsKt.colored(this.$username, EssentialPalette.TEXT_HIGHLIGHT) + " signed in. Please add this account again.", null, 2, null);
                            }
                        }, 12, null);
                    }
                }));
            }
        }
    }

    private static final boolean login$lambda$6$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J'\u0010\f\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ'\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lgg/essential/gui/account/factory/MicrosoftAccountSessionFactory$GameProfileSerializer;", "Lgg/essential/lib/gson/JsonSerializer;", "Lcom/mojang/authlib/GameProfile;", "Lgg/essential/lib/gson/JsonDeserializer;", "<init>", "()V", "Lgg/essential/lib/gson/JsonElement;", "json", "Ljava/lang/reflect/Type;", "typeOfT", "Lgg/essential/lib/gson/JsonDeserializationContext;", "context", "deserialize", "(Lgg/essential/lib/gson/JsonElement;Ljava/lang/reflect/Type;Lgg/essential/lib/gson/JsonDeserializationContext;)Lcom/mojang/authlib/GameProfile;", "src", "typeOfSrc", "Lgg/essential/lib/gson/JsonSerializationContext;", "Lgg/essential/lib/gson/JsonObject;", "serialize", "(Lcom/mojang/authlib/GameProfile;Ljava/lang/reflect/Type;Lgg/essential/lib/gson/JsonSerializationContext;)Lgg/essential/lib/gson/JsonObject;", "Essential 1.18.2-forge"})
    @SourceDebugExtension(value={"SMAP\nMicrosoftAccountSessionFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MicrosoftAccountSessionFactory.kt\ngg/essential/gui/account/factory/MicrosoftAccountSessionFactory$GameProfileSerializer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,233:1\n1#2:234\n*E\n"})
    private static final class GameProfileSerializer
    implements JsonSerializer<GameProfile>,
    JsonDeserializer<GameProfile> {
        @Override
        @NotNull
        public GameProfile deserialize(@NotNull JsonElement json2, @NotNull Type typeOfT, @NotNull JsonDeserializationContext context) {
            UUID uUID;
            Intrinsics.checkNotNullParameter((Object)json2, (String)"json");
            Intrinsics.checkNotNullParameter((Object)typeOfT, (String)"typeOfT");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            JsonObject cfr_ignored_0 = (JsonObject)json2;
            JsonElement jsonElement = ((JsonObject)json2).get("id");
            if (jsonElement != null) {
                JsonElement it = jsonElement;
                boolean bl = false;
                uUID = (UUID)context.deserialize(it, (Type)((Object)UUID.class));
            } else {
                uUID = null;
            }
            UUID id2 = uUID;
            JsonElement jsonElement2 = ((JsonObject)json2).get("name");
            String name2 = jsonElement2 != null ? jsonElement2.getAsString() : null;
            return new GameProfile(id2, name2);
        }

        @NotNull
        public JsonObject serialize(@NotNull GameProfile src, @NotNull Type typeOfSrc, @NotNull JsonSerializationContext context) {
            JsonObject jsonObject;
            block1: {
                Object it;
                Intrinsics.checkNotNullParameter((Object)src, (String)"src");
                Intrinsics.checkNotNullParameter((Object)typeOfSrc, (String)"typeOfSrc");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                JsonObject $this$serialize_u24lambda_u243 = jsonObject = new JsonObject();
                boolean bl = false;
                Object object = src.getId();
                UUID uUID = object;
                if (uUID != null) {
                    Intrinsics.checkNotNull((Object)uUID);
                    it = object;
                    boolean bl2 = false;
                    $this$serialize_u24lambda_u243.add("id", context.serialize(it));
                }
                Object object2 = object = src.getName();
                if (object2 == null) break block1;
                Intrinsics.checkNotNull((Object)object2);
                it = object;
                boolean bl3 = false;
                $this$serialize_u24lambda_u243.add("name", context.serialize(it));
            }
            return jsonObject;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J'\u0010\f\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ'\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lgg/essential/gui/account/factory/MicrosoftAccountSessionFactory$InstantSerializer;", "Lgg/essential/lib/gson/JsonSerializer;", "Ljava/time/Instant;", "Lgg/essential/lib/gson/JsonDeserializer;", "<init>", "()V", "Lgg/essential/lib/gson/JsonElement;", "json", "Ljava/lang/reflect/Type;", "typeOfT", "Lgg/essential/lib/gson/JsonDeserializationContext;", "context", "deserialize", "(Lgg/essential/lib/gson/JsonElement;Ljava/lang/reflect/Type;Lgg/essential/lib/gson/JsonDeserializationContext;)Ljava/time/Instant;", "src", "typeOfSrc", "Lgg/essential/lib/gson/JsonSerializationContext;", "Lgg/essential/lib/gson/JsonObject;", "serialize", "(Ljava/time/Instant;Ljava/lang/reflect/Type;Lgg/essential/lib/gson/JsonSerializationContext;)Lgg/essential/lib/gson/JsonObject;", "Essential 1.18.2-forge"})
    private static final class InstantSerializer
    implements JsonSerializer<Instant>,
    JsonDeserializer<Instant> {
        @Override
        @NotNull
        public Instant deserialize(@NotNull JsonElement json2, @NotNull Type typeOfT, @NotNull JsonDeserializationContext context) {
            Intrinsics.checkNotNullParameter((Object)json2, (String)"json");
            Intrinsics.checkNotNullParameter((Object)typeOfT, (String)"typeOfT");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            JsonObject cfr_ignored_0 = (JsonObject)json2;
            long seconds = ((JsonObject)json2).get("seconds").getAsLong();
            long nanos = ((JsonObject)json2).get("nanos").getAsLong();
            Instant instant = Instant.ofEpochSecond(seconds, nanos);
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"ofEpochSecond(...)");
            return instant;
        }

        @NotNull
        public JsonObject serialize(@NotNull Instant src, @NotNull Type typeOfSrc, @NotNull JsonSerializationContext context) {
            JsonObject jsonObject;
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            Intrinsics.checkNotNullParameter((Object)typeOfSrc, (String)"typeOfSrc");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            JsonObject $this$serialize_u24lambda_u240 = jsonObject = new JsonObject();
            boolean bl = false;
            $this$serialize_u24lambda_u240.add("seconds", context.serialize(src.getEpochSecond()));
            $this$serialize_u24lambda_u240.add("nanos", context.serialize(src.getNano()));
            return jsonObject;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0082\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\r\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u000f\u0010\u000eJ\u0010\u0010\u0010\u001a\u00020\u0007H\u00c6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J8\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u00042\b\b\u0002\u0010\b\u001a\u00020\u0007H\u00c6\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001a\u0010\u0016\u001a\u00020\u00152\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0010\u0010\u0019\u001a\u00020\u0018H\u00d6\u0001\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\r\u0010\u001c\u001a\u00020\u001b\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0010\u0010\u001e\u001a\u00020\u0004H\u00d6\u0001\u00a2\u0006\u0004\b\u001e\u0010\u000eR\"\u0010\u0006\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0006\u0010\u001f\u001a\u0004\b \u0010\u000e\"\u0004\b!\u0010\"R\"\u0010\b\u001a\u00020\u00078\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\b\u0010#\u001a\u0004\b$\u0010\u0011\"\u0004\b%\u0010&R\"\u0010\u0005\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010\u001f\u001a\u0004\b'\u0010\u000e\"\u0004\b(\u0010\"R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010)\u001a\u0004\b*\u0010\f\u00a8\u0006+"}, d2={"Lgg/essential/gui/account/factory/MicrosoftAccountSessionFactory$MicrosoftAccount;", "", "Ljava/util/UUID;", "uuid", "", "name", "accessToken", "Lgg/essential/gui/account/MicrosoftUserAuthentication;", "auth", "<init>", "(Ljava/util/UUID;Ljava/lang/String;Ljava/lang/String;Lgg/essential/gui/account/MicrosoftUserAuthentication;)V", "component1", "()Ljava/util/UUID;", "component2", "()Ljava/lang/String;", "component3", "component4", "()Lgg/essential/gui/account/MicrosoftUserAuthentication;", "copy", "(Ljava/util/UUID;Ljava/lang/String;Ljava/lang/String;Lgg/essential/gui/account/MicrosoftUserAuthentication;)Lgg/essential/gui/account/factory/MicrosoftAccountSessionFactory$MicrosoftAccount;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "Lgg/essential/util/USession;", "toSession", "()Lgg/essential/util/USession;", "toString", "Ljava/lang/String;", "getAccessToken", "setAccessToken", "(Ljava/lang/String;)V", "Lgg/essential/gui/account/MicrosoftUserAuthentication;", "getAuth", "setAuth", "(Lgg/essential/gui/account/MicrosoftUserAuthentication;)V", "getName", "setName", "Ljava/util/UUID;", "getUuid", "Essential 1.18.2-forge"})
    private static final class MicrosoftAccount {
        @NotNull
        private final UUID uuid;
        @NotNull
        private String name;
        @NotNull
        private String accessToken;
        @NotNull
        private MicrosoftUserAuthentication auth;

        public MicrosoftAccount(@NotNull UUID uuid, @NotNull String name2, @NotNull String accessToken, @NotNull MicrosoftUserAuthentication auth) {
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
            Intrinsics.checkNotNullParameter((Object)auth, (String)"auth");
            this.uuid = uuid;
            this.name = name2;
            this.accessToken = accessToken;
            this.auth = auth;
        }

        @NotNull
        public final UUID getUuid() {
            return this.uuid;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final void setName(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.name = string;
        }

        @NotNull
        public final String getAccessToken() {
            return this.accessToken;
        }

        public final void setAccessToken(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.accessToken = string;
        }

        @NotNull
        public final MicrosoftUserAuthentication getAuth() {
            return this.auth;
        }

        public final void setAuth(@NotNull MicrosoftUserAuthentication microsoftUserAuthentication) {
            Intrinsics.checkNotNullParameter((Object)microsoftUserAuthentication, (String)"<set-?>");
            this.auth = microsoftUserAuthentication;
        }

        @NotNull
        public final USession toSession() {
            return new USession(this.uuid, this.name, this.accessToken);
        }

        @NotNull
        public final UUID component1() {
            return this.uuid;
        }

        @NotNull
        public final String component2() {
            return this.name;
        }

        @NotNull
        public final String component3() {
            return this.accessToken;
        }

        @NotNull
        public final MicrosoftUserAuthentication component4() {
            return this.auth;
        }

        @NotNull
        public final MicrosoftAccount copy(@NotNull UUID uuid, @NotNull String name2, @NotNull String accessToken, @NotNull MicrosoftUserAuthentication auth) {
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
            Intrinsics.checkNotNullParameter((Object)auth, (String)"auth");
            return new MicrosoftAccount(uuid, name2, accessToken, auth);
        }

        public static /* synthetic */ MicrosoftAccount copy$default(MicrosoftAccount microsoftAccount, UUID uUID, String string, String string2, MicrosoftUserAuthentication microsoftUserAuthentication, int n, Object object) {
            if ((n & 1) != 0) {
                uUID = microsoftAccount.uuid;
            }
            if ((n & 2) != 0) {
                string = microsoftAccount.name;
            }
            if ((n & 4) != 0) {
                string2 = microsoftAccount.accessToken;
            }
            if ((n & 8) != 0) {
                microsoftUserAuthentication = microsoftAccount.auth;
            }
            return microsoftAccount.copy(uUID, string, string2, microsoftUserAuthentication);
        }

        @NotNull
        public String toString() {
            return "MicrosoftAccount(uuid=" + this.uuid + ", name=" + this.name + ", accessToken=" + this.accessToken + ", auth=" + this.auth + ")";
        }

        public int hashCode() {
            int result = this.uuid.hashCode();
            result = result * 31 + this.name.hashCode();
            result = result * 31 + this.accessToken.hashCode();
            result = result * 31 + this.auth.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MicrosoftAccount)) {
                return false;
            }
            MicrosoftAccount microsoftAccount = (MicrosoftAccount)other;
            if (!Intrinsics.areEqual((Object)this.uuid, (Object)microsoftAccount.uuid)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.name, (Object)microsoftAccount.name)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.accessToken, (Object)microsoftAccount.accessToken)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.auth, (Object)microsoftAccount.auth);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ \u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\t\u0010\nJ\u001a\u0010\r\u001a\u00020\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u0010\u001a\u00020\u000fH\u00d6\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0013\u001a\u00020\u0012H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0015\u001a\u0004\b\u0016\u0010\b\u00a8\u0006\u0017"}, d2={"Lgg/essential/gui/account/factory/MicrosoftAccountSessionFactory$State;", "", "", "Lgg/essential/gui/account/factory/MicrosoftAccountSessionFactory$MicrosoftAccount;", "accounts", "<init>", "(Ljava/util/List;)V", "component1", "()Ljava/util/List;", "copy", "(Ljava/util/List;)Lgg/essential/gui/account/factory/MicrosoftAccountSessionFactory$State;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Ljava/util/List;", "getAccounts", "Essential 1.18.2-forge"})
    private static final class State {
        @NotNull
        private final List<MicrosoftAccount> accounts;

        public State(@NotNull List<MicrosoftAccount> accounts) {
            Intrinsics.checkNotNullParameter(accounts, (String)"accounts");
            this.accounts = accounts;
        }

        @NotNull
        public final List<MicrosoftAccount> getAccounts() {
            return this.accounts;
        }

        @NotNull
        public final List<MicrosoftAccount> component1() {
            return this.accounts;
        }

        @NotNull
        public final State copy(@NotNull List<MicrosoftAccount> accounts) {
            Intrinsics.checkNotNullParameter(accounts, (String)"accounts");
            return new State(accounts);
        }

        public static /* synthetic */ State copy$default(State state2, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = state2.accounts;
            }
            return state2.copy(list);
        }

        @NotNull
        public String toString() {
            return "State(accounts=" + this.accounts + ")";
        }

        public int hashCode() {
            return ((Object)this.accounts).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof State)) {
                return false;
            }
            State state2 = (State)other;
            return Intrinsics.areEqual(this.accounts, state2.accounts);
        }
    }
}

