/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.elementa.svg.data;

import gg.essential.elementa.svg.data.Point;
import gg.essential.elementa.svg.data.SVGElement;
import java.nio.FloatBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0018\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 32\u00020\u0001:\u00013B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\rJ\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010 \u001a\u00020\u0005H\u00c6\u0003J\t\u0010!\u001a\u00020\bH\u00c6\u0003J\t\u0010\"\u001a\u00020\nH\u00c6\u0003J\t\u0010#\u001a\u00020\nH\u00c6\u0003J\t\u0010$\u001a\u00020\u0003H\u00c6\u0003JO\u0010%\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\n2\b\b\u0002\u0010\f\u001a\u00020\u0003H\u00c6\u0001J\u0010\u0010&\u001a\u00020\b2\u0006\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020\nH\u0016J\u0013\u0010*\u001a\u00020\n2\b\u0010+\u001a\u0004\u0018\u00010,H\u00d6\u0003J\b\u0010-\u001a\u00020\bH\u0016J\t\u0010.\u001a\u00020\bH\u00d6\u0001J\u0010\u0010/\u001a\u00020\u000f2\u0006\u00100\u001a\u00020\u000fH\u0002J\t\u00101\u001a\u000202H\u00d6\u0001R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0012R\u000e\u0010\u0019\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0014R\u000e\u0010\u001b\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u00064"}, d2={"Lgg/essential/elementa/svg/data/SVGArc;", "Lgg/essential/elementa/svg/data/SVGElement;", "startPoint", "Lgg/essential/elementa/svg/data/Point;", "rx", "", "ry", "xAxisRotation", "", "largeArc", "", "sweep", "endPoint", "(Lgg/essential/elementa/svg/data/Point;FFIZZLgg/essential/elementa/svg/data/Point;)V", "cx", "", "cy", "getEndPoint", "()Lgg/essential/elementa/svg/data/Point;", "getLargeArc", "()Z", "getRx", "()F", "getRy", "getStartPoint", "startTheta", "getSweep", "thetaDifference", "getXAxisRotation", "()I", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "createBuffer", "buffer", "Ljava/nio/FloatBuffer;", "drawSmoothPoints", "equals", "other", "", "getVertexCount", "hashCode", "safeAcos", "value", "toString", "", "Companion", "Elementa"})
public final class SVGArc
extends SVGElement {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Point startPoint;
    private final float rx;
    private final float ry;
    private final int xAxisRotation;
    private final boolean largeArc;
    private final boolean sweep;
    @NotNull
    private final Point endPoint;
    private double cx;
    private double cy;
    private double startTheta;
    private double thetaDifference;
    private static final double TWO_PI = Math.PI * 2;

    public SVGArc(@NotNull Point startPoint, float rx, float ry, int xAxisRotation, boolean largeArc, boolean sweep, @NotNull Point endPoint) {
        Intrinsics.checkNotNullParameter((Object)startPoint, (String)"startPoint");
        Intrinsics.checkNotNullParameter((Object)endPoint, (String)"endPoint");
        this.startPoint = startPoint;
        this.rx = rx;
        this.ry = ry;
        this.xAxisRotation = xAxisRotation;
        this.largeArc = largeArc;
        this.sweep = sweep;
        this.endPoint = endPoint;
        double angleRad = Math.toRadians((double)this.xAxisRotation % 360.0);
        double cosAngle = Math.cos(angleRad);
        double sinAngle = Math.sin(angleRad);
        double dx2 = (double)(this.startPoint.getX() - this.endPoint.getX()) / 2.0;
        double dy2 = (double)(this.startPoint.getY() - this.endPoint.getY()) / 2.0;
        double x1 = cosAngle * dx2 + sinAngle * dy2;
        double y1 = -sinAngle * dx2 + cosAngle * dy2;
        double radiusX = this.rx;
        double radiusY = this.ry;
        double squareRX = radiusX * radiusX;
        double squareRY = radiusY * radiusY;
        double squareX1 = x1 * x1;
        double squareY1 = y1 * y1;
        double radiiCheck = squareX1 / squareRX + squareY1 / squareRY;
        if (radiiCheck > 0.99999) {
            double radiiScale = Math.sqrt(radiiCheck) * 1.00001;
            radiusX = radiiScale * radiusX;
            radiusY = radiiScale * radiusY;
            squareRX = radiusX * radiusX;
            squareRY = radiusY * radiusY;
        }
        double sign = this.largeArc == this.sweep ? -1.0 : 1.0;
        double sq = RangesKt.coerceAtLeast((double)((squareRX * squareRY - squareRX * squareY1 - squareRY * squareX1) / (squareRX * squareY1 + squareRY * squareX1)), (double)0.0);
        double coefficient = sign * Math.sqrt(sq);
        double cx1 = coefficient * (radiusX * y1 / radiusY);
        double cy1 = coefficient * -(radiusY * x1 / radiusX);
        double sx2 = (double)(this.startPoint.getX() + this.endPoint.getX()) / 2.0;
        double sy2 = (double)(this.startPoint.getY() + this.endPoint.getY()) / 2.0;
        this.cx = sx2 + (cosAngle * cx1 - sinAngle * cy1);
        this.cy = sy2 + (sinAngle * cx1 + cosAngle * cy1);
        double ux = (x1 - cx1) / radiusX;
        double uy = (y1 - cy1) / radiusY;
        double vx = (-x1 - cx1) / radiusX;
        double vy = (-y1 - cy1) / radiusY;
        double n = Math.sqrt(ux * ux + uy * uy);
        double p = ux;
        sign = uy < 0.0 ? -1.0 : 1.0;
        this.startTheta = sign * Math.acos(p / n);
        n = Math.sqrt((ux * ux + uy * uy) * (vx * vx + vy * vy));
        p = ux * vx + uy * vy;
        sign = ux * vy - uy * vx < 0.0 ? -1.0 : 1.0;
        this.thetaDifference = sign * this.safeAcos(p / n);
        if (!this.sweep && this.thetaDifference > 0.0) {
            this.thetaDifference -= Math.PI * 2;
        } else if (this.sweep && this.thetaDifference < 0.0) {
            this.thetaDifference += Math.PI * 2;
        }
        this.thetaDifference %= Math.PI * 2;
        this.startTheta %= Math.PI * 2;
    }

    @NotNull
    public final Point getStartPoint() {
        return this.startPoint;
    }

    public final float getRx() {
        return this.rx;
    }

    public final float getRy() {
        return this.ry;
    }

    public final int getXAxisRotation() {
        return this.xAxisRotation;
    }

    public final boolean getLargeArc() {
        return this.largeArc;
    }

    public final boolean getSweep() {
        return this.sweep;
    }

    @NotNull
    public final Point getEndPoint() {
        return this.endPoint;
    }

    @Override
    public int getVertexCount() {
        return (int)Math.ceil(Math.abs(this.thetaDifference) / (Math.PI * 2) * (double)25) + 1;
    }

    @Override
    public int createBuffer(@NotNull FloatBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        int numVertices = this.getVertexCount();
        double thetaPerVertex = this.thetaDifference / (double)(numVertices - 1);
        double currTheta = 0.0;
        currTheta = this.startTheta;
        int n = 0;
        int n2 = numVertices;
        while (n < n2) {
            int it = n++;
            boolean bl = false;
            buffer.put((float)(this.cx + (double)this.rx * Math.cos(currTheta)));
            buffer.put((float)(this.cy + (double)this.ry * Math.sin(currTheta)));
            currTheta += thetaPerVertex;
        }
        return 3;
    }

    private final double safeAcos(double value2) {
        return value2 < -1.0 ? Math.PI : (value2 > 1.0 ? 0.0 : Math.acos(value2));
    }

    @Override
    public boolean drawSmoothPoints() {
        return false;
    }

    @NotNull
    public final Point component1() {
        return this.startPoint;
    }

    public final float component2() {
        return this.rx;
    }

    public final float component3() {
        return this.ry;
    }

    public final int component4() {
        return this.xAxisRotation;
    }

    public final boolean component5() {
        return this.largeArc;
    }

    public final boolean component6() {
        return this.sweep;
    }

    @NotNull
    public final Point component7() {
        return this.endPoint;
    }

    @NotNull
    public final SVGArc copy(@NotNull Point startPoint, float rx, float ry, int xAxisRotation, boolean largeArc, boolean sweep, @NotNull Point endPoint) {
        Intrinsics.checkNotNullParameter((Object)startPoint, (String)"startPoint");
        Intrinsics.checkNotNullParameter((Object)endPoint, (String)"endPoint");
        return new SVGArc(startPoint, rx, ry, xAxisRotation, largeArc, sweep, endPoint);
    }

    public static /* synthetic */ SVGArc copy$default(SVGArc sVGArc, Point point, float f, float f2, int n, boolean bl, boolean bl2, Point point2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            point = sVGArc.startPoint;
        }
        if ((n2 & 2) != 0) {
            f = sVGArc.rx;
        }
        if ((n2 & 4) != 0) {
            f2 = sVGArc.ry;
        }
        if ((n2 & 8) != 0) {
            n = sVGArc.xAxisRotation;
        }
        if ((n2 & 0x10) != 0) {
            bl = sVGArc.largeArc;
        }
        if ((n2 & 0x20) != 0) {
            bl2 = sVGArc.sweep;
        }
        if ((n2 & 0x40) != 0) {
            point2 = sVGArc.endPoint;
        }
        return sVGArc.copy(point, f, f2, n, bl, bl2, point2);
    }

    @NotNull
    public String toString() {
        return "SVGArc(startPoint=" + this.startPoint + ", rx=" + this.rx + ", ry=" + this.ry + ", xAxisRotation=" + this.xAxisRotation + ", largeArc=" + this.largeArc + ", sweep=" + this.sweep + ", endPoint=" + this.endPoint + ')';
    }

    public int hashCode() {
        int result = this.startPoint.hashCode();
        result = result * 31 + Float.hashCode(this.rx);
        result = result * 31 + Float.hashCode(this.ry);
        result = result * 31 + Integer.hashCode(this.xAxisRotation);
        result = result * 31 + Boolean.hashCode(this.largeArc);
        result = result * 31 + Boolean.hashCode(this.sweep);
        result = result * 31 + this.endPoint.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SVGArc)) {
            return false;
        }
        SVGArc sVGArc = (SVGArc)other;
        if (!Intrinsics.areEqual((Object)this.startPoint, (Object)sVGArc.startPoint)) {
            return false;
        }
        if (Float.compare(this.rx, sVGArc.rx) != 0) {
            return false;
        }
        if (Float.compare(this.ry, sVGArc.ry) != 0) {
            return false;
        }
        if (this.xAxisRotation != sVGArc.xAxisRotation) {
            return false;
        }
        if (this.largeArc != sVGArc.largeArc) {
            return false;
        }
        if (this.sweep != sVGArc.sweep) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.endPoint, (Object)sVGArc.endPoint);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lgg/essential/elementa/svg/data/SVGArc$Companion;", "", "()V", "TWO_PI", "", "Elementa"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

