/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.elementa.impl.dom4j.tree;

import gg.essential.elementa.impl.dom4j.Node;
import gg.essential.elementa.impl.dom4j.tree.AbstractBranch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class BackedList<T extends Node>
extends ArrayList<T> {
    private List<Node> branchContent;
    private AbstractBranch branch;

    public BackedList(AbstractBranch branch, List<Node> branchContent) {
        this(branch, branchContent, branchContent.size());
    }

    public BackedList(AbstractBranch branch, List<Node> branchContent, int capacity) {
        super(capacity);
        this.branch = branch;
        this.branchContent = branchContent;
    }

    public BackedList(AbstractBranch branch, List<Node> branchContent, List<T> initialContent) {
        super(initialContent);
        this.branch = branch;
        this.branchContent = branchContent;
    }

    @Override
    public boolean add(T node2) {
        this.branch.addNode((Node)node2);
        return super.add(node2);
    }

    @Override
    public void add(int index2, T node2) {
        int size = this.size();
        if (index2 < 0) {
            throw new IndexOutOfBoundsException("Index value: " + index2 + " is less than zero");
        }
        if (index2 > size) {
            throw new IndexOutOfBoundsException("Index value: " + index2 + " cannot be greater than the size: " + size);
        }
        int realIndex = size == 0 ? this.branchContent.size() : (index2 < size ? this.branchContent.indexOf(this.get(index2)) : this.branchContent.indexOf(this.get(size - 1)) + 1);
        this.branch.addNode(realIndex, (Node)node2);
        super.add(index2, node2);
    }

    @Override
    public T set(int index2, T node2) {
        int realIndex = this.branchContent.indexOf(this.get(index2));
        if (realIndex < 0) {
            int n = realIndex = index2 == 0 ? 0 : Integer.MAX_VALUE;
        }
        if (realIndex < this.branchContent.size()) {
            this.branch.removeNode((Node)this.get(index2));
            this.branch.addNode(realIndex, (Node)node2);
        } else {
            this.branch.removeNode((Node)this.get(index2));
            this.branch.addNode((Node)node2);
        }
        this.branch.childAdded((Node)node2);
        return (T)((Node)super.set(index2, node2));
    }

    @Override
    public boolean remove(Object object) {
        if (object instanceof Node) {
            this.branch.removeNode((Node)object);
        }
        return super.remove(object);
    }

    @Override
    public T remove(int index2) {
        Node node2 = (Node)super.remove(index2);
        if (node2 != null) {
            this.branch.removeNode(node2);
        }
        return (T)node2;
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        this.ensureCapacity(this.size() + collection.size());
        int count = this.size();
        Iterator<T> iter2 = collection.iterator();
        while (iter2.hasNext()) {
            this.add((T)((Node)iter2.next()));
            --count;
        }
        return count != 0;
    }

    @Override
    public boolean addAll(int index2, Collection<? extends T> collection) {
        this.ensureCapacity(this.size() + collection.size());
        int count = this.size();
        Iterator<T> iter2 = collection.iterator();
        while (iter2.hasNext()) {
            this.add(index2++, (T)((Node)iter2.next()));
            --count;
        }
        return count != 0;
    }

    @Override
    public void clear() {
        for (Node node2 : this) {
            this.branchContent.remove(node2);
            this.branch.childRemoved(node2);
        }
        super.clear();
    }

    public void addLocal(T node2) {
        super.add(node2);
    }
}

