/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.elementa.impl.dom4j.dom;

import gg.essential.elementa.impl.dom4j.Branch;
import gg.essential.elementa.impl.dom4j.CharacterData;
import gg.essential.elementa.impl.dom4j.Document;
import gg.essential.elementa.impl.dom4j.DocumentType;
import gg.essential.elementa.impl.dom4j.Element;
import gg.essential.elementa.impl.dom4j.Node;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DOMNodeHelper {
    public static final NodeList EMPTY_NODE_LIST = new EmptyNodeList();

    protected DOMNodeHelper() {
    }

    public static boolean supports(Node node2, String feature, String version) {
        return false;
    }

    public static String getNamespaceURI(Node node2) {
        return null;
    }

    public static String getPrefix(Node node2) {
        return null;
    }

    public static String getLocalName(Node node2) {
        return null;
    }

    public static void setPrefix(Node node2, String prefix) throws DOMException {
        DOMNodeHelper.notSupported();
    }

    public static String getNodeValue(Node node2) throws DOMException {
        return node2.getText();
    }

    public static void setNodeValue(Node node2, String nodeValue) throws DOMException {
        node2.setText(nodeValue);
    }

    public static org.w3c.dom.Node getParentNode(Node node2) {
        return DOMNodeHelper.asDOMNode(node2.getParent());
    }

    public static NodeList getChildNodes(Node node2) {
        return EMPTY_NODE_LIST;
    }

    public static org.w3c.dom.Node getFirstChild(Node node2) {
        return null;
    }

    public static org.w3c.dom.Node getLastChild(Node node2) {
        return null;
    }

    public static org.w3c.dom.Node getPreviousSibling(Node node2) {
        int index2;
        Element parent = node2.getParent();
        if (parent != null && (index2 = parent.indexOf(node2)) > 0) {
            Node previous = parent.node(index2 - 1);
            return DOMNodeHelper.asDOMNode(previous);
        }
        return null;
    }

    public static org.w3c.dom.Node getNextSibling(Node node2) {
        int index2;
        Element parent = node2.getParent();
        if (parent != null && (index2 = parent.indexOf(node2)) >= 0 && ++index2 < parent.nodeCount()) {
            Node next = parent.node(index2);
            return DOMNodeHelper.asDOMNode(next);
        }
        return null;
    }

    public static NamedNodeMap getAttributes(Node node2) {
        return null;
    }

    public static org.w3c.dom.Document getOwnerDocument(Node node2) {
        return DOMNodeHelper.asDOMDocument(node2.getDocument());
    }

    public static org.w3c.dom.Node insertBefore(Node node2, org.w3c.dom.Node newChild, org.w3c.dom.Node refChild) throws DOMException {
        if (node2 instanceof Branch) {
            assert (newChild instanceof Node);
            Branch branch = (Branch)node2;
            List<Node> list = branch.content();
            int index2 = list.indexOf(refChild);
            if (index2 < 0) {
                branch.add((Node)((Object)newChild));
            } else {
                list.add(index2, (Node)((Object)newChild));
            }
            return newChild;
        }
        throw new DOMException(3, "Children not allowed for this node: " + node2);
    }

    public static org.w3c.dom.Node replaceChild(Node node2, org.w3c.dom.Node newChild, org.w3c.dom.Node oldChild) throws DOMException {
        if (node2 instanceof Branch) {
            Branch branch = (Branch)node2;
            List<Node> list = branch.content();
            assert (newChild instanceof Node);
            int index2 = list.indexOf(oldChild);
            if (index2 < 0) {
                throw new DOMException(8, "Tried to replace a non existing child for node: " + node2);
            }
            list.set(index2, (Node)((Object)newChild));
            return oldChild;
        }
        throw new DOMException(3, "Children not allowed for this node: " + node2);
    }

    public static org.w3c.dom.Node removeChild(Node node2, org.w3c.dom.Node oldChild) throws DOMException {
        if (node2 instanceof Branch) {
            Branch branch = (Branch)node2;
            branch.remove((Node)((Object)oldChild));
            return oldChild;
        }
        throw new DOMException(3, "Children not allowed for this node: " + node2);
    }

    public static org.w3c.dom.Node appendChild(Node node2, org.w3c.dom.Node newChild) throws DOMException {
        if (node2 instanceof Branch) {
            Branch branch = (Branch)node2;
            org.w3c.dom.Node previousParent = newChild.getParentNode();
            if (previousParent != null) {
                previousParent.removeChild(newChild);
            }
            branch.add((Node)((Object)newChild));
            return newChild;
        }
        throw new DOMException(3, "Children not allowed for this node: " + node2);
    }

    public static boolean hasChildNodes(Node node2) {
        return false;
    }

    public static org.w3c.dom.Node cloneNode(Node node2, boolean deep) {
        return DOMNodeHelper.asDOMNode((Node)node2.clone());
    }

    public static void normalize(Node node2) {
        DOMNodeHelper.notSupported();
    }

    public static boolean isSupported(Node n, String feature, String version) {
        return false;
    }

    public static boolean hasAttributes(Node node2) {
        if (node2 != null && node2 instanceof Element) {
            return ((Element)node2).attributeCount() > 0;
        }
        return false;
    }

    public static String getData(CharacterData charData) throws DOMException {
        return charData.getText();
    }

    public static void setData(CharacterData charData, String data) throws DOMException {
        charData.setText(data);
    }

    public static int getLength(CharacterData charData) {
        String text2 = charData.getText();
        return text2 != null ? text2.length() : 0;
    }

    public static String substringData(CharacterData charData, int offset2, int count) throws DOMException {
        int length;
        if (count < 0) {
            throw new DOMException(1, "Illegal value for count: " + count);
        }
        String text2 = charData.getText();
        int n = length = text2 != null ? text2.length() : 0;
        if (offset2 < 0 || offset2 >= length) {
            throw new DOMException(1, "No text at offset: " + offset2);
        }
        if (offset2 + count > length) {
            return text2.substring(offset2);
        }
        return text2.substring(offset2, offset2 + count);
    }

    public static void appendData(CharacterData charData, String arg) throws DOMException {
        if (charData.isReadOnly()) {
            throw new DOMException(7, "CharacterData node is read only: " + charData);
        }
        String text2 = charData.getText();
        if (text2 == null) {
            charData.setText(arg);
        } else {
            charData.setText(text2 + arg);
        }
    }

    public static void insertData(CharacterData data, int offset2, String arg) throws DOMException {
        if (data.isReadOnly()) {
            throw new DOMException(7, "CharacterData node is read only: " + data);
        }
        String text2 = data.getText();
        if (text2 == null) {
            data.setText(arg);
        } else {
            int length = text2.length();
            if (offset2 < 0 || offset2 > length) {
                throw new DOMException(1, "No text at offset: " + offset2);
            }
            StringBuilder buffer = new StringBuilder(text2);
            buffer.insert(offset2, arg);
            data.setText(buffer.toString());
        }
    }

    public static void deleteData(CharacterData charData, int offset2, int count) throws DOMException {
        if (charData.isReadOnly()) {
            throw new DOMException(7, "CharacterData node is read only: " + charData);
        }
        if (count < 0) {
            throw new DOMException(1, "Illegal value for count: " + count);
        }
        String text2 = charData.getText();
        if (text2 != null) {
            int length = text2.length();
            if (offset2 < 0 || offset2 >= length) {
                throw new DOMException(1, "No text at offset: " + offset2);
            }
            StringBuilder buffer = new StringBuilder(text2);
            buffer.delete(offset2, offset2 + count);
            charData.setText(buffer.toString());
        }
    }

    public static void replaceData(CharacterData charData, int offset2, int count, String arg) throws DOMException {
        if (charData.isReadOnly()) {
            throw new DOMException(7, "CharacterData node is read only: " + charData);
        }
        if (count < 0) {
            throw new DOMException(1, "Illegal value for count: " + count);
        }
        String text2 = charData.getText();
        if (text2 != null) {
            int length = text2.length();
            if (offset2 < 0 || offset2 >= length) {
                throw new DOMException(1, "No text at offset: " + offset2);
            }
            StringBuilder buffer = new StringBuilder(text2);
            buffer.replace(offset2, offset2 + count, arg);
            charData.setText(buffer.toString());
        }
    }

    public static void appendElementsByTagName(List<? super Element> list, Branch parent, String name2) {
        boolean isStar = "*".equals(name2);
        int size = parent.nodeCount();
        for (int i2 = 0; i2 < size; ++i2) {
            Node node2 = parent.node(i2);
            if (!(node2 instanceof Element)) continue;
            Element element = (Element)node2;
            if (isStar || name2.equals(element.getName())) {
                list.add(element);
            }
            DOMNodeHelper.appendElementsByTagName(list, element, name2);
        }
    }

    public static void appendElementsByTagNameNS(List<? super Element> list, Branch parent, String namespace, String localName) {
        boolean isStarNS = "*".equals(namespace);
        boolean isStar = "*".equals(localName);
        int size = parent.nodeCount();
        for (int i2 = 0; i2 < size; ++i2) {
            Node node2 = parent.node(i2);
            if (!(node2 instanceof Element)) continue;
            Element element = (Element)node2;
            if ((isStarNS || (namespace == null || namespace.length() == 0) && (element.getNamespaceURI() == null || element.getNamespaceURI().length() == 0) || namespace != null && namespace.equals(element.getNamespaceURI())) && (isStar || localName.equals(element.getName()))) {
                list.add(element);
            }
            DOMNodeHelper.appendElementsByTagNameNS(list, element, namespace, localName);
        }
    }

    public static NodeList createNodeList(final List<Node> list) {
        return new NodeList(){

            @Override
            public org.w3c.dom.Node item(int index2) {
                if (index2 >= this.getLength()) {
                    return null;
                }
                return DOMNodeHelper.asDOMNode((Node)list.get(index2));
            }

            @Override
            public int getLength() {
                return list.size();
            }
        };
    }

    public static org.w3c.dom.Node asDOMNode(Node node2) {
        if (node2 == null) {
            return null;
        }
        if (node2 instanceof org.w3c.dom.Node) {
            return (org.w3c.dom.Node)((Object)node2);
        }
        System.out.println("Cannot convert: " + node2 + " into a W3C DOM Node");
        DOMNodeHelper.notSupported();
        return null;
    }

    public static org.w3c.dom.Document asDOMDocument(Document document) {
        if (document == null) {
            return null;
        }
        if (document instanceof org.w3c.dom.Document) {
            return (org.w3c.dom.Document)((Object)document);
        }
        DOMNodeHelper.notSupported();
        return null;
    }

    public static org.w3c.dom.DocumentType asDOMDocumentType(DocumentType dt) {
        if (dt == null) {
            return null;
        }
        if (dt instanceof org.w3c.dom.DocumentType) {
            return (org.w3c.dom.DocumentType)((Object)dt);
        }
        DOMNodeHelper.notSupported();
        return null;
    }

    public static Text asDOMText(CharacterData text2) {
        if (text2 == null) {
            return null;
        }
        if (text2 instanceof Text) {
            return (Text)((Object)text2);
        }
        DOMNodeHelper.notSupported();
        return null;
    }

    public static org.w3c.dom.Element asDOMElement(Node element) {
        if (element == null) {
            return null;
        }
        if (element instanceof org.w3c.dom.Element) {
            return (org.w3c.dom.Element)((Object)element);
        }
        DOMNodeHelper.notSupported();
        return null;
    }

    public static Attr asDOMAttr(Node attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute instanceof Attr) {
            return (Attr)((Object)attribute);
        }
        DOMNodeHelper.notSupported();
        return null;
    }

    public static void notSupported() {
        throw new DOMException(9, "Not supported yet");
    }

    public static boolean isStringEquals(String string1, String string2) {
        if (string1 == null && string2 == null) {
            return true;
        }
        if (string1 == null || string2 == null) {
            return false;
        }
        return string1.equals(string2);
    }

    public static boolean isNodeEquals(org.w3c.dom.Node node1, org.w3c.dom.Node node2) {
        if (node1 == null && node2 == null) {
            return true;
        }
        if (node1 == null || node2 == null) {
            return false;
        }
        if (node1.getNodeType() != node2.getNodeType()) {
            return false;
        }
        if (!DOMNodeHelper.isStringEquals(node1.getNodeName(), node2.getNodeName())) {
            return false;
        }
        if (!DOMNodeHelper.isStringEquals(node1.getLocalName(), node2.getLocalName())) {
            return false;
        }
        if (!DOMNodeHelper.isStringEquals(node1.getNamespaceURI(), node2.getNamespaceURI())) {
            return false;
        }
        if (!DOMNodeHelper.isStringEquals(node1.getPrefix(), node2.getPrefix())) {
            return false;
        }
        return DOMNodeHelper.isStringEquals(node1.getNodeValue(), node2.getNodeValue());
    }

    public static boolean isNodeSame(org.w3c.dom.Node node1, org.w3c.dom.Node node2) {
        return node1 == node2;
    }

    public static class EmptyNodeList
    implements NodeList {
        @Override
        public org.w3c.dom.Node item(int index2) {
            return null;
        }

        @Override
        public int getLength() {
            return 0;
        }
    }
}

