/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.elementa.impl.dom4j.bean;

import gg.essential.elementa.impl.dom4j.DocumentFactory;
import gg.essential.elementa.impl.dom4j.QName;
import gg.essential.elementa.impl.dom4j.bean.BeanAttributeList;
import gg.essential.elementa.impl.dom4j.bean.BeanDocumentFactory;
import gg.essential.elementa.impl.dom4j.bean.BeanElement;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class BeanMetaData {
    protected static final Object[] NULL_ARGS = new Object[0];
    private static Map<Class<?>, BeanMetaData> singletonCache = new HashMap();
    private static final DocumentFactory DOCUMENT_FACTORY = BeanDocumentFactory.getInstance();
    private Class<?> beanClass;
    private PropertyDescriptor[] propertyDescriptors;
    private QName[] qNames;
    private Method[] readMethods;
    private Method[] writeMethods;
    private Map<Object, Integer> nameMap = new HashMap<Object, Integer>();

    public BeanMetaData(Class<?> beanClass) {
        this.beanClass = beanClass;
        if (beanClass != null) {
            try {
                BeanInfo beanInfo = Introspector.getBeanInfo(beanClass);
                this.propertyDescriptors = beanInfo.getPropertyDescriptors();
            }
            catch (IntrospectionException e) {
                this.handleException(e);
            }
        }
        if (this.propertyDescriptors == null) {
            this.propertyDescriptors = new PropertyDescriptor[0];
        }
        int size = this.propertyDescriptors.length;
        this.qNames = new QName[size];
        this.readMethods = new Method[size];
        this.writeMethods = new Method[size];
        for (int i2 = 0; i2 < size; ++i2) {
            QName qName;
            PropertyDescriptor propertyDescriptor = this.propertyDescriptors[i2];
            String name2 = propertyDescriptor.getName();
            this.qNames[i2] = qName = DOCUMENT_FACTORY.createQName(name2);
            this.readMethods[i2] = propertyDescriptor.getReadMethod();
            this.writeMethods[i2] = propertyDescriptor.getWriteMethod();
            this.nameMap.put(name2, i2);
            this.nameMap.put(qName, i2);
        }
    }

    public static BeanMetaData get(Class<?> beanClass) {
        BeanMetaData answer = singletonCache.get(beanClass);
        if (answer == null) {
            answer = new BeanMetaData(beanClass);
            singletonCache.put(beanClass, answer);
        }
        return answer;
    }

    public int attributeCount() {
        return this.propertyDescriptors.length;
    }

    public BeanAttributeList createAttributeList(BeanElement parent) {
        return new BeanAttributeList(parent, this);
    }

    public QName getQName(int index2) {
        return this.qNames[index2];
    }

    public int getIndex(String name2) {
        Integer index2 = this.nameMap.get(name2);
        return index2 != null ? index2 : -1;
    }

    public int getIndex(QName qName) {
        Integer index2 = this.nameMap.get(qName);
        return index2 != null ? index2 : -1;
    }

    public Object getData(int index2, Object bean) {
        try {
            Method method = this.readMethods[index2];
            return method.invoke(bean, NULL_ARGS);
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    public void setData(int index2, Object bean, Object data) {
        try {
            Method method = this.writeMethods[index2];
            Object[] args = new Object[]{data};
            method.invoke(bean, args);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected void handleException(Exception e) {
    }
}

