/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.elementa.impl.commonmark.internal.inline;

import gg.essential.elementa.impl.commonmark.node.Emphasis;
import gg.essential.elementa.impl.commonmark.node.Node;
import gg.essential.elementa.impl.commonmark.node.Nodes;
import gg.essential.elementa.impl.commonmark.node.SourceSpans;
import gg.essential.elementa.impl.commonmark.node.StrongEmphasis;
import gg.essential.elementa.impl.commonmark.node.Text;
import gg.essential.elementa.impl.commonmark.parser.delimiter.DelimiterProcessor;
import gg.essential.elementa.impl.commonmark.parser.delimiter.DelimiterRun;

public abstract class EmphasisDelimiterProcessor
implements DelimiterProcessor {
    private final char delimiterChar;

    protected EmphasisDelimiterProcessor(char delimiterChar) {
        this.delimiterChar = delimiterChar;
    }

    @Override
    public char getOpeningCharacter() {
        return this.delimiterChar;
    }

    @Override
    public char getClosingCharacter() {
        return this.delimiterChar;
    }

    @Override
    public int getMinLength() {
        return 1;
    }

    @Override
    public int process(DelimiterRun openingRun, DelimiterRun closingRun) {
        Node emphasis;
        int usedDelimiters;
        if ((openingRun.canClose() || closingRun.canOpen()) && closingRun.originalLength() % 3 != 0 && (openingRun.originalLength() + closingRun.originalLength()) % 3 == 0) {
            return 0;
        }
        if (openingRun.length() >= 2 && closingRun.length() >= 2) {
            usedDelimiters = 2;
            emphasis = new StrongEmphasis(String.valueOf(this.delimiterChar) + this.delimiterChar);
        } else {
            usedDelimiters = 1;
            emphasis = new Emphasis(String.valueOf(this.delimiterChar));
        }
        SourceSpans sourceSpans = SourceSpans.empty();
        sourceSpans.addAllFrom(openingRun.getOpeners(usedDelimiters));
        Text opener = openingRun.getOpener();
        for (Node node2 : Nodes.between(opener, closingRun.getCloser())) {
            emphasis.appendChild(node2);
            sourceSpans.addAll(node2.getSourceSpans());
        }
        sourceSpans.addAllFrom(closingRun.getClosers(usedDelimiters));
        emphasis.setSourceSpans(sourceSpans.getSourceSpans());
        opener.insertAfter(emphasis);
        return usedDelimiters;
    }
}

