/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.data;

import gg.essential.data.MenuData;
import gg.essential.data.VersionData;
import gg.essential.gui.about.Category;
import gg.essential.gui.about.components.ChangelogComponent;
import gg.essential.lib.caffeine.cache.AsyncLoadingCache;
import gg.essential.lib.caffeine.cache.Caffeine;
import gg.essential.lib.gson.Gson;
import gg.essential.util.WebUtil;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001aB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\b\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\f\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\f\u0010\rR\"\u0010\u000f\u001a\n \u000e*\u0004\u0018\u00010\u00040\u00048\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R1\u0010\u0014\u001a\u001c\u0012\u0004\u0012\u00020\u0004\u0012\u0012\u0012\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\u00070\u00060\u00138\u0006\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017R#\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00040\u00138\u0006\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0015\u001a\u0004\b\u0019\u0010\u0017\u00a8\u0006\u001b"}, d2={"Lgg/essential/data/MenuData;", "", "<init>", "()V", "", "version", "Lkotlin/Pair;", "Lgg/essential/gui/about/components/ChangelogComponent$Changelog;", "fetchChangelogs", "(Ljava/lang/String;)Lkotlin/Pair;", "Lgg/essential/data/MenuData$FetchableCategory;", "category", "fetchInfo", "(Lgg/essential/data/MenuData$FetchableCategory;)Ljava/lang/String;", "kotlin.jvm.PlatformType", "BASE_URL", "Ljava/lang/String;", "getBASE_URL$Essential_1_18_2_forge", "()Ljava/lang/String;", "Lgg/essential/lib/caffeine/cache/AsyncLoadingCache;", "CHANGELOGS", "Lgg/essential/lib/caffeine/cache/AsyncLoadingCache;", "getCHANGELOGS", "()Lgg/essential/lib/caffeine/cache/AsyncLoadingCache;", "INFO", "getINFO", "FetchableCategory", "Essential 1.18.2-forge"})
public final class MenuData {
    @NotNull
    public static final MenuData INSTANCE = new MenuData();
    private static final String BASE_URL = System.getProperty("essential.api.url", System.getenv().getOrDefault("ESSENTIAL_API_URL", "https://api.essential.gg"));
    @NotNull
    private static final AsyncLoadingCache<String, Pair<String, ChangelogComponent.Changelog>> CHANGELOGS;
    @NotNull
    private static final AsyncLoadingCache<FetchableCategory, String> INFO;

    private MenuData() {
    }

    public final String getBASE_URL$Essential_1_18_2_forge() {
        return BASE_URL;
    }

    @NotNull
    public final AsyncLoadingCache<String, Pair<String, ChangelogComponent.Changelog>> getCHANGELOGS() {
        return CHANGELOGS;
    }

    @NotNull
    public final AsyncLoadingCache<FetchableCategory, String> getINFO() {
        return INFO;
    }

    private final Pair<String, ChangelogComponent.Changelog> fetchChangelogs(String version) {
        String string = URLEncoder.encode(version, StandardCharsets.UTF_8.toString());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encode(...)");
        String encodedVersion = StringsKt.replace$default((String)StringsKt.replace$default((String)string, (String)"+", (String)"%20", (boolean)false, (int)4, null), (String)"#", (String)"%23", (boolean)false, (int)4, null);
        String dataString = WebUtil.fetchString(BASE_URL + "/mods/v1/essential:essential/changelogs?branch=" + VersionData.INSTANCE.getEssentialBranch() + "&before=" + encodedVersion);
        ChangelogComponent.Changelog[] changelogArray = new Gson().fromJson(dataString, ChangelogComponent.Changelog[].class);
        Intrinsics.checkNotNullExpressionValue((Object)changelogArray, (String)"fromJson(...)");
        List data = ArraysKt.toList((Object[])changelogArray);
        String nextVersion = null;
        String previousVersion = version;
        ChangelogComponent.Changelog previousLog = null;
        for (ChangelogComponent.Changelog log2 : data) {
            if (previousLog != null) {
                CHANGELOGS.put(previousVersion, CompletableFuture.completedFuture(new Pair((Object)log2.getVersion(), (Object)previousLog)));
            } else {
                nextVersion = log2.getVersion();
            }
            previousLog = log2;
            previousVersion = log2.getVersion();
        }
        String versionResponse = WebUtil.fetchString(BASE_URL + "/mods/v1/essential:essential/versions/" + encodedVersion + "/changelog");
        return new Pair((Object)nextVersion, (Object)new Gson().fromJson(versionResponse, ChangelogComponent.Changelog.class));
    }

    private final String fetchInfo(FetchableCategory category2) {
        String data;
        String url = BASE_URL + "/v2/documents/";
        url = url + category2.getQuery();
        CharSequence charSequence = data = WebUtil.fetchString(url);
        Intrinsics.checkNotNull((Object)charSequence);
        if (StringsKt.contains$default((CharSequence)charSequence, (CharSequence)"Failed to fetch", (boolean)false, (int)2, null)) {
            INFO.asMap().remove((Object)category2);
            data = "An error occurred fetching this data. Please check your internet connection and try again.";
        }
        charSequence = data;
        Intrinsics.checkNotNull((Object)charSequence);
        charSequence = charSequence;
        Regex regex = new Regex("===.*");
        String string = "";
        charSequence = regex.replace(charSequence, string);
        regex = new Regex("\\{\\..*?}");
        string = "";
        charSequence = data = regex.replace(charSequence, string);
        Intrinsics.checkNotNull((Object)charSequence);
        return charSequence;
    }

    private static final Pair CHANGELOGS$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        return (Pair)$tmp0.invoke(p0);
    }

    private static final String INFO$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        return (String)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Pair access$fetchChangelogs(MenuData $this, String version) {
        return $this.fetchChangelogs(version);
    }

    public static final /* synthetic */ String access$fetchInfo(MenuData $this, FetchableCategory category2) {
        return $this.fetchInfo(category2);
    }

    static {
        AsyncLoadingCache<Object, Pair> asyncLoadingCache = Caffeine.newBuilder().expireAfterAccess(15L, TimeUnit.MINUTES).buildAsync(arg_0 -> MenuData.CHANGELOGS$lambda$0(CHANGELOGS.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue(asyncLoadingCache, (String)"buildAsync(...)");
        CHANGELOGS = asyncLoadingCache;
        AsyncLoadingCache<Object, String> asyncLoadingCache2 = Caffeine.newBuilder().expireAfterAccess(15L, TimeUnit.MINUTES).buildAsync(arg_0 -> MenuData.INFO$lambda$1(INFO.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue(asyncLoadingCache2, (String)"buildAsync(...)");
        INFO = asyncLoadingCache2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0019\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\b\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u000b\u001a\u0004\b\f\u0010\rj\u0002\b\u000e\u00a8\u0006\u000f"}, d2={"Lgg/essential/data/MenuData$FetchableCategory;", "", "Lgg/essential/gui/about/Category;", "category", "", "query", "<init>", "(Ljava/lang/String;ILgg/essential/gui/about/Category;Ljava/lang/String;)V", "Lgg/essential/gui/about/Category;", "getCategory", "()Lgg/essential/gui/about/Category;", "Ljava/lang/String;", "getQuery", "()Ljava/lang/String;", "PRIVACY", "Essential 1.18.2-forge"})
    public static final class FetchableCategory
    extends Enum<FetchableCategory> {
        @NotNull
        private final Category category;
        @NotNull
        private final String query;
        public static final /* enum */ FetchableCategory PRIVACY = new FetchableCategory(Category.PRIVACY, "privacy-policy");
        private static final /* synthetic */ FetchableCategory[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private FetchableCategory(Category category2, String query) {
            this.category = category2;
            this.query = query;
        }

        @NotNull
        public final Category getCategory() {
            return this.category;
        }

        @NotNull
        public final String getQuery() {
            return this.query;
        }

        public static FetchableCategory[] values() {
            return (FetchableCategory[])$VALUES.clone();
        }

        public static FetchableCategory valueOf(String value2) {
            return Enum.valueOf(FetchableCategory.class, value2);
        }

        @NotNull
        public static EnumEntries<FetchableCategory> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = fetchableCategoryArray = new FetchableCategory[]{FetchableCategory.PRIVACY};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

