/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.cosmetics.state;

import gg.essential.model.util.InstantKt;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007J\u0006\u0010\u000f\u001a\u00020\u0010R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lgg/essential/cosmetics/state/TextureAnimationSync;", "", "textureFrameCount", "", "(I)V", "animationOffsets", "", "", "currentLifetimeOffset", "lastTextureAdjustment", "mostRecentLifetime", "mostRecentSync", "", "getAdjustedLifetime", "lifetime", "syncTextureStart", "", "cosmetics"})
public final class TextureAnimationSync {
    private final int textureFrameCount;
    private float mostRecentLifetime;
    private long mostRecentSync;
    @NotNull
    private final List<Float> animationOffsets;
    private float currentLifetimeOffset;
    private float lastTextureAdjustment;

    public TextureAnimationSync(int textureFrameCount) {
        this.textureFrameCount = textureFrameCount;
        this.animationOffsets = new ArrayList();
    }

    public final float getAdjustedLifetime(float lifetime) {
        this.mostRecentSync = InstantKt.now().toEpochMilli();
        this.mostRecentLifetime = lifetime;
        if (this.animationOffsets.isEmpty()) {
            return lifetime;
        }
        float totalValues = 0.0f;
        float totalEntries = 0.0f;
        Iterator<Float> iterator = this.animationOffsets.iterator();
        while (iterator.hasNext()) {
            float animationOffset = ((Number)iterator.next()).floatValue();
            totalValues += animationOffset;
            float f = totalEntries;
            totalEntries = f + 1.0f;
        }
        float targetOffsetTime = totalValues / totalEntries;
        float totalAnimationTime = (float)this.textureFrameCount / 7.0f;
        float deltaTimeBackwards = targetOffsetTime - (this.currentLifetimeOffset + totalAnimationTime);
        float deltaTimeForwards = targetOffsetTime - this.currentLifetimeOffset;
        if ((double)(lifetime - this.lastTextureAdjustment) > 0.05) {
            float timeAdjustment = Math.abs(deltaTimeBackwards) < Math.abs(deltaTimeForwards) ? RangesKt.coerceIn((float)deltaTimeBackwards, (float)-0.01f, (float)0.01f) : RangesKt.coerceIn((float)deltaTimeForwards, (float)-0.01f, (float)0.01f);
            this.currentLifetimeOffset += timeAdjustment;
            this.lastTextureAdjustment = lifetime;
        }
        return lifetime + this.currentLifetimeOffset;
    }

    public final void syncTextureStart() {
        int totalFrames = this.textureFrameCount;
        float lifeTime = (float)(InstantKt.now().toEpochMilli() - this.mostRecentSync) / 1000.0f + this.mostRecentLifetime;
        int frame = (int)(lifeTime * 7.0f);
        int completedFrames = frame % totalFrames;
        float targetLifetimeOffset = (float)(totalFrames - completedFrames) / 7.0f;
        if (this.animationOffsets.size() > 3) {
            CollectionsKt.removeFirst(this.animationOffsets);
        }
        this.animationOffsets.add(Float.valueOf(targetLifetimeOffset));
    }
}

