/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.cosmetics.source;

import com.google.common.collect.ImmutableMap;
import gg.essential.cosmetics.EquippedCosmetic;
import gg.essential.cosmetics.source.CosmeticsSource;
import gg.essential.mod.cosmetics.CosmeticSlot;
import gg.essential.network.connectionmanager.cosmetics.CosmeticsManager;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public class LiveCosmeticsSource
implements CosmeticsSource {
    private final CosmeticsManager cosmeticsManager;
    private final UUID uuid;

    public LiveCosmeticsSource(CosmeticsManager cosmeticsManager, UUID uuid) {
        this.cosmeticsManager = cosmeticsManager;
        this.uuid = uuid;
    }

    @NotNull
    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    @NotNull
    public ImmutableMap<CosmeticSlot, EquippedCosmetic> getCosmetics() {
        return this.cosmeticsManager.getVisibleCosmetics(this.uuid);
    }

    @Override
    public boolean getShouldOverrideRenderCosmeticsCheck() {
        return false;
    }
}

