/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.cosmetics.skinmask;

import gg.essential.cosmetics.skinmask.SkinMask;
import gg.essential.lib.caffeine.cache.Cache;
import gg.essential.lib.caffeine.cache.Caffeine;
import gg.essential.lib.caffeine.cache.RemovalCause;
import gg.essential.lib.caffeine.cache.RemovalListener;
import gg.essential.lib.caffeine.cache.Scheduler;
import gg.essential.mixins.ext.client.renderer.PlayerSkinTextureExt;
import gg.essential.universal.UImage;
import gg.essential.universal.UMinecraft;
import gg.essential.util.ExtensionsKt;
import gg.essential.util.HelpersKt;
import gg.essential.util.Multithreading;
import gg.essential.util.image.bitmap.Bitmap;
import gg.essential.util.image.bitmap.GuiEssentialExtensionsKt;
import gg.essential.util.image.bitmap.UImageBitmap;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.HttpTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MaskedSkinProvider {
    private static final DynamicTextureManager dynamicTextureManager = new DynamicTextureManager();
    private ResourceLocation generatedSkin;
    private SkinMask generatedConfig;
    private ResourceLocation generatedId;

    public ResourceLocation provide(ResourceLocation skin, SkinMask config) {
        if (config.getParts().isEmpty() || !skin.m_135815_().startsWith("skins/")) {
            this.generatedSkin = null;
            this.generatedConfig = null;
            return null;
        }
        TextureManager textureManager = Minecraft.m_91087_().m_91097_();
        if (skin.equals((Object)this.generatedSkin) && config.equals(this.generatedConfig) && this.generatedId != null) {
            this.generatedConfig = config;
            dynamicTextureManager.keepAlive(this);
            return this.generatedId;
        }
        AbstractTexture skinTexture = textureManager.m_118506_(skin);
        if (skinTexture == null) {
            return null;
        }
        if (!(skinTexture instanceof PlayerSkinTextureExt)) {
            return null;
        }
        PlayerSkinTextureExt skinTextureExt = (PlayerSkinTextureExt)skinTexture;
        UImage skinImage = skinTextureExt.essential$getImage();
        if (skinImage == null) {
            return null;
        }
        Bitmap generatedTexture = config.apply(new UImageBitmap(skinImage));
        this.generatedSkin = skin;
        this.generatedConfig = config;
        this.generatedId = dynamicTextureManager.generateUniqueId(this.generatedSkin.toString().replace(':', '/'));
        dynamicTextureManager.register(this, this.generatedId, new MaskedSkinTexture(GuiEssentialExtensionsKt.toUImage(generatedTexture)));
        return this.generatedId;
    }

    void expireTexture(ResourceLocation id2) {
        if (id2.equals((Object)this.generatedId)) {
            this.generatedId = null;
        }
        Minecraft.m_91087_().m_91097_().m_118513_(id2);
    }

    private static class DynamicTextureManager
    implements RemovalListener<MaskedSkinProvider, ResourceLocation> {
        private final Cache<MaskedSkinProvider, ResourceLocation> loaded = Caffeine.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).executor(Multithreading.POOL).scheduler(Scheduler.forScheduledExecutorService(Multithreading.getScheduledPool())).removalListener(this).build();
        private int nextUniqueId;

        private DynamicTextureManager() {
        }

        public ResourceLocation generateUniqueId(String name2) {
            return HelpersKt.identifier("essential", String.format(Locale.ROOT, "masked_skins/%s/%d", name2, this.nextUniqueId++));
        }

        public void register(MaskedSkinProvider provider2, ResourceLocation id2, MaskedSkinTexture texture) {
            Minecraft.m_91087_().m_91097_().m_118495_(id2, (AbstractTexture)texture);
            this.loaded.put(provider2, id2);
        }

        public void keepAlive(MaskedSkinProvider provider2) {
            this.loaded.getIfPresent(provider2);
        }

        @Override
        public void onRemoval(@Nullable MaskedSkinProvider provider2, @Nullable ResourceLocation id2, @NotNull RemovalCause cause) {
            if (id2 == null || provider2 == null) {
                return;
            }
            ExtensionsKt.getExecutor(UMinecraft.getMinecraft()).execute(() -> provider2.expireTexture(id2));
        }
    }

    private static class MaskedSkinTexture
    extends HttpTexture {
        public MaskedSkinTexture(UImage image2) {
            super(null, "essential-masked-image", DefaultPlayerSkin.m_118626_(), false, null);
            ((PlayerSkinTextureExt)((Object)this)).essential$setImage(image2);
        }

        public void m_6704_(@NotNull ResourceManager resourceManager) {
        }
    }
}

