/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.cosmetics;

import com.mojang.blaze3d.vertex.PoseStack;
import gg.essential.config.EssentialConfig;
import gg.essential.cosmetics.EssentialModelRendererKt;
import gg.essential.cosmetics.WearablesManager;
import gg.essential.data.OnboardingData;
import gg.essential.gui.common.EmulatedUI3DPlayer;
import gg.essential.gui.elementa.state.v2.State;
import gg.essential.gui.elementa.state.v2.StateKt;
import gg.essential.handlers.EssentialSoundManager;
import gg.essential.mixins.ext.client.ParticleSystemHolder;
import gg.essential.mixins.impl.client.entity.AbstractClientPlayerExt;
import gg.essential.model.EnumPart;
import gg.essential.model.ModelAnimationState;
import gg.essential.model.ModelInstance;
import gg.essential.model.ParticleSystem;
import gg.essential.model.PlayerMolangQuery;
import gg.essential.model.backend.PlayerPose;
import gg.essential.model.backend.RenderBackend;
import gg.essential.model.backend.minecraft.MinecraftRenderBackend;
import gg.essential.model.backend.minecraft.PlayerPoseKt;
import gg.essential.network.cosmetics.Cosmetic;
import gg.essential.universal.UMatrixStack;
import gg.essential.universal.UMinecraft;
import gg.essential.util.ExtensionsKt;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EssentialModelRenderer
extends RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    public static boolean suppressCosmeticRendering = false;
    private final PlayerRenderer playerRenderer;

    public EssentialModelRenderer(PlayerRenderer playerRenderer) {
        super((RenderLayerParent)playerRenderer);
        this.playerRenderer = playerRenderer;
    }

    public static boolean cosmeticsShouldRender(AbstractClientPlayer player2) {
        double distance;
        if (!EssentialConfig.INSTANCE.getEssentialEnabled()) {
            return false;
        }
        if (((AbstractClientPlayerExt)player2).getCosmeticsSource().getShouldOverrideRenderCosmeticsCheck()) {
            return true;
        }
        if (EssentialConfig.INSTANCE.getHideCosmeticsWhenServerOverridesSkin() && ((AbstractClientPlayerExt)player2).isSkinOverrodeByServer()) {
            return false;
        }
        if (EssentialConfig.INSTANCE.getDisableCosmetics()) {
            return false;
        }
        if (suppressCosmeticRendering) {
            return false;
        }
        if (UMinecraft.getMinecraft().f_91074_ != null && (distance = (double)player2.m_20270_((Entity)UMinecraft.getMinecraft().f_91074_)) >= 4096.0) {
            return false;
        }
        return !player2.m_20145_() && !player2.m_5833_();
    }

    public void render(UMatrixStack matrixStack, RenderBackend.VertexConsumerProvider vertexConsumerProvider, @Nullable Set<EnumPart> parts, @NotNull AbstractClientPlayer player2) {
        if (!OnboardingData.hasAcceptedTos() || !EssentialConfig.INSTANCE.getEssentialEnabled()) {
            return;
        }
        AbstractClientPlayerExt abstractClientPlayerExt = (AbstractClientPlayerExt)player2;
        if (!EssentialModelRenderer.cosmeticsShouldRender(player2)) {
            return;
        }
        WearablesManager wearablesManager2 = abstractClientPlayerExt.getWearablesManager();
        Map<Cosmetic, ModelInstance> models = wearablesManager2.getModels();
        if (models.isEmpty()) {
            return;
        }
        PlayerPose pose = PlayerPoseKt.toPose(this.playerRenderer);
        MinecraftRenderBackend.SkinTexture skin = new MinecraftRenderBackend.SkinTexture(player2.m_108560_());
        matrixStack.push();
        if (parts == null) {
            parts = new HashSet<EnumPart>(Arrays.asList(EnumPart.values()));
        }
        matrixStack.translate(0.0f, 1.501f, 0.0f);
        wearablesManager2.render(ExtensionsKt.toCommon(matrixStack), vertexConsumerProvider, pose, skin, parts);
        EssentialModelRendererKt.renderForHoverOutline(wearablesManager2, ExtensionsKt.toCommon(matrixStack), vertexConsumerProvider, pose, skin, parts);
        matrixStack.pop();
        Level world = player2.f_19853_;
        ParticleSystem particleSystem2 = player2 instanceof EmulatedUI3DPlayer.EmulatedPlayer ? ((EmulatedUI3DPlayer.EmulatedPlayer)player2).getParticleSystem() : (world instanceof ParticleSystemHolder ? ((ParticleSystemHolder)world).getParticleSystem() : null);
        wearablesManager2.collectEvents((Function1<? super ModelAnimationState.Event, Unit>)((Function1)event -> {
            if (event instanceof ModelAnimationState.ParticleEvent) {
                if (particleSystem2 != null) {
                    particleSystem2.spawn((ModelAnimationState.ParticleEvent)event);
                }
            } else if (event instanceof ModelAnimationState.SoundEvent) {
                boolean enforceEmoteSoundSettings;
                State<Float> volume;
                boolean forceGlobal;
                if (player2 instanceof EmulatedUI3DPlayer.EmulatedPlayer) {
                    EmulatedUI3DPlayer component3 = ((EmulatedUI3DPlayer.EmulatedPlayer)player2).getEmulatedUI3DPlayer();
                    if (!component3.getSounds().getUntracked().booleanValue()) {
                        return Unit.INSTANCE;
                    }
                    forceGlobal = true;
                    volume = component3.getSoundsVolume();
                    enforceEmoteSoundSettings = false;
                } else {
                    forceGlobal = false;
                    volume = StateKt.stateOf(Float.valueOf(1.0f));
                    enforceEmoteSoundSettings = true;
                }
                EssentialSoundManager.INSTANCE.playSound((ModelAnimationState.SoundEvent)event, forceGlobal, volume, enforceEmoteSoundSettings);
            }
            return Unit.INSTANCE;
        }));
        abstractClientPlayerExt.setLastCosmeticsUpdateTime(new PlayerMolangQuery((Player)player2).getLifeTime());
    }

    public void render(@NotNull PoseStack vMatrixStack, @NotNull MultiBufferSource buffer, int light, @NotNull AbstractClientPlayer player2, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        UMatrixStack matrixStack = new UMatrixStack(vMatrixStack);
        MinecraftRenderBackend.VertexConsumerProvider vertexConsumerProvider = new MinecraftRenderBackend.VertexConsumerProvider(buffer, light);
        this.render(matrixStack, vertexConsumerProvider, null, player2);
    }
}

